/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.action.SortColumnAction;
import org.eclipse.nebula.widgets.nattable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;

public class DefaultSortConfiguration
implements IConfiguration {
    public static final String SORT_DOWN_CONFIG_TYPE = "SORT_DOWN";
    public static final String SORT_UP_CONFIG_TYPE = "SORT_UP";
    public static final String SORT_SEQ_CONFIG_TYPE = "SORT_SEQ_";
    private ICellPainter cellPainter;

    public DefaultSortConfiguration() {
        this(new BeveledBorderDecorator(new SortableHeaderTextPainter()));
    }

    public DefaultSortConfiguration(ICellPainter cellPainter) {
        this.cellPainter = cellPainter;
    }

    @Override
    public void configureLayer(ILayer layer) {
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, new DefaultComparator());
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, this.cellPainter, "NORMAL", SORT_DOWN_CONFIG_TYPE);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, this.cellPainter, "NORMAL", SORT_UP_CONFIG_TYPE);
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerSingleClickBinding(new MouseEventMatcher(65536, "COLUMN_HEADER".toString(), 1), new SortColumnAction(false));
        uiBindingRegistry.registerSingleClickBinding(new MouseEventMatcher(196608, "COLUMN_HEADER".toString(), 1), new SortColumnAction(true));
    }
}

