/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModelListener;

public abstract class AbstractTreeRowModel<T>
implements ITreeRowModel<T> {
    private final Collection<ITreeRowModelListener> listeners = new HashSet<ITreeRowModelListener>();
    private final ITreeData<T> treeData;

    public AbstractTreeRowModel(ITreeData<T> treeData) {
        this.treeData = treeData;
    }

    public void registerRowGroupModelListener(ITreeRowModelListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (ITreeRowModelListener listener : this.listeners) {
            listener.treeRowModelChanged();
        }
    }

    @Override
    public int depth(int index) {
        return this.treeData.getDepthOfData(this.treeData.getDataAtIndex(index));
    }

    @Override
    public boolean isLeaf(int index) {
        return !this.hasChildren(index);
    }

    @Override
    public String getObjectAtIndexAndDepth(int index, int depth) {
        return this.treeData.formatDataForDepth(depth, index);
    }

    @Override
    public boolean hasChildren(int index) {
        return this.treeData.hasChildren(index);
    }

    @Override
    public boolean isCollapseable(int index) {
        return this.hasChildren(index);
    }

    @Override
    public List<Integer> getChildIndexes(int parentIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<int> children = this.getDirectChildren((T)parentIndex);
        for (Object object : children) {
            int index = this.treeData.indexOf(object);
            if (index < 0) continue;
            result.add(index);
            result.addAll(this.getChildIndexes(index));
        }
        return result;
    }

    @Override
    public List<Integer> getDirectChildIndexes(int parentIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<int> children = this.getDirectChildren((T)parentIndex);
        for (Object object : children) {
            int index = this.treeData.indexOf(object);
            if (index < 0) continue;
            result.add(index);
        }
        return result;
    }

    @Override
    public List<T> getChildren(int parentIndex) {
        return this.getChildren(this.treeData.getDataAtIndex(parentIndex));
    }

    protected List<T> getChildren(T parent) {
        ArrayList<T> result = new ArrayList<T>();
        List<T> children = this.getDirectChildren(parent);
        for (T child : children) {
            result.add(child);
            result.addAll(this.getChildren(child));
        }
        return result;
    }

    @Override
    public List<T> getDirectChildren(int parentIndex) {
        return this.treeData.getChildren(parentIndex);
    }

    protected List<T> getDirectChildren(T parent) {
        return this.treeData.getChildren(parent);
    }

    protected ITreeData<T> getTreeData() {
        return this.treeData;
    }
}

