/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.matcher;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;

public class MouseEventMatcher
implements IMouseEventMatcher {
    public static final int LEFT_BUTTON = 1;
    public static final int RIGHT_BUTTON = 3;
    private final int stateMask;
    private final String regionName;
    private final int button;

    public MouseEventMatcher() {
        this(0, null, 0);
    }

    public MouseEventMatcher(String eventRegionName) {
        this(0, eventRegionName, 0);
    }

    public MouseEventMatcher(String eventRegion, int button) {
        this(0, eventRegion, button);
    }

    public MouseEventMatcher(int stateMask, String eventRegion) {
        this(stateMask, eventRegion, 0);
    }

    public MouseEventMatcher(int stateMask, String eventRegion, int button) {
        this.stateMask = stateMask;
        this.regionName = eventRegion;
        this.button = button;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        boolean buttonMatches;
        if (regionLabels == null) {
            return false;
        }
        boolean stateMaskMatches = this.stateMask != 0 ? event.stateMask == this.stateMask : event.stateMask == 0;
        boolean eventRegionMatches = this.regionName != null ? regionLabels.hasLabel(this.regionName) : true;
        boolean bl = this.button != 0 ? this.button == event.button : (buttonMatches = true);
        return stateMaskMatches && eventRegionMatches && buttonMatches;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MouseEventMatcher)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MouseEventMatcher rhs = (MouseEventMatcher)obj;
        return new EqualsBuilder().append(this.stateMask, rhs.stateMask).append((Object)this.regionName, (Object)rhs.regionName).append(this.button, rhs.button).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(43, 21).append(this.stateMask).append((Object)this.regionName).append(this.button).toHashCode();
    }

    public int getStateMask() {
        return this.stateMask;
    }

    public String getEventRegion() {
        return this.regionName;
    }

    public int getButton() {
        return this.button;
    }

    public static MouseEventMatcher columnHeaderLeftClick(int mask) {
        return new MouseEventMatcher(mask, "COLUMN_HEADER", 1);
    }

    public static MouseEventMatcher columnHeaderRightClick(int mask) {
        return new MouseEventMatcher(mask, "COLUMN_HEADER", 3);
    }

    public static MouseEventMatcher rowHeaderLeftClick(int mask) {
        return new MouseEventMatcher(mask, "ROW_HEADER", 1);
    }

    public static MouseEventMatcher rowHeaderRightClick(int mask) {
        return new MouseEventMatcher(mask, "ROW_HEADER", 3);
    }

    public static MouseEventMatcher bodyLeftClick(int mask) {
        return new MouseEventMatcher(mask, "BODY", 1);
    }

    public static MouseEventMatcher bodyRightClick(int mask) {
        return new MouseEventMatcher(mask, "BODY", 3);
    }

    public static MouseEventMatcher columnGroupHeaderLeftClick(int mask) {
        return new MouseEventMatcher(mask, "COLUMN_GROUP_HEADER", 1);
    }

    public static MouseEventMatcher columnGroupHeaderRightClick(int mask) {
        return new MouseEventMatcher(mask, "COLUMN_GROUP_HEADER", 3);
    }

    public static MouseEventMatcher rowGroupHeaderLeftClick(int mask) {
        return new MouseEventMatcher(mask, "ROW_GROUP_HEADER", 1);
    }

    public static MouseEventMatcher rowGroupHeaderRightClick(int mask) {
        return new MouseEventMatcher(mask, "ROW_GROUP_HEADER", 3);
    }
}

