/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.menu;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class PopupMenuBuilder {
    protected NatTable natTable;
    protected Menu popupMenu;

    public PopupMenuBuilder(NatTable parent) {
        this.natTable = parent;
        this.popupMenu = new Menu((Control)parent.getShell());
    }

    public PopupMenuBuilder(NatTable natTable, Menu menu) {
        this.natTable = natTable;
        this.popupMenu = menu;
    }

    public PopupMenuBuilder withMenuItemProvider(IMenuItemProvider menuItemProvider) {
        menuItemProvider.addMenuItem(this.natTable, this.popupMenu);
        return this;
    }

    public PopupMenuBuilder withHideColumnMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.hideColumnMenuItemProvider());
    }

    public PopupMenuBuilder withHideColumnMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.hideColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withShowAllColumnsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.showAllColumnsMenuItemProvider());
    }

    public PopupMenuBuilder withShowAllColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.showAllColumnsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withHideRowMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.hideRowMenuItemProvider());
    }

    public PopupMenuBuilder withHideRowMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.hideRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withShowAllRowsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.showAllRowsMenuItemProvider());
    }

    public PopupMenuBuilder withShowAllRowsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.showAllRowsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeColumnMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeRowMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnChooserMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.columnChooserMenuItemProvider());
    }

    public PopupMenuBuilder withColumnChooserMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.columnChooserMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnStyleEditor() {
        return this.withMenuItemProvider(MenuItemProviders.columnStyleEditorMenuItemProvider());
    }

    public PopupMenuBuilder withColumnStyleEditor(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.columnStyleEditorMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnRenameDialog() {
        return this.withMenuItemProvider(MenuItemProviders.renameColumnMenuItemProvider());
    }

    public PopupMenuBuilder withColumnRenameDialog(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.renameColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withCreateColumnGroupsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.createColumnGroupMenuItemProvider());
    }

    public PopupMenuBuilder withCreateColumnGroupsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.createColumnGroupMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withUngroupColumnsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.ungroupColumnsMenuItemProvider());
    }

    public PopupMenuBuilder withUngroupColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.ungroupColumnsMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withInspectLabelsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.inspectLabelsMenuItemProvider());
    }

    public PopupMenuBuilder withCategoriesBasedColumnChooser() {
        return this.withMenuItemProvider(MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider());
    }

    public PopupMenuBuilder withCategoriesBasedColumnChooser(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withClearAllFilters() {
        return this.withMenuItemProvider(MenuItemProviders.clearAllFiltersMenuItemProvider());
    }

    public PopupMenuBuilder withClearAllFilters(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.clearAllFiltersMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withToggleFilterRow() {
        return this.withMenuItemProvider(MenuItemProviders.clearToggleFilterRowMenuItemProvider());
    }

    public PopupMenuBuilder withToggleFilterRow(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.clearToggleFilterRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withStateManagerMenuItemProvider() {
        return this.withMenuItemProvider(MenuItemProviders.stateManagerMenuItemProvider());
    }

    public PopupMenuBuilder withStateManagerMenuItemProvider(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.stateManagerMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withSeparator() {
        return this.withMenuItemProvider(MenuItemProviders.separatorMenuItemProvider());
    }

    public Menu build() {
        return this.popupMenu;
    }
}

