/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.matchers.Matcher;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByTreeFormat;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.IGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.summaryrow.command.CalculateSummaryRowValuesCommand;
import org.eclipse.nebula.widgets.nattable.util.CalculatedValueCache;
import org.eclipse.nebula.widgets.nattable.util.ICalculatedValueCacheKey;
import org.eclipse.nebula.widgets.nattable.util.ICalculator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class GroupByDataLayer<T>
extends DataLayer
implements Observer {
    public static final String GROUP_BY_OBJECT = "GROUP_BY_OBJECT";
    public static final String GROUP_BY_COLUMN_PREFIX = "GROUP_BY_COLUMN_";
    public static final String GROUP_BY_SUMMARY = "GROUP_BY_SUMMARY";
    public static final String GROUP_BY_SUMMARY_COLUMN_PREFIX = "GROUP_BY_SUMMARY_COLUMN_";
    private final EventList<T> eventList;
    private final GlazedListTreeData<Object> treeData;
    private final GlazedListTreeRowModel<Object> treeRowModel;
    private final TreeList<Object> treeList;
    private final GroupByColumnAccessor<T> groupByColumnAccessor;
    private final IColumnAccessor<T> columnAccessor;
    private final GroupByTreeFormat<T> treeFormat;
    private final IConfigRegistry configRegistry;
    private CalculatedValueCache valueCache;
    private final Map<GroupByObject, FilterList<T>> filtersByGroup = new ConcurrentHashMap<GroupByObject, FilterList<T>>();

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor) {
        this(groupByModel, eventList, columnAccessor, null, true);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, boolean useDefaultConfiguration) {
        this(groupByModel, eventList, columnAccessor, null, useDefaultConfiguration);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        this(groupByModel, eventList, columnAccessor, configRegistry, true);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(groupByModel, eventList, columnAccessor, configRegistry, true, true);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry, boolean smoothUpdates, boolean useDefaultConfiguration) {
        this.eventList = eventList;
        this.columnAccessor = columnAccessor;
        groupByModel.addObserver(this);
        this.groupByColumnAccessor = new GroupByColumnAccessor<T>(columnAccessor);
        this.treeFormat = new GroupByTreeFormat<Object>(groupByModel, this.groupByColumnAccessor);
        this.treeList = new TreeList(eventList, this.treeFormat, (TreeList.ExpansionModel)new GroupByExpansionModel());
        this.treeData = new GlazedListTreeData<Object>(this.getTreeList());
        this.treeRowModel = new GlazedListTreeRowModel<Object>(this.treeData);
        this.configRegistry = configRegistry;
        this.valueCache = new CalculatedValueCache((ILayer)this, true, false, smoothUpdates);
        this.setDataProvider((IDataProvider)new GlazedListsDataProvider<Object>((EventList<Object>)this.getTreeList(), this.groupByColumnAccessor));
        if (useDefaultConfiguration) {
            this.addConfiguration((IConfiguration)new GroupByDataLayerConfiguration());
        }
    }

    public void setSortModel(ISortModel model) {
        this.treeFormat.setSortModel(model);
    }

    protected void updateTree() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                GroupByDataLayer.this.eventList.getReadWriteLock().writeLock().lock();
                try {
                    EventList temp = GlazedLists.eventList((Collection)GroupByDataLayer.this.eventList);
                    GroupByDataLayer.this.eventList.clear();
                    GroupByDataLayer.this.eventList.addAll((Collection)temp);
                }
                finally {
                    GroupByDataLayer.this.eventList.getReadWriteLock().writeLock().unlock();
                }
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateTree();
        this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)this));
    }

    public GlazedListTreeRowModel<Object> getTreeRowModel() {
        return this.treeRowModel;
    }

    public TreeList<Object> getTreeList() {
        return this.treeList;
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.treeData.getDataAtIndex(this.getRowIndexByPosition(rowPosition)) instanceof GroupByObject) {
            configLabels.addLabelOnTop(GROUP_BY_OBJECT);
            configLabels.addLabelOnTop(GROUP_BY_COLUMN_PREFIX + columnPosition);
            if (this.getGroupBySummaryProvider(configLabels) != null) {
                configLabels.addLabelOnTop(GROUP_BY_SUMMARY);
                configLabels.addLabelOnTop(GROUP_BY_SUMMARY_COLUMN_PREFIX + columnPosition);
            }
        }
        return configLabels;
    }

    public Object getDataValueByPosition(final int columnPosition, int rowPosition) {
        LabelStack labelStack = this.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (labelStack.hasLabel(GROUP_BY_OBJECT)) {
            String childCountPattern;
            GroupByObject groupByObject = (GroupByObject)this.treeData.getDataAtIndex(rowPosition);
            FilterList<T> children = null;
            final IGroupBySummaryProvider<T> summaryProvider = this.getGroupBySummaryProvider(labelStack);
            if (summaryProvider != null) {
                FilterList<T> c = children = this.getElementsInGroup(groupByObject);
                return this.valueCache.getCalculatedValue(columnPosition, rowPosition, (ICalculatedValueCacheKey)new GroupByValueCacheKey(columnPosition, rowPosition, groupByObject), true, new ICalculator((List)c){
                    private final /* synthetic */ List val$c;
                    {
                        this.val$c = list;
                    }

                    public Object executeCalculation() {
                        return summaryProvider.summarize(columnPosition, this.val$c);
                    }
                });
            }
            if (this.configRegistry != null && (childCountPattern = (String)this.configRegistry.getConfigAttribute(GroupByConfigAttributes.GROUP_BY_CHILD_COUNT_PATTERN, "NORMAL", labelStack.getLabels())) != null && childCountPattern.length() > 0) {
                if (children == null) {
                    children = this.getElementsInGroup(groupByObject);
                }
                int directChildCount = this.treeRowModel.getDirectChildren(rowPosition).size();
                return groupByObject.getValue() + " " + MessageFormat.format(childCountPattern, children.size(), directChildCount);
            }
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    public IGroupBySummaryProvider<T> getGroupBySummaryProvider(LabelStack labelStack) {
        if (this.configRegistry != null) {
            return (IGroupBySummaryProvider)this.configRegistry.getConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, "NORMAL", labelStack.getLabels());
        }
        return null;
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IVisualChangeEvent) {
            this.clearCache();
        }
        super.handleLayerEvent(event);
    }

    public void clearCache() {
        this.valueCache.clearCache();
    }

    public void killCache() {
        this.valueCache.killCache();
    }

    public boolean doCommand(ILayerCommand command) {
        if (command instanceof CalculateSummaryRowValuesCommand) {
            int i = 0;
            while (i < this.getRowCount()) {
                if (this.treeData.getDataAtIndex(i) instanceof GroupByObject) {
                    int j = 0;
                    while (j < this.getColumnCount()) {
                        LabelStack labelStack = this.getConfigLabelsByPosition(j, i);
                        final IGroupBySummaryProvider<T> summaryProvider = this.getGroupBySummaryProvider(labelStack);
                        if (summaryProvider != null) {
                            GroupByObject groupByObject = (GroupByObject)this.treeData.getDataAtIndex(i);
                            FilterList<T> children = this.getElementsInGroup(groupByObject);
                            final int col = j;
                            this.valueCache.getCalculatedValue(j, i, (ICalculatedValueCacheKey)new GroupByValueCacheKey(j, i, groupByObject), false, new ICalculator((List)children){
                                private final /* synthetic */ List val$children;
                                {
                                    this.val$children = list;
                                }

                                public Object executeCalculation() {
                                    return summaryProvider.summarize(col, this.val$children);
                                }
                            });
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else if (command instanceof DisposeResourcesCommand) {
            this.valueCache.dispose();
        }
        return super.doCommand(command);
    }

    public FilterList<T> getElementsInGroup(GroupByObject groupDescriptor) {
        FilterList elementsInGroup = this.filtersByGroup.get(groupDescriptor);
        if (elementsInGroup == null) {
            elementsInGroup = new FilterList(this.eventList, new GroupDescriptorMatcher<T>(groupDescriptor, this.columnAccessor));
            this.filtersByGroup.put(groupDescriptor, elementsInGroup);
        }
        return elementsInGroup;
    }

    private class GroupByExpansionModel
    implements TreeList.ExpansionModel<Object> {
        private GroupByExpansionModel() {
        }

        public boolean isExpanded(Object element, List<Object> path) {
            return true;
        }

        public void setExpanded(Object element, List<Object> path, boolean expanded) {
        }
    }

    class GroupByValueCacheKey
    implements ICalculatedValueCacheKey {
        private final int columnPosition;
        private final int rowPosition;
        private final GroupByObject groupBy;

        public GroupByValueCacheKey(int columnPosition, int rowPosition, GroupByObject groupBy) {
            this.columnPosition = columnPosition;
            this.rowPosition = rowPosition;
            this.groupBy = groupBy;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.columnPosition;
            result = 31 * result + (this.groupBy == null ? 0 : this.groupBy.hashCode());
            result = 31 * result + this.rowPosition;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupByValueCacheKey other = (GroupByValueCacheKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.columnPosition != other.columnPosition) {
                return false;
            }
            if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
                return false;
            }
            return this.rowPosition == other.rowPosition;
        }

        private GroupByDataLayer<T> getOuterType() {
            return GroupByDataLayer.this;
        }
    }

    public static class GroupDescriptorMatcher<T>
    implements Matcher<T> {
        private final GroupByObject group;
        private final IColumnAccessor<T> columnAccessor;

        public GroupDescriptorMatcher(GroupByObject group, IColumnAccessor<T> columnAccessor) {
            this.group = group;
            this.columnAccessor = columnAccessor;
        }

        public boolean matches(T element) {
            for (Map.Entry<Integer, Object> desc : this.group.getDescriptor()) {
                int columnIndex = desc.getKey();
                Object groupName = desc.getValue();
                if (groupName.equals(this.columnAccessor.getDataValue(element, columnIndex))) continue;
                return false;
            }
            return true;
        }
    }
}

