/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class GroupByModel
extends Observable
implements IPersistable {
    public static final String PERSISTENCE_KEY_GROUP_BY_COLUMN_INDEXES = ".groupByColumnIndexes";
    private List<Integer> groupByColumnIndexes = new ArrayList<Integer>();

    public boolean addGroupByColumnIndex(int columnIndex) {
        if (!this.groupByColumnIndexes.contains(columnIndex)) {
            this.groupByColumnIndexes.add(columnIndex);
            this.setChanged();
            this.notifyObservers();
            return true;
        }
        return false;
    }

    public boolean removeGroupByColumnIndex(int columnIndex) {
        if (this.groupByColumnIndexes.contains(columnIndex)) {
            this.groupByColumnIndexes.remove((Object)columnIndex);
            this.setChanged();
            this.notifyObservers();
            return true;
        }
        return false;
    }

    public void clearGroupByColumnIndexes() {
        this.groupByColumnIndexes.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public List<Integer> getGroupByColumnIndexes() {
        return this.groupByColumnIndexes;
    }

    public void saveState(String prefix, Properties properties) {
        if (this.groupByColumnIndexes.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : this.groupByColumnIndexes) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_GROUP_BY_COLUMN_INDEXES, strBuilder.toString());
        }
    }

    public void loadState(String prefix, Properties properties) {
        this.groupByColumnIndexes.clear();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_GROUP_BY_COLUMN_INDEXES);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                this.groupByColumnIndexes.add(Integer.valueOf(index));
            }
        }
        this.setChanged();
        this.notifyObservers();
    }
}

