/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;

public class GroupByObject
implements Comparable<GroupByObject> {
    private final List<Map.Entry<Integer, Object>> descriptor;
    private final Object value;

    public GroupByObject(Object value, List<Map.Entry<Integer, Object>> descriptor) {
        this.value = value;
        this.descriptor = descriptor;
    }

    public Object getValue() {
        return this.value;
    }

    public Collection<Map.Entry<Integer, Object>> getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int compareTo(GroupByObject o) {
        if (this.value.getClass().equals(o.value.getClass())) {
            return DefaultComparator.getInstance().compare(this.value, o.value);
        }
        return Integer.valueOf(this.descriptor.hashCode()).compareTo(o.descriptor.hashCode());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupByObject other = (GroupByObject)obj;
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

