/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import ca.odell.glazedlists.TreeList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;

public class GroupByTreeFormat<T>
implements TreeList.Format<Object> {
    private final GroupByModel model;
    private final IColumnAccessor<T> columnAccessor;
    private final GroupByComparator groupByComparator = new GroupByComparator();
    private ISortModel sortModel;

    public GroupByTreeFormat(GroupByModel model, IColumnAccessor<T> columnAccessor) {
        this.model = model;
        this.columnAccessor = columnAccessor;
    }

    public void getPath(List<Object> path, Object element) {
        List<Integer> groupByColumns = this.model.getGroupByColumnIndexes();
        if (!groupByColumns.isEmpty()) {
            ArrayList<AbstractMap.SimpleEntry<Integer, Object>> descriptor = new ArrayList<AbstractMap.SimpleEntry<Integer, Object>>();
            for (int columnIndex : groupByColumns) {
                Object columnValue = this.columnAccessor.getDataValue(element, columnIndex);
                descriptor.add(new AbstractMap.SimpleEntry<Integer, Object>(columnIndex, columnValue));
                GroupByObject groupByObject = new GroupByObject(columnValue, new ArrayList<Map.Entry<Integer, Object>>(descriptor));
                path.add(groupByObject);
            }
        }
        path.add(element);
    }

    public boolean allowsChildren(Object element) {
        return true;
    }

    public Comparator<Object> getComparator(int depth) {
        if (this.model.getGroupByColumnIndexes().isEmpty()) {
            return null;
        }
        return this.groupByComparator;
    }

    public void setSortModel(ISortModel model) {
        this.sortModel = model;
    }

    class GroupByComparator
    implements Comparator<Object> {
        GroupByComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            for (int columnIndex : GroupByTreeFormat.this.model.getGroupByColumnIndexes()) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                Object columnValue1 = null;
                Object columnValue2 = null;
                int result = 0;
                if (o1 instanceof GroupByObject && o2 instanceof GroupByObject) {
                    columnValue1 = o1;
                    columnValue2 = o2;
                    result = ((GroupByObject)o1).compareTo((GroupByObject)o2);
                    if (result != 0 && GroupByTreeFormat.this.sortModel != null) {
                        Iterator iterator = GroupByTreeFormat.this.sortModel.getSortedColumnIndexes().iterator();
                        while (iterator.hasNext()) {
                            int res;
                            int sortedColumnIndex = (Integer)iterator.next();
                            if (!(o1 instanceof GroupByObject) || !(o2 instanceof GroupByObject)) continue;
                            GroupByObject grp1 = (GroupByObject)o1;
                            GroupByObject grp2 = (GroupByObject)o2;
                            columnValue1 = GroupByTreeFormat.this.columnAccessor.getDataValue((Object)grp1, sortedColumnIndex);
                            columnValue2 = GroupByTreeFormat.this.columnAccessor.getDataValue((Object)grp2, sortedColumnIndex);
                            if (columnValue1 == null || columnValue2 == null || (res = DefaultComparator.getInstance().compare(columnValue1, columnValue2)) == 0) continue;
                            switch (GroupByTreeFormat.this.sortModel.getSortDirection(sortedColumnIndex)) {
                                case ASC: {
                                    result = res;
                                    break;
                                }
                                case DESC: {
                                    result = res * -1;
                                }
                            }
                        }
                    }
                } else if (o1 instanceof GroupByObject && !(o2 instanceof GroupByObject)) {
                    result = 1;
                } else if (!(o1 instanceof GroupByObject) && o2 instanceof GroupByObject) {
                    result = -1;
                } else {
                    columnValue1 = GroupByTreeFormat.this.columnAccessor.getDataValue(o1, columnIndex);
                    columnValue2 = GroupByTreeFormat.this.columnAccessor.getDataValue(o2, columnIndex);
                    result = DefaultComparator.getInstance().compare(columnValue1, columnValue2);
                }
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

