/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.StructuralRefreshCommand;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.conflation.EventConflaterChain;
import org.eclipse.nebula.widgets.nattable.conflation.IEventConflater;
import org.eclipse.nebula.widgets.nattable.conflation.VisualChangeEventConflater;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditorRegistry;
import org.eclipse.nebula.widgets.nattable.edit.CellEditorCreatedEvent;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.grid.command.InitializeGridCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.stack.DummyGridLayerStack;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.NatLayerPainter;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeManager;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.mode.ConfigurableModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.ModeSupport;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.command.RecalculateScrollBarsCommand;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class NatTable
extends Canvas
implements ILayer,
PaintListener,
IClientAreaProvider,
ILayerListener,
IPersistable {
    public static final int DEFAULT_STYLE_OPTIONS = 538182400;
    public static final String INITIAL_PAINT_COMPLETE_FLAG = "NatTable.initialPaintComplete";
    private UiBindingRegistry uiBindingRegistry;
    private ModeSupport modeSupport;
    private final EventConflaterChain conflaterChain = new EventConflaterChain();
    private final List<IOverlayPainter> overlayPainters = new ArrayList<IOverlayPainter>();
    private final List<IPersistable> persistables = new LinkedList<IPersistable>();
    private ILayer underlyingLayer;
    private IConfigRegistry configRegistry;
    protected final Collection<IConfiguration> configurations = new LinkedList<IConfiguration>();
    protected String id = GUIHelper.getSequenceNumber();
    private ILayerPainter layerPainter = new NatLayerPainter(this);
    private final boolean autoconfigure;
    private Listener closeEditorOnParentResize = new Listener(){

        public void handleEvent(Event event) {
            if (!NatTable.this.commitAndCloseActiveCellEditor()) {
                NatTable.this.getActiveCellEditor().close();
            }
        }
    };
    private boolean initialPaintComplete = false;
    private ThemeManager themeManager;
    private ICellEditor activeCellEditor;
    private final List<ILayerListener> listeners = new ArrayList<ILayerListener>();

    public NatTable(Composite parent) {
        this(parent, 538182400);
    }

    public NatTable(Composite parent, boolean autoconfigure) {
        this(parent, 538182400, autoconfigure);
    }

    public NatTable(Composite parent, ILayer layer) {
        this(parent, 538182400, layer);
    }

    public NatTable(Composite parent, ILayer layer, boolean autoconfigure) {
        this(parent, 538182400, layer, autoconfigure);
    }

    public NatTable(Composite parent, int style) {
        this(parent, style, new DummyGridLayerStack());
    }

    public NatTable(Composite parent, int style, boolean autoconfigure) {
        this(parent, style, new DummyGridLayerStack(), autoconfigure);
    }

    public NatTable(Composite parent, int style, ILayer layer) {
        this(parent, style, layer, true);
    }

    public NatTable(final Composite parent, int style, final ILayer layer, boolean autoconfigure) {
        super(parent, style);
        this.disableScrollBar(this.getHorizontalBar());
        this.disableScrollBar(this.getVerticalBar());
        this.initInternalListener();
        this.internalSetLayer(layer);
        this.autoconfigure = autoconfigure;
        if (autoconfigure) {
            this.configurations.add(new DefaultNatTableStyleConfiguration());
            this.configure();
        }
        this.conflaterChain.add(this.getVisualChangeEventConflater());
        this.conflaterChain.start();
        parent.addListener(11, this.closeEditorOnParentResize);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NatTable.this.doCommand(new DisposeResourcesCommand());
                NatTable.this.conflaterChain.stop();
                ActiveCellEditorRegistry.unregisterActiveCellEditor();
                layer.dispose();
                parent.removeListener(11, NatTable.this.closeEditorOnParentResize);
            }
        });
    }

    protected IEventConflater getVisualChangeEventConflater() {
        return new VisualChangeEventConflater(this);
    }

    private void disableScrollBar(ScrollBar scrollBar) {
        if (scrollBar != null) {
            scrollBar.setMinimum(0);
            scrollBar.setMaximum(1);
            scrollBar.setThumb(1);
            scrollBar.setEnabled(false);
        }
    }

    public ILayer getLayer() {
        return this.underlyingLayer;
    }

    public void setLayer(ILayer layer) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set layer post construction if autoconfigure is turned off");
        }
        this.internalSetLayer(layer);
    }

    private void internalSetLayer(ILayer layer) {
        if (layer != null) {
            this.underlyingLayer = layer;
            this.underlyingLayer.setClientAreaProvider(new IClientAreaProvider(){

                @Override
                public Rectangle getClientArea() {
                    final Rectangle clientArea = new Rectangle(0, 0, 0, 0);
                    if (!NatTable.this.isDisposed()) {
                        NatTable.this.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Rectangle natClientArea = NatTable.this.getClientArea();
                                clientArea.x = natClientArea.x;
                                clientArea.y = natClientArea.y;
                                clientArea.width = natClientArea.width;
                                clientArea.height = natClientArea.height;
                            }
                        });
                    }
                    return clientArea;
                }
            });
            this.underlyingLayer.addLayerListener(this);
        }
    }

    public void addConfiguration(IConfiguration configuration) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only add configurations post construction if autoconfigure is turned off");
        }
        this.configurations.add(configuration);
    }

    public IConfigRegistry getConfigRegistry() {
        if (this.configRegistry == null) {
            this.configRegistry = new ConfigRegistry();
            this.themeManager = new ThemeManager(this.configRegistry);
        }
        return this.configRegistry;
    }

    public void setConfigRegistry(IConfigRegistry configRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set config registry post construction if autoconfigure is turned off");
        }
        this.configRegistry = configRegistry;
        this.themeManager = new ThemeManager(configRegistry);
    }

    public UiBindingRegistry getUiBindingRegistry() {
        if (this.uiBindingRegistry == null) {
            this.uiBindingRegistry = new UiBindingRegistry(this);
        }
        return this.uiBindingRegistry;
    }

    public void setUiBindingRegistry(UiBindingRegistry uiBindingRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set UI binding registry post construction if autoconfigure is turned off");
        }
        this.uiBindingRegistry = uiBindingRegistry;
    }

    public String getID() {
        return this.id;
    }

    protected void checkSubclass() {
    }

    protected void initInternalListener() {
        this.modeSupport = new ModeSupport(this);
        this.modeSupport.registerModeEventHandler("NORMAL_MODE", new ConfigurableModeEventHandler(this.modeSupport, this));
        this.modeSupport.switchMode("NORMAL_MODE");
        this.addPaintListener(this);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                NatTable.this.redraw();
            }

            public void focusGained(FocusEvent arg0) {
                NatTable.this.redraw();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                NatTable.this.doCommand(new ClientAreaResizeCommand((Scrollable)NatTable.this));
                NatTable.this.redraw();
            }
        });
    }

    public boolean forceFocus() {
        return super.forceFocus();
    }

    public List<IOverlayPainter> getOverlayPainters() {
        return this.overlayPainters;
    }

    public void addOverlayPainter(IOverlayPainter overlayPainter) {
        this.overlayPainters.add(overlayPainter);
    }

    public void removeOverlayPainter(IOverlayPainter overlayPainter) {
        this.overlayPainters.remove(overlayPainter);
    }

    public void paintControl(PaintEvent event) {
        this.paintNatTable(event);
        this.initialPaintComplete = true;
    }

    private void paintNatTable(PaintEvent event) {
        this.getLayerPainter().paintLayer(this, event.gc, 0, 0, new Rectangle(event.x, event.y, event.width, event.height), this.getConfigRegistry());
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public void setLayerPainter(ILayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    public void repaintColumn(int columnPosition) {
        int xOffset = this.getStartXOfColumnPosition(columnPosition);
        if (xOffset < 0) {
            return;
        }
        this.redraw(xOffset, 0, this.getColumnWidthByPosition(columnPosition), this.getHeight(), true);
    }

    public void repaintRow(int rowPosition) {
        int yOffset = this.getStartYOfRowPosition(rowPosition);
        if (yOffset < 0) {
            return;
        }
        this.redraw(0, yOffset, this.getWidth(), this.getRowHeightByPosition(rowPosition), true);
    }

    public void repaintCell(int columnPosition, int rowPosition) {
        int xOffset = this.getStartXOfColumnPosition(columnPosition);
        int yOffset = this.getStartYOfRowPosition(rowPosition);
        this.redraw(xOffset, yOffset, this.getColumnWidthByPosition(columnPosition), this.getRowHeightByPosition(rowPosition), true);
    }

    public void updateResize() {
        this.updateResize(true);
    }

    private void updateResize(boolean redraw) {
        if (this.isDisposed()) {
            return;
        }
        this.doCommand(new RecalculateScrollBarsCommand());
        if (redraw) {
            this.redraw();
        }
    }

    public void refresh() {
        this.doCommand(new StructuralRefreshCommand());
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        throw new UnsupportedOperationException("Cannot use this method to configure NatTable. Use no-argument configure() instead.");
    }

    public void configure() {
        if (this.underlyingLayer == null) {
            throw new IllegalStateException("Layer must be set before configure is called");
        }
        if (this.underlyingLayer != null) {
            this.underlyingLayer.configure((ConfigRegistry)this.getConfigRegistry(), this.getUiBindingRegistry());
        }
        for (IConfiguration configuration : this.configurations) {
            configuration.configureLayer(this);
            configuration.configureRegistry(this.getConfigRegistry());
            configuration.configureUiBindings(this.getUiBindingRegistry());
        }
        this.doCommand(new InitializeGridCommand((Composite)this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        Range range;
        Collection<Range> ranges;
        IVisualChangeEvent update;
        for (ILayerListener layerListener : this.listeners) {
            layerListener.handleLayerEvent(event);
        }
        if (event instanceof CellVisualUpdateEvent) {
            update = (CellVisualUpdateEvent)event;
            this.repaintCell(((CellVisualChangeEvent)update).getColumnPosition(), ((CellVisualChangeEvent)update).getRowPosition());
            return;
        }
        if (event instanceof ColumnVisualUpdateEvent && (ranges = ((ColumnVisualChangeEvent)(update = (ColumnVisualUpdateEvent)event)).getColumnPositionRanges()).size() == 1) {
            range = ranges.iterator().next();
            if (range.end - range.start == 1) {
                this.repaintColumn(range.start);
                return;
            }
        }
        if (event instanceof RowVisualUpdateEvent && (ranges = ((RowVisualChangeEvent)(update = (RowVisualUpdateEvent)event)).getRowPositionRanges()).size() == 1) {
            range = ranges.iterator().next();
            if (range.end - range.start == 1) {
                this.repaintRow(range.start);
                return;
            }
        }
        if (event instanceof IVisualChangeEvent) {
            this.conflaterChain.addEvent(event);
        }
        if (event instanceof CellSelectionEvent) {
            Event e = new Event();
            e.widget = this;
            try {
                this.notifyListeners(13, e);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
            }
        }
        if (event instanceof CellEditorCreatedEvent) {
            CellEditorCreatedEvent editorEvent = (CellEditorCreatedEvent)event;
            this.activeCellEditor = editorEvent.getEditor();
            Control editorControl = this.activeCellEditor.getEditorControl();
            if (editorControl != null && !editorControl.isDisposed()) {
                editorControl.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        NatTable.this.activeCellEditor = null;
                        ActiveCellEditorRegistry.unregisterActiveCellEditor();
                    }
                });
            } else {
                this.activeCellEditor = null;
                ActiveCellEditorRegistry.unregisterActiveCellEditor();
            }
            ActiveCellEditorRegistry.registerActiveCellEditor(this.activeCellEditor);
        }
    }

    @Override
    public void saveState(final String prefix, final Properties properties) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                NatTable.this.underlyingLayer.saveState(prefix, properties);
            }
        });
    }

    @Override
    public void loadState(final String prefix, final Properties properties) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!NatTable.this.initialPaintComplete) {
                    properties.setProperty(NatTable.INITIAL_PAINT_COMPLETE_FLAG, "true");
                }
                NatTable.this.underlyingLayer.loadState(prefix, properties);
            }
        });
    }

    @Override
    public void registerPersistable(IPersistable persistable) {
        this.persistables.add(persistable);
    }

    @Override
    public void unregisterPersistable(IPersistable persistable) {
        this.persistables.remove(persistable);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        return this.underlyingLayer.doCommand(command);
    }

    @Override
    public void registerCommandHandler(ILayerCommandHandler<?> commandHandler) {
        this.underlyingLayer.registerCommandHandler(commandHandler);
    }

    @Override
    public void unregisterCommandHandler(Class<? extends ILayerCommand> commandClass) {
        this.underlyingLayer.unregisterCommandHandler(commandClass);
    }

    @Override
    public void fireLayerEvent(ILayerEvent event) {
        this.underlyingLayer.fireLayerEvent(event);
    }

    @Override
    public void addLayerListener(ILayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLayerListener(ILayerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean hasLayerListener(Class<? extends ILayerListener> layerListenerClass) {
        for (ILayerListener listener : this.listeners) {
            if (!listener.getClass().equals(layerListenerClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.underlyingLayer.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.underlyingLayer.getPreferredColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        return this.underlyingLayer.getColumnIndexByPosition(columnPosition);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return localColumnPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return -1;
        }
        return underlyingColumnPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return null;
        }
        return underlyingColumnPositionRanges;
    }

    @Override
    public int getWidth() {
        return this.underlyingLayer.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.underlyingLayer.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.underlyingLayer.getColumnWidthByPosition(columnPosition);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.underlyingLayer.isColumnPositionResizable(columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.underlyingLayer.getColumnPositionByX(x);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.underlyingLayer.getStartXOfColumnPosition(columnPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.underlyingLayer);
        return underlyingLayers;
    }

    @Override
    public int getRowCount() {
        return this.underlyingLayer.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.underlyingLayer.getPreferredRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        return this.underlyingLayer.getRowIndexByPosition(rowPosition);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        return localRowPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return -1;
        }
        return underlyingRowPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return null;
        }
        return underlyingRowPositionRanges;
    }

    @Override
    public int getHeight() {
        return this.underlyingLayer.getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.underlyingLayer.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return this.underlyingLayer.getRowHeightByPosition(rowPosition);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        return this.underlyingLayer.isRowPositionResizable(rowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return this.underlyingLayer.getRowPositionByY(y);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.underlyingLayer.getStartYOfRowPosition(rowPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.underlyingLayer);
        return underlyingLayers;
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getCellByPosition(columnPosition, rowPosition);
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getBoundsByPosition(columnPosition, rowPosition);
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getDataValueByPosition(columnPosition, rowPosition);
    }

    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        return this.underlyingLayer.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        return this.underlyingLayer.getRegionLabelsByXY(x, y);
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer;
    }

    @Override
    public IClientAreaProvider getClientAreaProvider() {
        return this;
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        this.underlyingLayer.setClientAreaProvider(clientAreaProvider);
    }

    public void addDragSupport(int operations, Transfer[] transferTypes, final DragSourceListener listener) {
        DragSource dragSource = new DragSource((Control)this, operations);
        dragSource.setTransfer(transferTypes);
        DragSourceListener wrapper = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                listener.dragStart(event);
            }

            public void dragSetData(DragSourceEvent event) {
                listener.dragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
                listener.dragFinished(event);
                NatTable.this.modeSupport.switchMode("NORMAL_MODE");
            }
        };
        dragSource.addDragListener(wrapper);
    }

    public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        DropTarget dropTarget = new DropTarget((Control)this, operations);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener(listener);
    }

    public void setTheme(ThemeConfiguration themeConfiguration) {
        this.themeManager.applyTheme(themeConfiguration);
        this.doCommand(new VisualRefreshCommand());
    }

    public ICellEditor getActiveCellEditor() {
        return this.activeCellEditor;
    }

    public boolean commitAndCloseActiveCellEditor() {
        if (this.activeCellEditor != null) {
            return this.activeCellEditor.commit(SelectionLayer.MoveDirectionEnum.NONE, true);
        }
        return true;
    }
}

