/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;

public class LayerCell
extends AbstractLayerCell {
    private ILayer layer;
    private int columnPosition;
    private int rowPosition;
    private int originColumnPosition;
    private int originRowPosition;
    private int columnSpan;
    private int rowSpan;

    public LayerCell(ILayer layer, int columnPosition, int rowPosition, DataCell cell) {
        this(layer, cell.columnPosition, cell.rowPosition, columnPosition, rowPosition, cell.columnSpan, cell.rowSpan);
    }

    public LayerCell(ILayer layer, int columnPosition, int rowPosition) {
        this(layer, columnPosition, rowPosition, columnPosition, rowPosition, 1, 1);
    }

    public LayerCell(ILayer layer, int originColumnPosition, int originRowPosition, int columnPosition, int rowPosition, int columnSpan, int rowSpan) {
        this.layer = layer;
        this.originColumnPosition = originColumnPosition;
        this.originRowPosition = originRowPosition;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
        this.columnSpan = columnSpan;
        this.rowSpan = rowSpan;
    }

    @Override
    public int getOriginColumnPosition() {
        return this.originColumnPosition;
    }

    @Override
    public int getOriginRowPosition() {
        return this.originRowPosition;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    @Override
    public int getColumnPosition() {
        return this.columnPosition;
    }

    @Override
    public int getRowPosition() {
        return this.rowPosition;
    }

    @Override
    public int getColumnIndex() {
        return this.getLayer().getColumnIndexByPosition(this.getColumnPosition());
    }

    @Override
    public int getRowIndex() {
        return this.getLayer().getRowIndexByPosition(this.getRowPosition());
    }

    @Override
    public int getColumnSpan() {
        return this.columnSpan;
    }

    @Override
    public int getRowSpan() {
        return this.rowSpan;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LayerCell)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LayerCell rhs = (LayerCell)obj;
        return new EqualsBuilder().append((Object)this.layer, (Object)rhs.layer).append(this.originColumnPosition, rhs.originColumnPosition).append(this.originRowPosition, rhs.originRowPosition).append(this.columnSpan, rhs.columnSpan).append(this.rowSpan, rhs.rowSpan).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(771, 855).append((Object)this.layer).append(this.originColumnPosition).append(this.originRowPosition).append(this.columnSpan).append(this.rowSpan).toHashCode();
    }

    public String toString() {
        return "LayerCell: [Data: " + this.getDataValue() + ", layer: " + this.getLayer().getClass().getSimpleName() + ", originColumnPosition: " + this.getOriginColumnPosition() + ", originRowPosition: " + this.getOriginRowPosition() + ", columnSpan: " + this.getColumnSpan() + ", rowSpan: " + this.getRowSpan() + "]";
    }
}

