/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.preserve;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class Selections<T> {
    private Map<Serializable, Row> selectedRows = new HashMap<Serializable, Row>();
    private Map<Integer, Column> selectedColumns = new HashMap<Integer, Column>();

    Selections() {
    }

    void select(Serializable rowId, T rowObject, int columnPosition) {
        Row row = this.retrieveRow(rowId, rowObject);
        row.addItem(columnPosition);
        Column column = this.retrieveColumn(columnPosition);
        column.addItem(rowId);
    }

    void deselect(Serializable rowId, int columnPosition) {
        Column column;
        Row row = this.getSelectedColumns(rowId);
        if (row != null) {
            row.removeItem(columnPosition);
            if (!row.hasSelection()) {
                this.selectedRows.remove(rowId);
            }
        }
        if ((column = this.getSelectedRows(columnPosition)) != null) {
            column.removeItem(rowId);
            if (!column.hasSelection()) {
                this.selectedColumns.remove(columnPosition);
            }
        }
    }

    void clear() {
        this.selectedRows.clear();
        this.selectedColumns.clear();
    }

    Collection<Row> getRows() {
        return this.selectedRows.values();
    }

    List<Integer> getColumnPositions() {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.selectedColumns.keySet());
        Collections.sort(keys);
        return keys;
    }

    Column getSelectedRows(int columnPosition) {
        return this.selectedColumns.get(columnPosition);
    }

    Row getSelectedColumns(Serializable rowId) {
        return this.selectedRows.get(rowId);
    }

    Collection<CellPosition<T>> getSelections() {
        ArrayList<CellPosition<T>> selectedCells = new ArrayList<CellPosition<T>>();
        for (Row row : this.selectedRows.values()) {
            for (Integer columnPosition : row.getItems()) {
                CellPosition cell = new CellPosition(row.getRowObject(), columnPosition);
                selectedCells.add(cell);
            }
        }
        return selectedCells;
    }

    boolean isSelected(Serializable rowId, int columnPosition) {
        if (this.isRowSelected(rowId)) {
            return this.getSelectedColumns(rowId).contains(columnPosition);
        }
        return false;
    }

    boolean isRowSelected(Serializable rowId) {
        return this.selectedRows.containsKey(rowId);
    }

    boolean isEmpty() {
        return this.selectedRows.isEmpty();
    }

    private Row retrieveRow(Serializable rowId, T rowObject) {
        Row row = this.getSelectedColumns(rowId);
        if (row == null) {
            row = new Row(rowId, rowObject);
            this.selectedRows.put(rowId, row);
        }
        return row;
    }

    private Column retrieveColumn(int columnPosition) {
        Column column = this.getSelectedRows(columnPosition);
        if (column == null) {
            column = new Column(columnPosition);
            this.selectedColumns.put(columnPosition, column);
        }
        return column;
    }

    static class CellPosition<T> {
        private final int columnPosition;
        private final T rowObject;

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.columnPosition;
            result = 31 * result + (this.rowObject == null ? 0 : this.rowObject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellPosition other = (CellPosition)obj;
            if (this.columnPosition != other.columnPosition) {
                return false;
            }
            return !(this.rowObject == null ? other.rowObject != null : !this.rowObject.equals(other.rowObject));
        }

        CellPosition(T rowObject, int columnPosition) {
            this.rowObject = rowObject;
            this.columnPosition = columnPosition;
        }

        T getRowObject() {
            return this.rowObject;
        }

        Integer getColumnPosition() {
            return this.columnPosition;
        }
    }

    class Column
    extends Line<Integer, Serializable> {
        Column(Integer columnPosition) {
            super(columnPosition);
        }
    }

    static class Line<I, S> {
        private final I lineId;
        private HashSet<S> content = new HashSet();

        Line(I lineId) {
            this.lineId = lineId;
        }

        Collection<S> getItems() {
            return this.content;
        }

        void addItem(S item) {
            this.content.add(item);
        }

        void removeItem(S item) {
            this.content.remove(item);
        }

        boolean contains(S item) {
            return this.content.contains(item);
        }

        boolean hasSelection() {
            return !this.content.isEmpty();
        }

        I getId() {
            return this.lineId;
        }
    }

    class Row
    extends Line<Serializable, Integer> {
        private final T rowObject;

        Row(Serializable rowId, T rowObject) {
            super(rowId);
            this.rowObject = rowObject;
        }

        T getRowObject() {
            return this.rowObject;
        }
    }
}

