/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.nebula.widgets.nattable.persistence.ColorPersistor;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;

public class BorderStyle {
    private int thickness = 1;
    private Color color = GUIHelper.COLOR_BLACK;
    private LineStyleEnum lineStyle = LineStyleEnum.SOLID;

    public BorderStyle() {
    }

    public BorderStyle(int thickness, Color color, LineStyleEnum lineStyle) {
        this.thickness = thickness;
        this.color = color;
        this.lineStyle = lineStyle;
    }

    public BorderStyle(String string) {
        String[] tokens = string.split("\\|");
        this.thickness = Integer.parseInt(tokens[0]);
        this.color = ColorPersistor.asColor(tokens[1]);
        this.lineStyle = LineStyleEnum.valueOf(tokens[2]);
    }

    public int getThickness() {
        return this.thickness;
    }

    public Color getColor() {
        return this.color;
    }

    public LineStyleEnum getLineStyle() {
        return this.lineStyle;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLineStyle(LineStyleEnum lineStyle) {
        this.lineStyle = lineStyle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BorderStyle)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BorderStyle that = (BorderStyle)obj;
        return new EqualsBuilder().append(this.thickness, that.thickness).append((Object)this.color, (Object)that.color).append((Object)this.lineStyle.name(), (Object)that.lineStyle.name()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(87, 19).append(this.thickness).append((Object)this.color).append((Object)this.lineStyle.name()).toHashCode();
    }

    public String toString() {
        return String.valueOf(this.thickness) + "|" + ColorPersistor.asString(this.color) + "|" + (Object)((Object)this.lineStyle);
    }

    public static enum LineStyleEnum {
        SOLID,
        DASHED,
        DOTTED,
        DASHDOT,
        DASHDOTDOT;


        public static int toSWT(LineStyleEnum line) {
            if (line == null) {
                throw new IllegalArgumentException("null");
            }
            if (line.equals((Object)SOLID)) {
                return 1;
            }
            if (line.equals((Object)DASHED)) {
                return 2;
            }
            if (line.equals((Object)DOTTED)) {
                return 3;
            }
            if (line.equals((Object)DASHDOT)) {
                return 4;
            }
            if (line.equals((Object)DASHDOTDOT)) {
                return 5;
            }
            return 1;
        }
    }
}

