/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderPainter;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.command.GroupByColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.command.UngroupByColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;

public class GroupByHeaderLayer
extends DimensionallyDependentLayer {
    public static final String GROUP_BY_REGION = "GROUP_BY_REGION";
    private final GroupByModel groupByModel;
    private GroupByHeaderPainter groupByHeaderPainter;
    private boolean visible = true;

    public GroupByHeaderLayer(GroupByModel groupByModel, ILayer gridLayer, IDataProvider columnHeaderDataProvider) {
        super((IUniqueIndexLayer)new DataLayer(new IDataProvider(){

            public Object getDataValue(int columnIndex, int rowIndex) {
                return null;
            }

            public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            }

            public int getRowCount() {
                return 1;
            }

            public int getColumnCount() {
                return 1;
            }
        }));
        this.setHorizontalLayerDependency(gridLayer);
        this.setVerticalLayerDependency((ILayer)this.getBaseLayer());
        this.groupByModel = groupByModel;
        this.registerPersistable(this.groupByModel);
        this.registerCommandHandler((ILayerCommandHandler)new GroupByColumnCommandHandler(this));
        this.registerCommandHandler((ILayerCommandHandler)new UngroupByColumnCommandHandler(this));
        GroupByHeaderConfiguration configuration = new GroupByHeaderConfiguration(groupByModel, columnHeaderDataProvider);
        this.addConfiguration((IConfiguration)configuration);
        this.groupByHeaderPainter = configuration.getGroupByHeaderPainter();
        ((DataLayer)this.getBaseLayer()).setRowHeightByPosition(0, this.groupByHeaderPainter.getPreferredHeight());
    }

    public GroupByModel getGroupByModel() {
        return this.groupByModel;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)this.getBaseLayer()));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getHeight() {
        if (this.visible) {
            return super.getHeight();
        }
        return 0;
    }

    public int getRowHeightByPosition(int rowPosition) {
        if (this.visible) {
            return super.getRowHeightByPosition(rowPosition);
        }
        return 0;
    }

    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        return new LayerCell((ILayer)this, 0, 0, 0, 0, this.getColumnCount(), 1);
    }

    public int getGroupByColumnIndexAtXY(int x, int y) {
        return this.groupByHeaderPainter.getGroupByColumnIndexAtXY(x, y);
    }
}

