/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.poi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.extension.poi.ExcelCellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.VerticalTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;

public abstract class PoiExcelExporter
implements ILayerExporter {
    private final IOutputStreamProvider outputStreamProvider;
    private Map<ExcelCellStyleAttributes, CellStyle> xlCellStyles;
    protected Workbook xlWorkbook;
    protected int sheetNumber;
    protected Sheet xlSheet;
    protected Row xlRow;
    private boolean applyBackgroundColor = true;
    private boolean applyVerticalTextConfiguration = false;

    public PoiExcelExporter(IOutputStreamProvider outputStreamProvider) {
        this.outputStreamProvider = outputStreamProvider;
    }

    public OutputStream getOutputStream(Shell shell) {
        return this.outputStreamProvider.getOutputStream(shell);
    }

    public void exportBegin(OutputStream outputStream) throws IOException {
        this.xlCellStyles = new HashMap<ExcelCellStyleAttributes, CellStyle>();
        this.xlWorkbook = this.createWorkbook();
    }

    public void exportEnd(OutputStream outputStream) throws IOException {
        this.xlWorkbook.write(outputStream);
        this.xlCellStyles = null;
        this.xlWorkbook = null;
        this.sheetNumber = 0;
        this.xlSheet = null;
        this.xlRow = null;
    }

    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
        ++this.sheetNumber;
        if (layerName == null || layerName.length() == 0) {
            layerName = "Sheet" + this.sheetNumber;
        }
        this.xlSheet = this.xlWorkbook.createSheet(layerName);
    }

    public void exportLayerEnd(OutputStream outputStream, String layerName) throws IOException {
    }

    public void exportRowBegin(OutputStream outputStream, int rowPosition) throws IOException {
        this.xlRow = this.xlSheet.createRow(rowPosition);
    }

    public void exportRowEnd(OutputStream outputStream, int rowPosition) throws IOException {
    }

    public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
        boolean vertical;
        int columnPosition = cell.getColumnPosition();
        int rowPosition = cell.getRowPosition();
        if (columnPosition != cell.getOriginColumnPosition() || rowPosition != cell.getOriginRowPosition()) {
            return;
        }
        Cell xlCell = this.xlRow.createCell(columnPosition);
        int columnSpan = cell.getColumnSpan();
        int rowSpan = cell.getRowSpan();
        if (columnSpan > 1 || rowSpan > 1) {
            int lastRow = rowPosition + rowSpan - 1;
            int lastColumn = columnPosition + columnSpan - 1;
            this.xlSheet.addMergedRegion(new CellRangeAddress(rowPosition, lastRow, columnPosition, lastColumn));
        }
        CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, "NORMAL", cell.getConfigLabels().getLabels());
        Color fg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        org.eclipse.swt.graphics.Font font = (org.eclipse.swt.graphics.Font)cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        FontData fontData = font.getFontData()[0];
        String dataFormat = null;
        int hAlign = HorizontalAlignmentEnum.getSWTStyle((IStyle)cellStyle);
        int vAlign = VerticalAlignmentEnum.getSWTStyle((IStyle)cellStyle);
        boolean bl = vertical = this.applyVerticalTextConfiguration ? this.isVertical((ICellPainter)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", cell.getConfigLabels().getLabels())) : false;
        if (exportDisplayValue == null) {
            exportDisplayValue = "";
        }
        if (exportDisplayValue instanceof Boolean) {
            xlCell.setCellValue(((Boolean)exportDisplayValue).booleanValue());
        } else if (exportDisplayValue instanceof Calendar) {
            dataFormat = this.getDataFormatString(cell, configRegistry);
            xlCell.setCellValue((Calendar)exportDisplayValue);
        } else if (exportDisplayValue instanceof Date) {
            dataFormat = this.getDataFormatString(cell, configRegistry);
            xlCell.setCellValue((Date)exportDisplayValue);
        } else if (exportDisplayValue instanceof Number) {
            xlCell.setCellValue(((Number)exportDisplayValue).doubleValue());
        } else {
            xlCell.setCellValue(exportDisplayValue.toString());
        }
        CellStyle xlCellStyle = this.getExcelCellStyle(fg, bg, fontData, dataFormat, hAlign, vAlign, vertical);
        xlCell.setCellStyle(xlCellStyle);
    }

    private boolean isVertical(ICellPainter cellPainter) {
        if (cellPainter instanceof VerticalTextPainter) {
            return true;
        }
        if (cellPainter instanceof CellPainterWrapper) {
            return this.isVertical(((CellPainterWrapper)cellPainter).getWrappedPainter());
        }
        if (cellPainter instanceof CellPainterDecorator) {
            return this.isVertical(((CellPainterDecorator)cellPainter).getBaseCellPainter()) || this.isVertical(((CellPainterDecorator)cellPainter).getDecoratorCellPainter());
        }
        return false;
    }

    private CellStyle getExcelCellStyle(Color fg, Color bg, FontData fontData, String dataFormat, int hAlign, int vAlign, boolean vertical) {
        CellStyle xlCellStyle = this.xlCellStyles.get(new ExcelCellStyleAttributes(fg, bg, fontData, dataFormat, hAlign, vAlign, vertical));
        if (xlCellStyle == null) {
            xlCellStyle = this.xlWorkbook.createCellStyle();
            if (this.applyBackgroundColor) {
                this.setFillForegroundColor(xlCellStyle, bg);
                xlCellStyle.setFillPattern((short)1);
            }
            Font xlFont = this.xlWorkbook.createFont();
            this.setFontColor(xlFont, fg);
            xlFont.setFontName(fontData.getName());
            xlFont.setFontHeightInPoints((short)fontData.getHeight());
            xlCellStyle.setFont(xlFont);
            if (vertical) {
                xlCellStyle.setRotation((short)90);
            }
            switch (hAlign) {
                case 0x1000000: {
                    xlCellStyle.setAlignment((short)2);
                    break;
                }
                case 16384: {
                    xlCellStyle.setAlignment((short)1);
                    break;
                }
                case 131072: {
                    xlCellStyle.setAlignment((short)3);
                }
            }
            switch (vAlign) {
                case 128: {
                    xlCellStyle.setVerticalAlignment((short)0);
                    break;
                }
                case 0x1000000: {
                    xlCellStyle.setVerticalAlignment((short)1);
                    break;
                }
                case 1024: {
                    xlCellStyle.setVerticalAlignment((short)2);
                }
            }
            if (dataFormat != null) {
                CreationHelper createHelper = this.xlWorkbook.getCreationHelper();
                xlCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(dataFormat));
            }
            this.xlCellStyles.put(new ExcelCellStyleAttributes(fg, bg, fontData, dataFormat, hAlign, vAlign, vertical), xlCellStyle);
        }
        return xlCellStyle;
    }

    protected String getDataFormatString(ILayerCell cell, IConfigRegistry configRegistry) {
        String dataFormat = (String)configRegistry.getConfigAttribute(ExportConfigAttributes.DATE_FORMAT, "NORMAL", cell.getConfigLabels().getLabels());
        if (dataFormat == null) {
            dataFormat = "m/d/yy h:mm";
        }
        return dataFormat;
    }

    public void setApplyBackgroundColor(boolean applyBackgroundColor) {
        this.applyBackgroundColor = applyBackgroundColor;
    }

    public void setApplyVerticalTextConfiguration(boolean inspectVertical) {
        this.applyVerticalTextConfiguration = inspectVertical;
    }

    protected abstract Workbook createWorkbook();

    protected abstract void setFillForegroundColor(CellStyle var1, Color var2);

    protected abstract void setFontColor(Font var1, Color var2);

    public Object getResult() {
        return this.outputStreamProvider.getResult();
    }
}

