/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import java.util.Date;
import java.util.Locale;
import org.eclipse.nebula.widgets.datechooser.AbstractCombo;
import org.eclipse.nebula.widgets.datechooser.DateChooser;
import org.eclipse.nebula.widgets.datechooser.DateChooserTheme;
import org.eclipse.nebula.widgets.formattedtext.DateFormatter;
import org.eclipse.nebula.widgets.formattedtext.DefaultFormatterFactory;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class DateChooserCombo
extends AbstractCombo {
    protected static final String IMAGE = "/org/eclipse/nebula/widgets/datechooser/DateChooserCombo.png";
    protected static Image buttonImage;
    protected FormattedText formattedText;
    protected boolean footerVisible = false;
    protected int gridVisible = 2;
    protected boolean weeksVisible = false;
    protected DateChooserTheme theme;
    protected Locale locale;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Display display = Display.getCurrent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.nebula.widgets.datechooser.DateChooserCombo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        buttonImage = new Image((Device)display, clazz.getResourceAsStream(IMAGE));
    }

    public DateChooserCombo(Composite parent, int style) {
        super(parent, style);
        this.setTheme(DateChooserTheme.getDefaultTheme());
        this.setImage(buttonImage);
        this.setCreateOnDrop(true);
        this.pack();
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        this.text.addKeyListener(listener);
    }

    protected void beforeDrop() {
        Date d = (Date)this.formattedText.getValue();
        DateChooser cal = (DateChooser)this.popupContent;
        if (d != null) {
            cal.setSelectedDate(d);
            cal.setFocusOnDate(d);
        } else {
            cal.clearSelection();
            cal.setFocusOnToday(false);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = new Point(wHint, hHint);
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point buttonSize = this.button.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        if (wHint == -1) {
            GC gc = new GC((Drawable)this.formattedText.getControl());
            int width = gc.textExtent((String)"01/01/2000 ").x;
            gc.dispose();
            size.x = width + buttonSize.x + 2 * borderWidth;
        }
        if (hHint == -1) {
            if (WIN32) {
                buttonSize.y = ((GridData)this.button.getLayoutData()).heightHint;
            }
            size.y = Math.max(textSize.y, buttonSize.y) + 2 * borderWidth;
        }
        return size;
    }

    protected Button createButtonControl(int style) {
        return new Button((Composite)this, (style &= 0xFFFFFBFB) | 8);
    }

    protected Control createPopupContent(Composite parent) {
        DateChooser cal = new DateChooser(parent, 0);
        cal.setTheme(this.theme);
        if (this.locale != null) {
            cal.setLocale(this.locale);
        }
        cal.setGridVisible(this.gridVisible);
        cal.setFooterVisible(this.footerVisible);
        cal.setWeeksVisible(this.weeksVisible);
        cal.setAutoSelectOnFooter(true);
        cal.pack();
        return cal;
    }

    protected Text createTextControl(int style) {
        this.formattedText = new FormattedText((Composite)this, 0);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.formattedText.setFormatter(DefaultFormatterFactory.createFormatter((Class)clazz));
        return this.formattedText.getControl();
    }

    protected boolean doSelection() {
        this.formattedText.setValue((Object)((DateChooser)this.popupContent).getSelectedDate());
        return true;
    }

    protected void dropDown(boolean drop) {
        super.dropDown(drop);
        if (drop && GTK) {
            this.popupContent.traverse(16);
        }
    }

    public int getGridVisible() {
        this.checkWidget();
        return this.gridVisible;
    }

    public Date getValue() {
        this.checkWidget();
        return (Date)this.formattedText.getValue();
    }

    public boolean isFooterVisible() {
        this.checkWidget();
        return this.footerVisible;
    }

    public boolean isGridVisible() {
        this.checkWidget();
        return this.gridVisible == 2;
    }

    public boolean isWeeksVisible() {
        this.checkWidget();
        return this.weeksVisible;
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        this.formattedText.getControl().removeKeyListener(listener);
    }

    public void setFooterVisible(boolean footerVisible) {
        this.checkWidget();
        this.footerVisible = footerVisible;
    }

    public void setFormatter(DateFormatter formatter) {
        this.checkWidget();
        this.formattedText.setFormatter((ITextFormatter)formatter);
        this.locale = formatter.getLocale();
    }

    public void setGridVisible(boolean gridVisible) {
        this.setGridVisible(gridVisible ? 2 : 0);
    }

    public void setGridVisible(int gridVisible) {
        this.gridVisible = gridVisible;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image == null) {
            SWT.error((int)4);
        }
        GridData buttonLayout = (GridData)this.button.getLayoutData();
        if (WIN32) {
            ImageData id = image.getImageData();
            buttonLayout.widthHint = id.width + 4;
            buttonLayout.heightHint = id.height + 6;
        }
        this.button.setImage(image);
        this.pack();
    }

    public void setLocale(Locale locale) {
        this.checkWidget();
        this.locale = locale;
        ((DateFormatter)this.formattedText.getFormatter()).setLocale(locale);
    }

    public void setTheme(DateChooserTheme theme) {
        this.checkWidget();
        if (theme == null) {
            SWT.error((int)4);
        }
        this.theme = theme;
        this.gridVisible = theme.gridVisible;
    }

    public void setValue(Date value) {
        this.checkWidget();
        this.formattedText.setValue((Object)value);
    }

    public void setWeeksVisible(boolean weeksVisible) {
        this.checkWidget();
        this.weeksVisible = weeksVisible;
    }
}

