/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import java.util.Date;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.nebula.widgets.datechooser.DateChooser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DateChooserObservableValue
extends AbstractObservableValue {
    protected final DateChooser dateChooser;
    private final int updateEventType;
    private boolean updating = false;
    private Date oldValue;
    private Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            Date newValue;
            if (!DateChooserObservableValue.this.updating && ((newValue = DateChooserObservableValue.this.dateChooser.getSelectedDate()) == null && DateChooserObservableValue.this.oldValue != null || newValue != null && !newValue.equals(DateChooserObservableValue.this.oldValue))) {
                DateChooserObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)DateChooserObservableValue.this.oldValue, (Object)newValue));
                DateChooserObservableValue.this.oldValue = newValue;
            }
        }
    };
    private static final int[] validUpdateEventTypes = new int[]{13};
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            DateChooserObservableValue.this.dispose();
        }
    };
    static /* synthetic */ Class class$0;

    public DateChooserObservableValue(DateChooser dateChooser, int updateEventType) {
        this(SWTObservables.getRealm((Display)dateChooser.getDisplay()), dateChooser, updateEventType);
    }

    public DateChooserObservableValue(Realm realm, DateChooser dateChooser, int updateEventType) {
        super(realm);
        boolean eventValid = false;
        int i = 0;
        while (!eventValid && i < validUpdateEventTypes.length) {
            eventValid = updateEventType == validUpdateEventTypes[i];
            ++i;
        }
        if (!eventValid) {
            throw new IllegalArgumentException("UpdateEventType [" + updateEventType + "] is not supported.");
        }
        this.dateChooser = dateChooser;
        this.updateEventType = updateEventType;
        if (updateEventType != 0) {
            dateChooser.addListener(updateEventType, this.updateListener);
        }
        dateChooser.addDisposeListener(this.disposeListener);
    }

    public void dispose() {
        if (!this.dateChooser.isDisposed() && this.updateEventType != 0) {
            this.dateChooser.removeListener(this.updateEventType, this.updateListener);
        }
        super.dispose();
    }

    protected Object doGetValue() {
        this.oldValue = this.dateChooser.getSelectedDate();
        return this.oldValue;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doSetValue(Object value) {
        try {
            this.updating = true;
            this.dateChooser.setSelectedDate((Date)value);
            this.oldValue = this.dateChooser.getSelectedDate();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.updating = false;
            return;
        }
    }

    public Object getValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

