/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.formattedtext;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.nebula.widgets.formattedtext.AbstractFormatter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DateTimeFormatter
extends AbstractFormatter {
    protected static Hashtable cachedPatterns = new Hashtable();
    private static NumberFormat nf = NumberFormat.getIntegerInstance();
    protected Calendar calendar;
    protected SimpleDateFormat sdfDisplay;
    protected StringBuffer inputMask;
    protected StringBuffer inputCache;
    protected FieldDesc[] fields;
    protected int fieldCount;
    protected int yearStart;
    protected KeyListener klistener;
    protected FocusListener flistener;
    protected Listener modifyFilter;
    protected Locale locale;
    static /* synthetic */ Class class$0;

    static {
        nf.setGroupingUsed(false);
    }

    public DateTimeFormatter() {
        this(null, null, Locale.getDefault());
    }

    public DateTimeFormatter(Locale loc) {
        this(null, null, loc);
    }

    public DateTimeFormatter(String editPattern) {
        this(editPattern, null, Locale.getDefault());
    }

    public DateTimeFormatter(String editPattern, Locale loc) {
        this(editPattern, null, loc);
    }

    public DateTimeFormatter(String editPattern, String displayPattern) {
        this(editPattern, displayPattern, Locale.getDefault());
    }

    public DateTimeFormatter(String editPattern, String displayPattern, Locale loc) {
        this.calendar = Calendar.getInstance(loc);
        if (this.yearStart == -1) {
            this.calendar.setTime(this.sdfDisplay.get2DigitYearStart());
            this.yearStart = this.calendar.get(1) % 100;
        }
        this.calendar.setTimeInMillis(0L);
        if (editPattern == null) {
            editPattern = this.getDefaultEditPattern(loc);
        }
        this.compile(editPattern);
        if (displayPattern == null) {
            displayPattern = editPattern;
        }
        this.sdfDisplay = new SimpleDateFormat(displayPattern, loc);
        this.locale = loc;
        this.klistener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask != 0) {
                    return;
                }
                switch (e.keyCode) {
                    case 0x1000001: {
                        DateTimeFormatter.this.arrow(1);
                        break;
                    }
                    case 0x1000002: {
                        DateTimeFormatter.this.arrow(-1);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                e.doit = false;
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        this.flistener = new FocusListener(){
            String lastInput;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void focusGained(FocusEvent e) {
                int p = DateTimeFormatter.this.text.getCaretPosition();
                DateTimeFormatter.this.setInputCache();
                String t = DateTimeFormatter.this.inputCache.toString();
                if (t.equals(this.lastInput)) return;
                Display display = DateTimeFormatter.this.text.getDisplay();
                try {
                    display.addFilter(24, DateTimeFormatter.this.modifyFilter);
                    DateTimeFormatter.this.updateText(DateTimeFormatter.this.inputCache.toString(), p);
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    display.removeFilter(24, DateTimeFormatter.this.modifyFilter);
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                }
                display.removeFilter(24, DateTimeFormatter.this.modifyFilter);
            }

            public void focusLost(FocusEvent e) {
                if (DateTimeFormatter.this.text != null) {
                    this.lastInput = DateTimeFormatter.this.text.getText();
                }
            }
        };
        this.modifyFilter = new Listener(){

            public void handleEvent(Event event) {
                event.type = 0;
            }
        };
    }

    private int ajustMask(int b, int e, int l) {
        char c = this.inputMask.charAt(b);
        while (e - b + 1 < l) {
            this.inputMask.insert(e++, c);
        }
        while (e - b + 1 > l) {
            this.inputMask.deleteCharAt(e--);
        }
        return e;
    }

    private void arrow(int inc) {
        int l;
        int p = this.text.getCaretPosition();
        if (p == (l = this.inputMask.length())) {
            return;
        }
        char m = this.inputMask.charAt(p);
        if (m == '*') {
            return;
        }
        FieldDesc f = this.getField(p, 0);
        int b = f.pos;
        if (this.countValid() == 0) {
            this.setValue(new Date());
        } else if (f.field == 1 && f.maxLen <= 2) {
            int year;
            this.calendar.set(f.field, year += (year = this.calendar.get(1) % 100 + inc) >= this.yearStart ? 1900 : 2000);
        } else {
            this.calendar.add(f.field, inc);
        }
        this.setInputCache();
        this.locateField(f, 0);
        this.ignore = true;
        this.updateText(this.inputCache.toString(), Math.min(f.pos + p - b, f.pos + f.curLen - 1));
        this.ignore = false;
    }

    private void clear(int b, int e) {
        int i = b;
        int from = 0;
        while (i < e) {
            char m = this.inputMask.charAt(i);
            if (m == '*') {
                from = ++i;
                continue;
            }
            FieldDesc field = this.getField(i, from);
            while (i < e && field.curLen > 0) {
                this.inputCache.deleteCharAt(i);
                this.inputMask.deleteCharAt(i);
                --e;
                --field.curLen;
            }
            while (field.curLen < field.minLen) {
                this.inputCache.insert(field.pos + field.curLen, ' ');
                this.inputMask.insert(field.pos + field.curLen, field.index);
                ++i;
                ++e;
                ++field.curLen;
            }
            this.updateFieldValue(field, false);
        }
    }

    private void compile(String editPattern) {
        this.inputMask = new StringBuffer();
        this.inputCache = new StringBuffer();
        this.fields = new FieldDesc[10];
        int fi = 0;
        int length = editPattern.length();
        int i = 0;
        while (i < length) {
            block15: {
                char c = editPattern.charAt(i);
                int l = 1;
                while (i < length - 1 && editPattern.charAt(i + 1) == c) {
                    ++i;
                    ++l;
                }
                this.isValidCharPattern(c);
                switch (c) {
                    case 'y': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 1;
                        this.fields[fi].maxLen = l <= 2 ? 2 : 4;
                        this.fields[fi].minLen = this.fields[fi].maxLen;
                        if (this.fields[fi].maxLen != 2) break;
                        this.yearStart = -1;
                        break;
                    }
                    case 'M': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 2;
                        this.fields[fi].minLen = Math.min(l, 2);
                        this.fields[fi].maxLen = 2;
                        break;
                    }
                    case 'd': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 5;
                        this.fields[fi].minLen = Math.min(l, 2);
                        this.fields[fi].maxLen = 2;
                        break;
                    }
                    case 'H': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 11;
                        this.fields[fi].minLen = Math.min(l, 2);
                        this.fields[fi].maxLen = 2;
                        break;
                    }
                    case 'h': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 10;
                        this.fields[fi].minLen = Math.min(l, 2);
                        this.fields[fi].maxLen = 2;
                        break;
                    }
                    case 'm': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 12;
                        this.fields[fi].minLen = Math.min(l, 2);
                        this.fields[fi].maxLen = 2;
                        break;
                    }
                    case 's': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 13;
                        this.fields[fi].minLen = Math.min(l, 2);
                        this.fields[fi].maxLen = 2;
                        break;
                    }
                    case 'S': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 14;
                        this.fields[fi].minLen = Math.min(l, 3);
                        this.fields[fi].maxLen = 3;
                        break;
                    }
                    case 'a': {
                        this.fields[fi] = new FieldDesc();
                        this.fields[fi].field = 9;
                        this.fields[fi].maxLen = 2;
                        this.fields[fi].minLen = 2;
                        break;
                    }
                    default: {
                        int j = 0;
                        while (j < l) {
                            this.inputMask.append('*');
                            this.inputCache.append(c);
                            ++j;
                        }
                        break block15;
                    }
                }
                this.fields[fi].empty = true;
                this.fields[fi].valid = false;
                this.calendar.clear(this.fields[fi].field);
                char k = (char)(48 + fi);
                int j = 0;
                while (j < this.fields[fi].minLen) {
                    this.inputMask.append(k);
                    this.inputCache.append(' ');
                    ++j;
                }
                this.fields[fi].index = k;
                ++fi;
            }
            ++i;
        }
        this.fieldCount = fi;
    }

    private int countValid() {
        int count = 0;
        int i = 0;
        while (i < this.fieldCount) {
            if (this.fields[i].valid) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void detach() {
        this.text.removeKeyListener(this.klistener);
        this.text.removeFocusListener(this.flistener);
    }

    public String getDefaultEditPattern(Locale loc) {
        String key;
        String pattern;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if ((pattern = (String)cachedPatterns.get(key = "DT" + loc.toString())) == null) {
            int i;
            DateFormat df = DateFormat.getDateTimeInstance(3, 3, loc);
            if (!(df instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("No default pattern for locale " + loc.getDisplayName());
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(((SimpleDateFormat)df).toPattern());
            if (buffer.indexOf("yyy") < 0 && (i = buffer.indexOf("yy")) >= 0) {
                buffer.insert(i, "yy");
            }
            pattern = buffer.toString();
            cachedPatterns.put(key, pattern);
        }
        return pattern;
    }

    public String getDisplayString() {
        return this.isValid() ? this.sdfDisplay.format(this.calendar.getTime()) : this.getEditString();
    }

    public String getEditString() {
        return this.inputCache.toString();
    }

    private FieldDesc getField(int p, int from) {
        if (p >= this.inputMask.length()) {
            p = this.inputMask.length() - 1;
        }
        char c = this.inputMask.charAt(p);
        while (c == '*') {
            if (--p < 0) {
                return null;
            }
            c = this.inputMask.charAt(p);
        }
        FieldDesc f = this.fields[c - 48];
        this.locateField(f, from);
        return f;
    }

    /*
     * Unable to fully structure code
     */
    private String getFormattedValue(FieldDesc f) {
        block7: {
            value = new StringBuffer();
            if (!f.valid) ** GOTO lbl26
            v = this.calendar.get(f.field);
            switch (f.field) {
                case 2: {
                    ++v;
                    break;
                }
                case 10: {
                    if (v != 0) break;
                    v = 12;
                    break;
                }
                case 9: {
                    return this.sdfDisplay.getDateFormatSymbols().getAmPmStrings()[v];
                }
            }
            value.append(v);
            if (value.length() <= f.maxLen) ** GOTO lbl22
            value.delete(0, value.length() - f.maxLen);
            break block7;
lbl-1000:
            // 1 sources

            {
                value.insert(0, '0');
lbl22:
                // 2 sources

                ** while (value.length() < f.minLen)
            }
lbl23:
            // 1 sources

            break block7;
lbl-1000:
            // 1 sources

            {
                value.append(' ');
lbl26:
                // 2 sources

                ** while (value.length() < f.minLen)
            }
        }
        return value.toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getValue() {
        return this.isValid() ? this.calendar.getTime() : null;
    }

    public Class getValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private int insert(String txt, int p) {
        FieldDesc fd = null;
        int i = 0;
        int from = 0;
        while (i < txt.length()) {
            int t;
            char m;
            char c = txt.charAt(i);
            if (p < this.inputMask.length()) {
                m = this.inputMask.charAt(p);
                if (m == '*' && this.inputCache.charAt(p) == c) {
                    from = p++;
                    ++i;
                    fd = null;
                    continue;
                }
            } else {
                m = this.inputMask.charAt(this.inputMask.length() - 1);
            }
            if (fd == null) {
                fd = this.getField(p, from);
                int j = fd.pos;
                while (j < p) {
                    if (this.inputCache.charAt(j) == ' ') {
                        this.inputCache.setCharAt(j, '0');
                    }
                    ++j;
                }
            }
            if ((t = Character.getType(c)) == 9 && fd.field != 9) {
                char o = '#';
                if (m != '*' && p < this.inputMask.length()) {
                    o = this.inputCache.charAt(p);
                    this.inputCache.setCharAt(p, c);
                } else if (fd.curLen < fd.maxLen) {
                    this.inputCache.insert(p, c);
                    this.inputMask.insert(p, this.inputMask.charAt(fd.pos));
                    ++fd.curLen;
                } else {
                    this.beep();
                    return p;
                }
                if (!this.updateFieldValue(fd, true)) {
                    if (o != '#') {
                        this.inputCache.setCharAt(p, o);
                    } else {
                        this.inputCache.deleteCharAt(p);
                        this.inputMask.deleteCharAt(p);
                        --fd.curLen;
                    }
                    this.beep();
                    return p;
                }
                ++i;
                ++p;
                continue;
            }
            if (fd.field == 9 && (t == 1 || t == 2)) {
                String[] ampm = this.sdfDisplay.getDateFormatSymbols().getAmPmStrings();
                if (Character.toLowerCase(c) == Character.toLowerCase(ampm[0].charAt(0))) {
                    t = 0;
                } else if (Character.toLowerCase(c) == Character.toLowerCase(ampm[1].charAt(0))) {
                    t = 1;
                } else {
                    this.beep();
                    return p;
                }
                this.inputCache.replace(fd.pos, fd.pos + fd.curLen, ampm[t]);
                while (fd.curLen < ampm[t].length()) {
                    this.inputMask.insert(p, m);
                    ++fd.curLen;
                }
                while (fd.curLen > ampm[t].length()) {
                    this.inputMask.deleteCharAt(p);
                    --fd.curLen;
                }
                this.updateFieldValue(fd, false);
                ++i;
                p = fd.pos + fd.curLen;
                continue;
            }
            t = fd.pos + fd.curLen;
            if (t < this.inputCache.length() && c == this.inputCache.charAt(t) && i == txt.length() - 1) {
                p = this.getNextFieldPos(fd);
            } else {
                this.beep();
            }
            return p;
        }
        if (fd != null && p == fd.pos + fd.curLen && fd.curLen == fd.maxLen) {
            p = this.getNextFieldPos(fd);
        }
        return p;
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.fieldCount) {
            if (!this.fields[i].empty) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isValid() {
        return this.countValid() == this.fieldCount;
    }

    protected void isValidCharPattern(char c) {
        switch (c) {
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'K': 
            case 'W': 
            case 'Z': 
            case 'k': 
            case 'w': 
            case 'z': {
                throw new IllegalArgumentException("Invalid datetime pattern");
            }
        }
    }

    private void locateField(FieldDesc f, int from) {
        while (this.inputMask.charAt(from) != f.index) {
            ++from;
        }
        f.pos = from;
        int l = from + 1;
        while (l < this.inputMask.length() && this.inputMask.charAt(l) == f.index) {
            ++l;
        }
        f.curLen = l - from;
    }

    private int getNextFieldPos(FieldDesc f) {
        int p = f.pos + f.curLen;
        while (p < this.inputMask.length() && this.inputMask.charAt(p) == '*') {
            ++p;
        }
        return p;
    }

    private void setInputCache() {
        int l = this.inputCache.length();
        int i = 0;
        while (i < l) {
            char c = this.inputMask.charAt(i);
            if (c != '*') {
                int j = i;
                while (j < l - 1 && this.inputMask.charAt(j + 1) == c) {
                    ++j;
                }
                FieldDesc f = this.fields[c - 48];
                String value = this.getFormattedValue(f);
                this.inputCache.replace(i, j + 1, value);
                i = this.ajustMask(i, j, value.length());
                l = this.inputCache.length();
            }
            ++i;
        }
    }

    public void setLocale(Locale loc) {
        this.sdfDisplay.setDateFormatSymbols(new DateFormatSymbols(loc));
        Calendar newCal = Calendar.getInstance(this.calendar.getTimeZone(), loc);
        newCal.setTimeInMillis(0L);
        int i = 0;
        while (i < this.fieldCount) {
            if (this.fields[i].valid) {
                newCal.set(this.fields[i].field, this.calendar.get(this.fields[i].field));
            } else {
                newCal.clear(this.fields[i].field);
            }
            ++i;
        }
        this.calendar = newCal;
        this.locale = loc;
    }

    public void setText(Text text) {
        super.setText(text);
        text.addKeyListener(this.klistener);
        text.addFocusListener(this.flistener);
    }

    public void setTimeZone(TimeZone zone) {
        if (zone == null) {
            SWT.error((int)4);
        }
        this.sdfDisplay.setTimeZone(zone);
        this.calendar.setTimeZone(zone);
    }

    public void setValue(Object value) {
        if (value instanceof Date) {
            if (value != null) {
                this.calendar.setTime((Date)value);
            }
            int i = 0;
            while (i < this.fieldCount) {
                this.fields[i].valid = value != null;
                this.fields[i].empty = !this.fields[i].valid;
                ++i;
            }
            this.setInputCache();
        } else if (value == null) {
            this.clear(0, this.inputCache.length());
        } else {
            SWT.error((int)5);
        }
    }

    private boolean updateFieldValue(FieldDesc f, boolean checkLimits) {
        String s = this.inputCache.substring(f.pos, f.pos + f.curLen).trim();
        f.empty = false;
        if (s.length() == 0 || s.indexOf(32) >= 0) {
            this.calendar.clear(f.field);
            f.empty = true;
            f.valid = false;
        } else if (f.field == 9) {
            this.calendar.set(f.field, this.sdfDisplay.getDateFormatSymbols().getAmPmStrings()[0].equals(s) ? 0 : 1);
            f.valid = true;
        } else {
            int v = 0;
            try {
                v = nf.parse(s).intValue();
            }
            catch (ParseException e) {
                e.printStackTrace(System.err);
            }
            if (v == 0 && f.field <= 5 && s.length() < f.maxLen) {
                this.calendar.clear(f.field);
                f.valid = false;
            } else {
                if (f.field == 1 && f.maxLen <= 2) {
                    v += v >= this.yearStart ? 1900 : 2000;
                } else if (f.field == 10 && v == 12) {
                    v = 0;
                }
                int min = this.calendar.getActualMinimum(f.field);
                int max = this.calendar.getActualMaximum(f.field);
                if (f.field == 2) {
                    ++min;
                    ++max;
                }
                if (v < min || v > max) {
                    if (!checkLimits) {
                        return false;
                    }
                    if (v > max) {
                        if ((v = v / 10 * 10) > max) {
                            return false;
                        }
                        this.inputCache.setCharAt(f.pos + f.curLen - 1, '0');
                    } else if (f.curLen == f.maxLen) {
                        if ((v = v / 10 * 10 + 1) < min) {
                            return false;
                        }
                        this.inputCache.setCharAt(f.pos + f.curLen - 1, '1');
                    }
                }
                this.calendar.set(f.field, f.field == 2 ? v - 1 : v);
                f.valid = true;
            }
        }
        return true;
    }

    public void verifyText(VerifyEvent e) {
        if (this.ignore) {
            return;
        }
        e.doit = false;
        if (e.keyCode == 8 || e.keyCode == 127) {
            this.clear(e.start, e.end);
        } else {
            e.start = this.insert(e.text, e.start);
        }
        this.updateText(this.inputCache.toString(), e.start);
    }

    private class FieldDesc {
        int field;
        int minLen;
        int maxLen;
        boolean empty;
        boolean valid;
        char index;
        int pos;
        int curLen;

        private FieldDesc() {
        }
    }
}

