/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal;

import org.eclipse.nebula.widgets.geomap.GeoMap;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DefaultMouseHandler
implements MouseListener,
MouseWheelListener,
MouseMoveListener,
MouseTrackListener,
PaintListener {
    private final GeoMap geoMap;
    private Point panStart;
    private Point downPosition;
    private int zoomClickCount = 1;
    private int zoomInClickButtons = 524288;
    private int zoomOutClickButtons = 0x200000;
    private int zoomRectangleButtons = 655360;
    private Point zoomStart = null;
    private Rectangle zoomRectangle = null;
    private int panClickCount = 1;
    private int panButtons = 524288;
    private int panCenterButtons = 786432;
    private int panScrollButtons = 0;
    private int panScrollSpeed = 15;
    private int zoomScrollButtons = 0;

    public DefaultMouseHandler(GeoMap geoMap) {
        this.geoMap = geoMap;
    }

    protected void zoomIn(MouseEvent e) {
        this.geoMap.zoomIn(new Point(e.x, e.y));
    }

    protected void zoomOut(MouseEvent e) {
        this.geoMap.zoomOut(new Point(e.x, e.y));
    }

    protected void pan(int x, int y, boolean relative) {
        if (relative) {
            Point p = this.geoMap.getMapPosition();
            x += p.x;
            y += p.y;
        }
        this.geoMap.setMapPosition(x, y);
        this.geoMap.redraw();
    }

    protected void center(MouseEvent e) {
        Point mapPosition = this.geoMap.getMapPosition();
        this.geoMap.setCenterPosition(new Point(mapPosition.x + e.x, mapPosition.y + e.y));
        this.geoMap.redraw();
    }

    public int getZoomClickCount() {
        return this.zoomClickCount;
    }

    public void setZoomClickCount(int zoomClickCount) {
        this.zoomClickCount = zoomClickCount;
    }

    public int getPanCenterButtons() {
        return this.panCenterButtons;
    }

    public void setPanCenterButtons(int panCenterButtons) {
        this.panCenterButtons = panCenterButtons;
    }

    public int getZoomInClickButtons() {
        return this.zoomInClickButtons;
    }

    public void setZoomInClickButtons(int zoomInClickButtons) {
        this.zoomInClickButtons = zoomInClickButtons;
    }

    public int getZoomOutClickButtons() {
        return this.zoomOutClickButtons;
    }

    public void setZoomOutClickButtons(int zoomOutClickButtons) {
        this.zoomOutClickButtons = zoomOutClickButtons;
    }

    public int getPanClickCount() {
        return this.panClickCount;
    }

    public void setPanClickCount(int panClickCount) {
        this.panClickCount = panClickCount;
    }

    public int getPanButtons() {
        return this.panButtons;
    }

    public void setPanButtons(int panButtons) {
        this.panButtons = panButtons;
    }

    public int getPanScrollButtons() {
        return this.panScrollButtons;
    }

    public void setPanScrollButtons(int panScrollButtons) {
        this.panScrollButtons = panScrollButtons;
    }

    public int getPanScrollSpeed() {
        return this.panScrollSpeed;
    }

    public void setPanScrollSpeed(int panScrollSpeed) {
        this.panScrollSpeed = panScrollSpeed;
    }

    public int getZoomScrollButtons() {
        return this.zoomScrollButtons;
    }

    public void setZoomScrollButtons(int zoomScrollButtons) {
        this.zoomScrollButtons = zoomScrollButtons;
    }

    public int getZoomRectangleButtons() {
        return this.zoomRectangleButtons;
    }

    public void setZoomRectangleButtons(int zoomRectangleButtons) {
        this.zoomRectangleButtons = zoomRectangleButtons;
    }

    public void mouseEnter(MouseEvent e) {
        this.geoMap.forceFocus();
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }

    protected boolean checkButtons(MouseEvent e, int buttons) {
        int mask = e.stateMask;
        switch (e.button) {
            case 1: {
                mask |= 0x80000;
                break;
            }
            case 2: {
                mask |= 0x100000;
                break;
            }
            case 3: {
                mask |= 0x200000;
                break;
            }
            case 4: {
                mask |= 0x800000;
                break;
            }
            case 5: {
                mask |= 0x2000000;
            }
        }
        return mask == buttons;
    }

    public void mouseDown(MouseEvent e) {
        this.handleDown(e);
    }

    public void mouseMove(MouseEvent e) {
        if (this.isPanning()) {
            this.handlePanDrag(e);
        } else if (this.zoomStart != null) {
            this.handleZoomDrag(e);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.handleZoomClick(e);
    }

    protected boolean handleZoomClick(MouseEvent e) {
        if (e.count != this.zoomClickCount) {
            return false;
        }
        if (this.checkButtons(e, this.zoomInClickButtons)) {
            this.zoomIn(e);
            return true;
        }
        if (this.checkButtons(e, this.zoomOutClickButtons)) {
            this.zoomOut(e);
            return true;
        }
        return false;
    }

    protected boolean handleDown(MouseEvent e) {
        if (e.count != this.panClickCount) {
            return false;
        }
        if (this.checkButtons(e, this.panCenterButtons)) {
            this.center(e);
            return true;
        }
        if (this.isPanStart(e)) {
            return this.panStart(e);
        }
        if (this.isZoomStart(e)) {
            return this.zoomStart(e);
        }
        return false;
    }

    protected boolean isPanStart(MouseEvent e) {
        return this.checkButtons(e, this.panButtons);
    }

    protected boolean isZoomStart(MouseEvent e) {
        return this.checkButtons(e, this.zoomRectangleButtons);
    }

    protected boolean panStart(MouseEvent e) {
        this.panStart = new Point(e.x, e.y);
        this.downPosition = this.geoMap.getMapPosition();
        return true;
    }

    protected boolean isPanning() {
        return this.panStart != null;
    }

    protected boolean zoomStart(MouseEvent e) {
        this.zoomStart = new Point(e.x, e.y);
        return true;
    }

    protected boolean isZooming() {
        return this.zoomStart != null;
    }

    public void mouseUp(MouseEvent e) {
        boolean consumed = false;
        if (this.isPanning() && this.handlePanUp(e)) {
            consumed = true;
        } else if (this.isZooming() && this.handleZoomUp(e)) {
            consumed = true;
        }
        if (!consumed) {
            this.handleZoomClick(e);
        }
    }

    public void mouseScrolled(MouseEvent e) {
        if (e.count > 0 && this.checkButtons(e, this.zoomScrollButtons)) {
            this.zoomIn(e);
        } else if (e.count < 0 && this.checkButtons(e, this.zoomScrollButtons)) {
            this.zoomOut(e);
        } else if (this.checkButtons(e, this.panScrollButtons)) {
            this.pan(e.count * this.panScrollSpeed, 0, true);
        }
    }

    protected boolean handlePanDrag(MouseEvent e) {
        int dy;
        int dx;
        if (this.isPanning() && (dx = this.panStart.x - e.x) * dx + (dy = this.panStart.y - e.y) * dy >= 4) {
            this.pan(this.downPosition.x + dx, this.downPosition.y + dy, false);
            return true;
        }
        return false;
    }

    protected boolean handleZoomDrag(MouseEvent e) {
        if (this.isZooming()) {
            int minX = Math.min(this.zoomStart.x, e.x);
            int minY = Math.min(this.zoomStart.y, e.y);
            int maxX = Math.max(this.zoomStart.x, e.x);
            int maxY = Math.max(this.zoomStart.y, e.y);
            Point mapPosition = this.geoMap.getMapPosition();
            this.zoomRectangle = new Rectangle(mapPosition.x + minX, mapPosition.y + minY, maxX - minX, maxY - minY);
            this.geoMap.redraw();
            return true;
        }
        return false;
    }

    protected boolean handlePanUp(MouseEvent e) {
        boolean result = this.handlePanDrag(e);
        this.panStart = null;
        this.downPosition = null;
        return result;
    }

    protected boolean handleZoomUp(MouseEvent e) {
        if (this.isZooming()) {
            if (this.zoomRectangle != null && this.zoomRectangle.width >= 2 && this.zoomRectangle.height >= 2) {
                this.geoMap.zoomTo(this.zoomRectangle);
            }
            this.zoomStart = null;
            this.zoomRectangle = null;
            return true;
        }
        return false;
    }

    public void paintControl(PaintEvent e) {
        if (this.zoomRectangle != null) {
            Point mapPosition = this.geoMap.getMapPosition();
            e.gc.drawRectangle(this.zoomRectangle.x - mapPosition.x, this.zoomRectangle.y - mapPosition.y, this.zoomRectangle.width, this.zoomRectangle.height);
        }
    }
}

