/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal;

import java.util.logging.Logger;
import org.eclipse.nebula.widgets.geomap.GeoMap;
import org.eclipse.nebula.widgets.geomap.GeoMapBrowser;
import org.eclipse.nebula.widgets.geomap.PointD;
import org.eclipse.nebula.widgets.geomap.internal.AbstractPage;
import org.eclipse.nebula.widgets.geomap.internal.Page;
import org.eclipse.nebula.widgets.geomap.internal.PageContainer;
import org.eclipse.nebula.widgets.geomap.internal.SearchPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ResultsPage
extends AbstractPage
implements Page {
    private static final Logger log = Logger.getLogger(ResultsPage.class.getName());
    private final GeoMapBrowser mapBrowser;
    private Table table;
    private String search = "";
    private SearchPage.SearchResult[] results = new SearchPage.SearchResult[0];
    private ScrolledComposite sc;
    private Link descriptionText;

    public ResultsPage(GeoMapBrowser mapBrowser) {
        this.mapBrowser = mapBrowser;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public SearchPage.SearchResult[] getResults() {
        return (SearchPage.SearchResult[])this.results.clone();
    }

    public void setResults(SearchPage.SearchResult[] results) {
        this.results = (SearchPage.SearchResult[])results.clone();
        this.table.removeAll();
        SearchPage.SearchResult[] searchResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            SearchPage.SearchResult result = searchResultArray[n2];
            String shortName = result.getName();
            String linkBody = shortName = shortName.replaceAll("\\s(.*)$", "");
            if (result.getType() != null && result.getType().length() > 0) {
                linkBody = String.valueOf(linkBody) + " [" + result.getType() + "]";
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, linkBody);
            ++n2;
        }
    }

    protected void initContent(final PageContainer container, Composite composite) {
        this.addHeaderRow(container, composite, "Actions");
        this.addActionLink(container, composite, "<a>Back to main menu</a>", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                container.showPage(0);
            }
        });
        this.addHeaderRow(container, composite, "Results");
        this.addInfoText(container, composite, "The following search results were retrieved from openstreetmap.org. Double-click to open a location.");
        this.table = new Table(composite, 68354);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.table, 0);
        column1.setText("Place");
        column1.setWidth(260);
        this.addHeaderRow(container, composite, "Description");
        this.descriptionText = this.addInfoText(container, composite, "");
        GridData layoutData = (GridData)this.descriptionText.getLayoutData();
        layoutData.minimumHeight = 100;
        layoutData.grabExcessVerticalSpace = false;
        layoutData.heightHint = 160;
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    return;
                }
                TableItem item = (TableItem)event.item;
                int index = ResultsPage.this.table.indexOf(item);
                if (index >= 0 && index < ResultsPage.this.results.length) {
                    SearchPage.SearchResult result = ResultsPage.this.results[index];
                    String name = result.getName();
                    name = name.replaceAll("\\[.*?\\]", "");
                    name = name.replaceAll("<.*?>", "");
                    if (result.getCategory() != null) {
                        name = String.valueOf(name) + " " + result.getCategory();
                    }
                    ResultsPage.this.descriptionText.setText(name);
                    ResultsPage.this.descriptionText.getParent().layout();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Point point = new Point(e.x, e.y);
                TableItem item = ResultsPage.this.table.getItem(point);
                if (item == null) {
                    return;
                }
                int index = ResultsPage.this.table.indexOf(item);
                if (index >= 0 && index < ResultsPage.this.results.length) {
                    SearchPage.SearchResult result = ResultsPage.this.results[index];
                    GeoMap geoMap = ResultsPage.this.mapBrowser.getGeoMap();
                    Point position = geoMap.computePosition(new PointD(result.getLon(), result.getLat()));
                    geoMap.setCenterPosition(position);
                    geoMap.redraw();
                }
            }
        });
    }

    protected void widgetDisposed(DisposeEvent e) {
    }
}

