/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.nebula.widgets.geomap.GeoMap;
import org.eclipse.nebula.widgets.geomap.GeoMapBrowser;
import org.eclipse.nebula.widgets.geomap.OsmTileServer;
import org.eclipse.nebula.widgets.geomap.PointD;
import org.eclipse.nebula.widgets.geomap.internal.AbstractPage;
import org.eclipse.nebula.widgets.geomap.internal.Page;
import org.eclipse.nebula.widgets.geomap.internal.PageContainer;
import org.eclipse.nebula.widgets.geomap.internal.ResultsPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SearchPage
extends AbstractPage
implements Page {
    private static final Logger log = Logger.getLogger(SearchPage.class.getName());
    private final GeoMapBrowser mapBrowser;
    private ProgressBar progressBar;
    private GridData progressBarLayoutData;
    private Text searchText;
    private boolean searching;
    private ArrayList<SearchResult> results = new ArrayList();
    private Link searchLink;

    public SearchPage(GeoMapBrowser mapBrowser) {
        this.mapBrowser = mapBrowser;
    }

    protected void initContent(PageContainer container, Composite composite) {
        this.addHeaderRow(container, composite, "Infopanel");
        this.addInfoText(container, composite, "Toggling the tile-server changes the way the map is rendered. Click on the mapinfos link to see details about the currently rendered part of the map.");
        this.addActionLink(container, composite, "<a>Toggle Rendering</a>", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeoMap geoMap = SearchPage.this.mapBrowser.getGeoMap();
                int next = (Arrays.asList(OsmTileServer.TILESERVERS).indexOf(geoMap.getTileServer()) + 1) % OsmTileServer.TILESERVERS.length;
                geoMap.setTileServer(OsmTileServer.TILESERVERS[next]);
            }
        });
        this.addActionLink(container, composite, "Show <a>Technical Mapinfos</a>", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.this.mapBrowser.getPageContainer().showPage(SearchPage.this.mapBrowser.getPageContainer().indexOfPage(SearchPage.this.mapBrowser.getInfoPage()));
            }
        });
        this.addActionLink(container, composite, "Show <a>Europe</a>", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeoMap geoMap = SearchPage.this.mapBrowser.getGeoMap();
                geoMap.setZoom(5);
                Point position = geoMap.computePosition(new PointD(5.5, 52.2));
                geoMap.setCenterPosition(position);
                geoMap.redraw();
            }
        });
        this.addHeaderRow(container, composite, "Search location");
        this.addInfoText(container, composite, "Enter any location or landmark site to search openstreetmap's genuine namefinder database. Hit return to perform the search.");
        Label label = new Label(composite, 0);
        label.setText("Search:");
        label.setLayoutData((Object)new GridData());
        container.adapt((Control)label);
        Composite wrap = new Composite(composite, 0);
        wrap.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        container.adapt((Control)wrap);
        GridLayout layout = new GridLayout(2, false);
        wrap.setLayout((Layout)layout);
        this.searchText = new Text(wrap, 2176);
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.this.startSearch();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SearchPage.this.startSearch();
            }
        });
        this.searchLink = new Link(wrap, 0);
        this.searchLink.setText("<a>Go</a>");
        container.adapt((Control)this.searchLink);
        this.searchLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.this.startSearch();
            }
        });
        this.progressBar = new ProgressBar(composite, 65538);
        container.adapt((Control)this.progressBar);
        this.progressBarLayoutData = new GridData(4, 1, true, false, 2, 1);
        this.progressBarLayoutData.exclude = true;
        this.progressBar.setVisible(false);
        this.progressBar.setLayoutData((Object)this.progressBarLayoutData);
        this.addHeaderRow(container, composite, "Actions");
        this.addInfoText(container, composite, "MapWidget - Minimal Openstreetmap/Maptile Viewer\r\nRequirements: Java + SWT. Opensource and licensed under EPL.\r\n\r\nWeb/Source: <a href=\"http://mappanel.sourceforge.net\">http://mappanel.sourceforge.net</a>\r\nWritten by stepan.rutz. Contact <a href=\"mailto:stepan.rutz@gmx.de?subject=SWT%20MapWidget\">stepan.rutz@gmx.de</a>\r\n\r\nTileserver and Nominationserver are accessed online and are part of Openstreetmap.org and not of this software.\r\n");
    }

    protected void widgetDisposed(DisposeEvent e) {
    }

    public void startSearch() {
        if (this.searching) {
            return;
        }
        final String search = this.searchText.getText();
        if (search == null || search.length() == 0) {
            return;
        }
        this.searching = true;
        this.setupSearchGui();
        Thread t = new Thread(new Runnable(){

            public void run() {
                SearchPage.this.doSearchInternal(search);
            }
        });
        t.setName("Background Seacher \"" + search + "\"");
        t.start();
    }

    private void setupSearchGui() {
        this.progressBarLayoutData.exclude = false;
        this.progressBar.setVisible(true);
        this.searchText.setEnabled(false);
        this.searchLink.setEnabled(false);
        this.progressBar.getParent().layout();
    }

    private void tearDownSearchGui() {
        this.progressBarLayoutData.exclude = true;
        this.progressBar.setVisible(false);
        this.searchText.setEnabled(true);
        this.searchLink.setEnabled(true);
        this.progressBar.getParent().layout();
    }

    private void doSearchInternal(final String newSearch) {
        this.results.clear();
        try {
            String args = URLEncoder.encode(newSearch.trim(), "UTF-8");
            String path = "http://nominatim.openstreetmap.org/search?format=xml&q=" + args;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.newSAXParser().parse(path, new DefaultHandler(){
                private StringBuilder chars;

                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if ("place".equals(qName)) {
                        SearchResult result = new SearchResult();
                        result.setType(attributes.getValue("type"));
                        result.setLat(this.tryDouble(attributes.getValue("lat")));
                        result.setLon(this.tryDouble(attributes.getValue("lon")));
                        result.setName(attributes.getValue("display_name"));
                        SearchPage.this.results.add(result);
                    }
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.chars != null) {
                        this.chars.append(ch, start, length);
                    }
                }

                private double tryDouble(String s) {
                    try {
                        return Double.valueOf(s);
                    }
                    catch (Exception exception) {
                        return 0.0;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "failed to search for \"" + newSearch + "\"", e);
        }
        this.getComposite().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    ResultsPage resultsPage = SearchPage.this.mapBrowser.getResultsPage();
                    resultsPage.setSearch(newSearch);
                    SearchPage.this.mapBrowser.getPageContainer().showPage(SearchPage.this.mapBrowser.getPageContainer().indexOfPage(resultsPage));
                    resultsPage.setResults(SearchPage.this.results.toArray(new SearchResult[SearchPage.this.results.size()]));
                }
                finally {
                    SearchPage.this.searching = false;
                    SearchPage.this.tearDownSearchGui();
                }
            }
        });
    }

    public static final class SearchResult {
        private String type;
        private double lat;
        private double lon;
        private String name;
        private String category;
        private String info;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public double getLat() {
            return this.lat;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public double getLon() {
            return this.lon;
        }

        public void setLon(double lon) {
            this.lon = lon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getInfo() {
            return this.info;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public String toString() {
            return "SearchResult [category=" + this.category + ", info=" + this.info + ", lat=" + this.lat + ", lon=" + this.lon + ", name=" + this.name + ", type=" + this.type + "]";
        }
    }
}

