/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.jface;

import java.util.EventListener;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.nebula.widgets.geomap.GeoMap;
import org.eclipse.nebula.widgets.geomap.PointD;
import org.eclipse.nebula.widgets.geomap.internal.DefaultMouseHandler;
import org.eclipse.nebula.widgets.geomap.jface.IPinPointProvider;
import org.eclipse.nebula.widgets.geomap.jface.IToolTipProvider;
import org.eclipse.nebula.widgets.geomap.jface.LocationProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class GeoMapViewer
extends ContentViewer {
    private GeoMap geoMap;
    private LocationProvider locationProvider;
    private Object selection = null;
    private Point selectionOffset = null;
    private DefaultMouseHandler mouseHandler;
    public static int NO_CLIP = 0;
    public static int CLIP_ON_ELEMENT_POSITION = 1;
    public static int CLIP_ON_IMAGE_BOUNDS = 2;
    private int clipRule = CLIP_ON_ELEMENT_POSITION;
    private int revealMargin = 10;
    public static final int MOVE_SELECTION_NONE = 0;
    public static final int MOVE_SELECTION_ALLOW_CHECK_IMMEDIATE = 1;
    public static final int MOVE_SELECTION_ALLOW_CHECK_LATE = 2;
    private int moveSelectionMode = 1;
    private ToolTip toolTip;
    private ToolTip lastToolTip;
    private int thumbSize = 7;

    public GeoMapViewer(GeoMap geoMap) {
        this.geoMap = geoMap;
        this.hookControl((Control)geoMap);
        this.geoMap.removeMouseHandler((EventListener)((Object)this.geoMap.getDefaultMouseHandler()));
        this.mouseHandler = new MovePinMouseHandler(this);
        this.geoMap.addMouseHandler((EventListener)((Object)this.mouseHandler));
        geoMap.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GeoMapViewer.this.paintOverlay(e);
            }
        });
        geoMap.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                switch (e.keyCode) {
                    case 27: {
                        GeoMapViewer.this.revealAll();
                    }
                }
            }
        });
    }

    public GeoMapViewer(Composite parent, int flags) {
        this(new GeoMap(parent, flags));
    }

    protected void handleDispose(DisposeEvent event) {
        this.geoMap.removeMouseHandler((EventListener)((Object)this.mouseHandler));
        if (this.lastToolTip != null) {
            this.lastToolTip.deactivate();
            this.lastToolTip = null;
        }
        if (this.toolTip != null) {
            this.toolTip.deactivate();
            this.toolTip = null;
        }
        super.handleDispose(event);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        super.handleLabelProviderChanged(event);
        this.refresh();
    }

    public LocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    private void paintOverlay(PaintEvent e) {
        this.doContents(e.gc, null, this.selection);
    }

    private Object[] getElements() {
        IContentProvider contentProvider = this.getContentProvider();
        return contentProvider instanceof IStructuredContentProvider ? ((IStructuredContentProvider)contentProvider).getElements(this.getInput()) : null;
    }

    private Object doContents(GC gc, Rectangle contain, Object selection) {
        Object[] elements = this.getElements();
        if (elements != null && this.getLocationProvider() != null) {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                Object found = this.doContent(element, gc, contain, selection);
                if (found != null) {
                    return found;
                }
                ++i;
            }
        }
        return null;
    }

    public Object getElementAt(int x, int y, int thumbSize) {
        return this.doContents(null, new Rectangle(x - thumbSize / 2, y - thumbSize / 2, thumbSize, thumbSize), null);
    }

    public void setClipRule(int clipRule) {
        this.clipRule = clipRule;
    }

    private Object doContent(Object element, GC gc, Rectangle contain, Object selection) {
        Point pinPoint;
        Point p = this.getElementPosition(element, null, true);
        if (p == null) {
            return null;
        }
        if (gc != null && this.clipRule == CLIP_ON_ELEMENT_POSITION) {
            if (p.x < 0 || p.y < 0) {
                return null;
            }
            Point size = this.geoMap.getSize();
            if (p.x > size.x || p.y > size.y) {
                return null;
            }
        }
        IBaseLabelProvider labelProvider = this.getLabelProvider();
        Image image = null;
        if (labelProvider instanceof ILabelProvider) {
            ((ILabelProvider)labelProvider).getText(element);
            image = ((ILabelProvider)labelProvider).getImage(element);
        }
        if (image == null) {
            return null;
        }
        Rectangle bounds = image.getBounds();
        bounds.x = p.x;
        bounds.y = p.y;
        if (labelProvider instanceof IPinPointProvider && (pinPoint = ((IPinPointProvider)labelProvider).getPinPoint(element)) != null) {
            bounds.x -= pinPoint.x;
            bounds.y -= pinPoint.y;
        }
        if (gc != null) {
            boolean shouldClip = false;
            if (this.clipRule == CLIP_ON_IMAGE_BOUNDS) {
                Point size = this.geoMap.getSize();
                boolean bl = shouldClip = !bounds.intersects(0, 0, size.x, size.y);
            }
            if (!shouldClip) {
                boolean isSelected;
                boolean bl = isSelected = selection != null && element == selection;
                if (isSelected && this.selectionOffset != null) {
                    bounds.x += this.selectionOffset.x;
                    bounds.y += this.selectionOffset.y;
                }
                gc.drawImage(image, bounds.x, bounds.y);
                if (isSelected) {
                    gc.drawRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        }
        if (contain != null && bounds.contains(contain.x, contain.y) && bounds.contains(contain.x + contain.width, contain.y + contain.height)) {
            return element;
        }
        return null;
    }

    private Point getElementPosition(Object element, Point into, boolean mapRelative) {
        PointD lonLat;
        PointD pointD = lonLat = element instanceof PointD ? (PointD)element : this.getLocationProvider().getLonLat(element);
        if (lonLat == null) {
            return null;
        }
        int x = GeoMap.lon2position(lonLat.x, this.geoMap.getZoom());
        int y = GeoMap.lat2position(lonLat.y, this.geoMap.getZoom());
        if (mapRelative) {
            Point p = this.geoMap.getMapPosition();
            x -= p.x;
            y -= p.y;
        }
        if (into == null) {
            into = new Point(x, y);
        } else {
            into.x = x;
            into.y = y;
        }
        return into;
    }

    public Control getControl() {
        return this.getGeoMap();
    }

    public GeoMap getGeoMap() {
        return this.geoMap;
    }

    public ISelection getSelection() {
        return this.selection != null ? new StructuredSelection(this.selection) : StructuredSelection.EMPTY;
    }

    public void refresh() {
        this.geoMap.redraw();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.setSelection(selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null);
        if (reveal && this.selection != null) {
            this.reveal(this.selection, true);
        }
    }

    public void reveal(Object selection, boolean center) {
        Point position = this.getElementPosition(selection, new Point(0, 0), true);
        Point size = this.geoMap.getSize();
        Rectangle insideMargin = new Rectangle(this.revealMargin, this.revealMargin, size.x - this.revealMargin, size.y - this.revealMargin);
        if (position != null && (center || !insideMargin.contains(position))) {
            Point mapPosition = this.geoMap.getMapPosition();
            this.geoMap.setCenterPosition(new Point(position.x + mapPosition.x, position.y + mapPosition.y));
        }
    }

    public void revealAll() {
        this.zoomTo(((IStructuredContentProvider)this.getContentProvider()).getElements(this.getInput()));
    }

    private void setSelection(Object selection) {
        this.selection = selection;
        this.refresh();
    }

    public void setMoveSelectionMode(int moveSelectionMode) {
        this.moveSelectionMode = moveSelectionMode;
    }

    public int getMoveSelectionMode() {
        return this.moveSelectionMode;
    }

    public ToolTip getToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new DefaultToolTip(this.getControl());
        }
        return this.toolTip;
    }

    void handleToolTip(Event e) {
        this.handleToolTip(e.x, e.y);
    }

    void handleToolTip(MouseEvent e) {
        this.handleToolTip(e.x, e.y);
    }

    private void handleToolTip(int x, int y) {
        if (this.getLabelProvider() instanceof IToolTipProvider) {
            Object element = this.getElementAt(x, y, this.thumbSize);
            Object toolTip = ((IToolTipProvider)this.getLabelProvider()).getToolTip(element);
            if (toolTip instanceof String && this.getToolTip() instanceof DefaultToolTip) {
                DefaultToolTip defaultToolTip = (DefaultToolTip)this.getToolTip();
                defaultToolTip.setText((String)toolTip);
                toolTip = defaultToolTip;
            }
            if (this.lastToolTip != toolTip) {
                if (this.lastToolTip != null) {
                    this.lastToolTip.deactivate();
                }
                this.lastToolTip = (ToolTip)toolTip;
                if (this.lastToolTip != null) {
                    this.lastToolTip.activate();
                }
            }
        }
    }

    private Rectangle getBounds(Object[] elements) {
        Rectangle rect = null;
        int i = 0;
        while (i < elements.length) {
            PointD location = this.getLocationProvider().getLonLat(elements[i]);
            if (location != null) {
                Point position = this.geoMap.computePosition(location);
                if (rect == null) {
                    rect = new Rectangle(position.x, position.y, 1, 1);
                } else {
                    if (position.x < rect.x) {
                        rect.width += rect.x - position.x;
                        rect.x = position.x;
                    } else if (position.x > rect.x + rect.width) {
                        rect.width = position.x - rect.x;
                    }
                    if (position.y < rect.y) {
                        rect.height += rect.y - position.y;
                        rect.y = position.y;
                    } else if (position.y > rect.y + rect.height) {
                        rect.height = position.y - rect.y;
                    }
                }
            }
            ++i;
        }
        return rect;
    }

    public void zoomTo(Object[] elements) {
        Rectangle rect = this.getBounds(elements);
        if (rect == null) {
            return;
        }
        this.getGeoMap().zoomTo(rect);
    }

    private class MovePinMouseHandler
    extends DefaultMouseHandler {
        private Point selectionStart;

        MovePinMouseHandler(GeoMapViewer geoMapViewer2) {
            super(geoMapViewer2.getGeoMap());
            this.selectionStart = null;
        }

        protected boolean isPanStart(MouseEvent e) {
            return super.isPanStart(e) && GeoMapViewer.this.getElementAt(e.x, e.y, GeoMapViewer.this.thumbSize) == null;
        }

        private boolean isSelecting() {
            return GeoMapViewer.this.selectionOffset != null;
        }

        public void mouseDown(MouseEvent e) {
            super.mouseDown(e);
            if (this.isPanning() || this.isZooming()) {
                return;
            }
            Object element = GeoMapViewer.this.getElementAt(e.x, e.y, GeoMapViewer.this.thumbSize);
            if (element != null) {
                this.selectionStart = new Point(e.x, e.y);
                GeoMapViewer.this.selectionOffset = new Point(0, 0);
                PointD lonLat = GeoMapViewer.this.getLocationProvider().getLonLat(element);
                if (GeoMapViewer.this.moveSelectionMode == 0 || GeoMapViewer.this.moveSelectionMode == 1 && !GeoMapViewer.this.getLocationProvider().setLonLat(element, lonLat.x, lonLat.y)) {
                    GeoMapViewer.this.selectionOffset = null;
                }
                GeoMapViewer.this.setSelection(element);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.isSelecting()) {
                ((GeoMapViewer)GeoMapViewer.this).selectionOffset.x = e.x - this.selectionStart.x;
                ((GeoMapViewer)GeoMapViewer.this).selectionOffset.y = e.y - this.selectionStart.y;
                GeoMapViewer.this.refresh();
            } else {
                super.mouseMove(e);
            }
        }

        public void mouseUp(MouseEvent e) {
            if (this.isSelecting()) {
                Point oldPosition = GeoMapViewer.this.getElementPosition(GeoMapViewer.this.selection, new Point(0, 0), false);
                Point newPosition = new Point(oldPosition.x + ((GeoMapViewer)GeoMapViewer.this).selectionOffset.x, oldPosition.y + ((GeoMapViewer)GeoMapViewer.this).selectionOffset.y);
                PointD lonLat = GeoMapViewer.this.geoMap.getLongitudeLatitude(newPosition);
                GeoMapViewer.this.getLocationProvider().setLonLat(GeoMapViewer.this.selection, lonLat.x, lonLat.y);
                GeoMapViewer.this.reveal(GeoMapViewer.this.selection, this.checkButtons(e, this.getPanCenterButtons()));
                this.selectionStart = null;
                GeoMapViewer.this.selectionOffset = null;
            } else {
                super.mouseUp(e);
            }
        }

        public void mouseHover(MouseEvent e) {
            GeoMapViewer.this.handleToolTip(e);
        }
    }
}

