/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.jface;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;

public class GoogleIconDescriptor
extends ImageDescriptor {
    private Options options;
    private static String baseUrl = "https://chart.googleapis.com/chart?";
    private static String argsSep = "|";
    public static final String icon_map_pin_letter = "d_map_pin_letter";
    public static final String icon_bubble_text_small = "d_bubble_text_small";
    public static final String icon_bubble_icon_text_small = "d_bubble_icon_text_small";
    public static final String icon_style_pin = "pin";
    public static final String icon_style_pin_star = "pin_star";
    public static final String icon_style_pin_sleft = "pin_sleft";
    public static final String icon_style_pin_sright = "pin_sright";
    public static final String frame_style_bb = "bb";
    public static final String frame_style_bbtl = "bbtl";
    public static final String frame_style_bbtr = "bbtr";
    public static final String frame_style_bbbr = "bbbr";
    public static final String frame_style_bbT = "bbT";
    public static final String frame_style_edge_bl = "edge_bl";
    public static final String frame_style_edge_bc = "edge_bc";
    public static final String frame_style_edge_br = "edge_br";
    public static final String frame_style_edge_tl = "edge_tl";
    public static final String frame_style_edge_tc = "edge_tc";
    public static final String frame_style_edge_tr = "edge_tr";
    public static final String frame_style_edge_lt = "edge_lt";
    public static final String frame_style_edge_lc = "edge_lc";
    public static final String frame_style_edge_lb = "edge_lb";
    public static final String frame_style_edge_rt = "edge_rt";
    public static final String frame_style_edge_rc = "edge_rc";
    public static final String frame_style_edge_rb = "edge_rb";

    public GoogleIconDescriptor(Options options) {
        this.options = options;
    }

    public String toString() {
        return "[GoogleIconDescriptor @ " + this.getUrlString() + "]";
    }

    public String getUrlString() {
        String chst = this.options.iconClass;
        if (this.options.hasShadow) {
            chst = String.valueOf(chst) + "_withshadow";
        }
        Object[] args = new Object[]{this.options.iconName, this.options.style, this.options.text, this.toHex(this.options.fillColor), this.toHex(this.options.textColor)};
        StringBuilder chld = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                if (chld.length() > 0) {
                    chld.append(argsSep);
                }
                try {
                    chld.append(URLEncoder.encode(args[i].toString(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            ++i;
        }
        return String.valueOf(baseUrl) + "chst=" + chst + "&chld=" + chld;
    }

    public ImageData getImageData() {
        try {
            return this.getImageData(this.getUrlString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String toHex(RGB rgb) {
        return String.format("%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageData getImageData(String urlString) {
        ImageData imageData;
        InputStream inputStream = null;
        try {
            inputStream = new URL(urlString).openStream();
            imageData = new ImageData(inputStream);
            if (inputStream == null) return imageData;
        }
        catch (MalformedURLException e) {
            try {
                throw new IllegalArgumentException(e);
                catch (IOException e2) {
                    throw new IllegalArgumentException(e2);
                }
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return imageData;
        }
        catch (IOException iOException) {}
        return imageData;
    }

    public static GoogleIconDescriptor letterPin(char c, boolean hasShadow, RGB fillColor, RGB textColor) {
        return new GoogleIconDescriptor(new Options(icon_map_pin_letter, null, null, hasShadow, String.valueOf(c), fillColor, textColor));
    }

    public static GoogleIconDescriptor textBubble(String s, boolean hasShadow, RGB fillColor, RGB textColor) {
        return new GoogleIconDescriptor(new Options(icon_bubble_text_small, null, frame_style_bb, hasShadow, s, fillColor, textColor));
    }

    public static class Options {
        private String iconClass;
        private String iconName;
        private String style;
        private boolean hasShadow;
        private String text;
        private RGB fillColor;
        private RGB textColor;

        public Options(String iconClass, String iconName, String style, boolean hasShadow, String text, RGB fillColor, RGB textColor) {
            this.setOptions(iconClass, iconName, style, hasShadow, text, fillColor, textColor);
        }

        private void setOptions(String iconClass, String iconName, String style, boolean hasShadow, String text, RGB fillColor, RGB textColor) {
            this.iconClass = iconClass;
            this.iconName = iconName;
            this.style = style;
            this.hasShadow = hasShadow;
            this.text = text;
            this.fillColor = fillColor;
            this.textColor = textColor;
        }

        public Options(Options options) {
            this.setOptions(options.iconClass, options.iconName, options.style, options.hasShadow, options.text, options.fillColor, options.textColor);
        }
    }
}

