/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.renderers.navigation;

import java.util.Locale;
import org.eclipse.nebula.widgets.pagination.AbstractPageControllerComposite;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.PaginationHelper;
import org.eclipse.nebula.widgets.pagination.Resources;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.BlueNavigationPageGraphicsConfigurator;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.INavigationPageGraphicsConfigurator;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.NavigationPageGraphics;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.NavigationPageGraphicsItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ResultAndNavigationPageGraphicsRenderer
extends AbstractPageControllerComposite {
    private Label resultLabel;
    private NavigationPageGraphics navigationPage;
    private final INavigationPageGraphicsConfigurator configurator;

    public ResultAndNavigationPageGraphicsRenderer(Composite parent, int style, PageableController controller) {
        this(parent, style, controller, BlueNavigationPageGraphicsConfigurator.getInstance());
    }

    public ResultAndNavigationPageGraphicsRenderer(Composite parent, int style, PageableController controller, INavigationPageGraphicsConfigurator configurator) {
        super(parent, style, controller, 10, null, false);
        this.configurator = configurator;
        this.createUI(this);
        this.refreshEnabled(controller);
    }

    protected void createUI(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createLeftContainer(parent);
        this.createRightContainer(parent);
    }

    private void createLeftContainer(Composite parent) {
        Composite left = this.createComposite(parent, 0);
        GridData data = new GridData(768);
        left.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        left.setLayout((Layout)layout);
        this.resultLabel = new Label(left, 0);
        this.resultLabel.setLayoutData((Object)new GridData(768));
    }

    private void createRightContainer(Composite parent) {
        Composite right = this.createComposite(parent, 0);
        right.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        right.setLayout((Layout)layout);
        this.navigationPage = new NavigationPageGraphics(right, 0, this.configurator){

            protected void handleSelection(NavigationPageGraphicsItem pageItem) {
                Integer newCurrentPage = null;
                if (!pageItem.isEnabled()) {
                    return;
                }
                newCurrentPage = pageItem.isNext() ? Integer.valueOf(ResultAndNavigationPageGraphicsRenderer.this.getController().getCurrentPage() + 1) : (pageItem.isPrevious() ? Integer.valueOf(ResultAndNavigationPageGraphicsRenderer.this.getController().getCurrentPage() - 1) : Integer.valueOf(pageItem.getIndex()));
                if (newCurrentPage != null) {
                    ResultAndNavigationPageGraphicsRenderer.this.getController().setCurrentPage(newCurrentPage);
                }
            }
        };
        this.navigationPage.setLayoutData(new GridData(768));
    }

    public void pageIndexChanged(int oldPageNumber, int newPageNumber, PageableController controller) {
        int[] indexes = PaginationHelper.getPageIndexes(controller.getCurrentPage(), controller.getTotalPages(), 10);
        this.navigationPage.update(indexes, newPageNumber, this.getLocale());
        this.refreshEnabled(controller);
    }

    public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
    }

    public void totalElementsChanged(long oldTotalElements, long newTotalElements, PageableController controller) {
        int[] indexes = PaginationHelper.getPageIndexes(controller.getCurrentPage(), controller.getTotalPages(), 10);
        this.navigationPage.update(indexes, 0, this.getLocale());
        this.refreshEnabled(controller);
    }

    public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController paginationController) {
    }

    private void refreshEnabled(PageableController controller) {
        this.resultLabel.setText(PaginationHelper.getResultsText(controller, this.getLocale()));
        this.navigationPage.setEnabled(controller.hasPreviousPage(), controller.hasNextPage());
    }

    protected void displayResults(PageableController controller) {
    }

    protected Composite createComposite(Composite parent, int style) {
        return new Composite(parent, style);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.navigationPage.setText(Resources.getText("PaginationRenderer.previous", this.getLocale()), Resources.getText("PaginationRenderer.next", this.getLocale()));
        this.resultLabel.setText(PaginationHelper.getResultsText(this.getController(), this.getLocale()));
    }

    public NavigationPageGraphics getNavigationPage() {
        return this.navigationPage;
    }

    public void setConfigurator(INavigationPageGraphicsConfigurator configurator) {
        this.getNavigationPage().setConfigurator(configurator);
    }
}

