/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.table;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.pagination.AbstractPaginationWidget;
import org.eclipse.nebula.widgets.pagination.IPageContentProvider;
import org.eclipse.nebula.widgets.pagination.PageLoaderStrategyHelper;
import org.eclipse.nebula.widgets.pagination.collections.PageResultContentProvider;
import org.eclipse.nebula.widgets.pagination.renderers.ICompositeRendererFactory;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.ResultAndNavigationPageLinksRendererFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageableTable
extends AbstractPaginationWidget<Table> {
    protected static final int DEFAULT_TABLE_STYLE = 2818;
    protected TableViewer viewer;
    private final int tableStyle;

    public PageableTable(Composite parent, int style) {
        this(parent, style, 2818, 10);
    }

    public PageableTable(Composite parent, int style, int tableStyle, int pageSize, IPageContentProvider pageContentProvider) {
        this(parent, style, tableStyle, pageSize, pageContentProvider, PageableTable.getDefaultPageRendererTopFactory(), PageableTable.getDefaultPageRendererBottomFactory(), true);
    }

    public PageableTable(Composite parent, int style, int tableStyle, int pageSize) {
        this(parent, style, tableStyle, pageSize, PageResultContentProvider.getInstance(), PageableTable.getDefaultPageRendererTopFactory(), PageableTable.getDefaultPageRendererBottomFactory(), true);
    }

    public PageableTable(Composite parent, int style, int tableStyle, int pageSize, IPageContentProvider pageContentProvider, ICompositeRendererFactory pageRendererTopFactory, ICompositeRendererFactory pageRendererBottomFactory) {
        this(parent, style, tableStyle, pageSize, pageContentProvider, pageRendererTopFactory, pageRendererBottomFactory, true);
    }

    protected PageableTable(Composite parent, int style, int tableStyle, int pageSize, IPageContentProvider pageContentProvider, ICompositeRendererFactory pageRendererTopFactory, ICompositeRendererFactory pageRendererBottomFactory, boolean createUI) {
        super(parent, style, pageSize, pageContentProvider, pageRendererTopFactory, pageRendererBottomFactory, false);
        this.tableStyle = tableStyle;
        if (createUI) {
            this.createUI(this);
        }
    }

    @Override
    protected Table createWidget(Composite parent) {
        Table table = this.createTable(parent);
        this.viewer = new TableViewer(table);
        return table;
    }

    protected Table createTable(Composite parent) {
        Table table = this.createTable(parent, this.getTableStyle());
        table.setLayoutData((Object)new GridData(768));
        return table;
    }

    protected int getTableStyle() {
        return this.tableStyle;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    protected Table createTable(Composite parent, int style) {
        return new Table(parent, style);
    }

    public static ICompositeRendererFactory getDefaultPageRendererTopFactory() {
        return ResultAndNavigationPageLinksRendererFactory.getFactory();
    }

    public static ICompositeRendererFactory getDefaultPageRendererBottomFactory() {
        return null;
    }

    @Override
    public void refreshPage() {
        PageLoaderStrategyHelper.loadPageAndReplaceItems(this.getController(), (Viewer)this.viewer, this.getPageLoader(), this.getPageContentProvider(), null);
    }
}

