/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.picture;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.nebula.widgets.picture.ImageFilterExtension;
import org.eclipse.nebula.widgets.picture.internal.IOUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPictureControl<T extends Control>
extends Composite
implements PropertyChangeListener {
    public static final String BUNDLE_NAME = "org.eclipse.nebula.widgets.picture.resources";
    private static final String PICTURE_CONTROL_DELETE = "PictureControl.delete";
    private static final String PICTURE_CONTROL_MODIFY = "PictureControl.modify";
    private static final String PICTURE_CONTROL_FILEDIALOG_TEXT = "PictureControl.fileDialog.text";
    public static final String IMAGE_BYTEARRAY_PROPERTY = "imageByteArray";
    private static final String[] DEFAULT_EXTENSIONS = ImageFilterExtension.createFilterExtension(true, ImageFilterExtension.values());
    private Label pictureLabel;
    private T modifyImageLink;
    private T deleteImageLink;
    private byte[] imageByteArray;
    private Image resizedPictureImage;
    private Integer maxImageWidth = 96;
    private Integer maxImageHeight = 96;
    protected ResourceBundle resources;
    private Image defaultImage;
    private String[] extensions;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private GridData pictureLabelImageGridData;
    private MenuItem deleteItem;

    public AbstractPictureControl(Composite parent) {
        this(parent, 0, 0x1000800, 0, true);
    }

    public AbstractPictureControl(Composite parent, int compositeStyle, int labelStyle, int linkStyle) {
        this(parent, compositeStyle, labelStyle, linkStyle, true);
    }

    protected AbstractPictureControl(Composite parent, int compositeStyle, int labelStyle, int linkStyle, boolean createUI) {
        super(parent, compositeStyle);
        this.setLocale(Locale.getDefault());
        this.setFilterExtensions(DEFAULT_EXTENSIONS);
        if (createUI) {
            this.createUI(labelStyle, linkStyle);
        }
    }

    protected Composite createUI(int labelStyle, int linkStyle) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Composite parent = this.createComposite(this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        GridData g = new GridData();
        g.verticalAlignment = 128;
        parent.setLayoutData((Object)g);
        this.pictureLabel = this.createLabelImage(parent, labelStyle);
        this.modifyImageLink = this.createModifyLink(parent, linkStyle);
        this.deleteImageLink = this.createDeleteLink(parent, linkStyle);
        this.setDeleteLinkEnabled(false);
        return parent;
    }

    protected Label createLabelImage(Composite parent, int style) {
        Label label = this.createLabel(parent, style);
        this.pictureLabelImageGridData = new GridData();
        this.pictureLabelImageGridData.horizontalAlignment = 0x1000000;
        this.pictureLabelImageGridData.verticalAlignment = 0x1000000;
        this.pictureLabelImageGridData.horizontalSpan = 2;
        label.setLayoutData((Object)this.pictureLabelImageGridData);
        this.setMaxImageWidth(this.maxImageWidth);
        this.setMaxImageHeight(this.maxImageHeight);
        Menu menu = this.createMenu((Control)label);
        if (menu != null) {
            label.setMenu(menu);
        }
        return label;
    }

    protected Menu createMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.deleteItem = new MenuItem(menu, 0);
        this.deleteItem.setText(this.resources.getString(PICTURE_CONTROL_DELETE));
        this.deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPictureControl.this.handleDeleteImage();
            }
        });
        MenuItem modifyItem = new MenuItem(menu, 0);
        modifyItem.setText(this.resources.getString(PICTURE_CONTROL_MODIFY));
        modifyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPictureControl.this.handleModifyImage();
            }
        });
        return menu;
    }

    private T createModifyLink(Composite parent, int style) {
        T modifyImageLink = this.createLink(parent, style);
        GridData gridData = new GridData(2, 2, true, false);
        modifyImageLink.setLayoutData((Object)gridData);
        this.setLinkText(modifyImageLink, this.resources.getString(PICTURE_CONTROL_MODIFY));
        this.addModifyImageHandler(modifyImageLink);
        return modifyImageLink;
    }

    private T createDeleteLink(Composite parent, int style) {
        T deleteImageLink = this.createLink(parent, style);
        GridData gridData = new GridData(2, 2, true, false);
        deleteImageLink.setLayoutData((Object)gridData);
        this.setLinkText(deleteImageLink, this.resources.getString(PICTURE_CONTROL_DELETE));
        this.addDeleteImageHandler(deleteImageLink);
        return deleteImageLink;
    }

    public void setModifyImageLinkText(String text) {
        this.setLinkText(this.getModifyImageLink(), text);
    }

    public void setDeleteImageLinkText(String text) {
        this.setLinkText(this.getDeleteImageLink(), text);
    }

    protected void handleDeleteImage() {
        this.setImageByteArray(null);
    }

    public void setFilterExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    protected void handleModifyImage() {
        FileDialog fd = new FileDialog(this.getShell(), this.getFileDialogStyle());
        this.configure(fd);
        String selected = fd.open();
        if (selected != null && selected.length() > 0) {
            File f = new File(selected);
            try {
                FileInputStream in = new FileInputStream(f);
                this.setImageStream(in);
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    protected void configure(FileDialog fd) {
        fd.setText(this.resources.getString(PICTURE_CONTROL_FILEDIALOG_TEXT));
        if (this.extensions != null) {
            fd.setFilterExtensions(this.extensions);
        }
    }

    protected int getFileDialogStyle() {
        return 66804;
    }

    protected void handleError(Throwable e) {
        e.printStackTrace();
    }

    public Label getPictureLabel() {
        return this.pictureLabel;
    }

    public T getModifyImageLink() {
        return this.modifyImageLink;
    }

    public T getDeleteImageLink() {
        return this.deleteImageLink;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    public void setImageStream(InputStream stream) throws IOException {
        if (stream == null) {
            this.setImageByteArray(null);
        } else {
            this.setImageByteArray(IOUtils.toByteArray(stream));
        }
    }

    public InputStream getImageStream() {
        byte[] imageByteArray = this.getImageByteArray();
        if (imageByteArray == null) {
            return null;
        }
        return new ByteArrayInputStream(imageByteArray);
    }

    public void setImageByteArray(byte[] imageByteArray) {
        byte[] oldImageByteArray = this.imageByteArray;
        this.imageByteArray = imageByteArray;
        this.disposePictureImage();
        if (imageByteArray != null) {
            ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(imageByteArray));
            ImageData resizedImageData = this.getResizedImageData(imageData);
            this.resizedPictureImage = new Image((Device)super.getDisplay(), resizedImageData);
            this.pictureLabel.setImage(this.resizedPictureImage);
            this.setDeleteLinkEnabled(true);
        } else {
            this.pictureLabel.setImage(this.defaultImage);
            this.setDeleteLinkEnabled(false);
        }
        this.propertyChangeSupport.firePropertyChange(IMAGE_BYTEARRAY_PROPERTY, oldImageByteArray, imageByteArray);
    }

    protected ImageData getResizedImageData(ImageData imageData) {
        int height = imageData.height;
        int width = imageData.width;
        if (height <= this.maxImageHeight) {
            return imageData;
        }
        int newHeight = this.maxImageHeight;
        float w = width;
        float h = height;
        float nw = w / h * (float)this.maxImageHeight.intValue();
        int newWidth = (int)nw;
        return imageData.scaledTo(newWidth, newHeight);
    }

    public byte[] getImageByteArray() {
        return this.imageByteArray;
    }

    public void setLocale(Locale locale) {
        this.checkWidget();
        if (locale == null) {
            SWT.error((int)4);
        }
        this.resources = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public void setMaxImageHeight(Integer maxImageHeight) {
        this.maxImageHeight = maxImageHeight;
        this.pictureLabelImageGridData.heightHint = maxImageHeight != null ? maxImageHeight : -1;
    }

    public Integer getMaxImageHeight() {
        return this.maxImageHeight;
    }

    public void setMaxImageWidth(Integer maxImageWidth) {
        this.maxImageWidth = maxImageWidth;
        this.pictureLabelImageGridData.widthHint = maxImageWidth != null ? maxImageWidth : -1;
    }

    public Integer getMaxImageWidth() {
        return this.maxImageWidth;
    }

    public void setDefaultImage(Image defaultImage) {
        this.defaultImage = defaultImage;
        ImageData imageData = defaultImage.getImageData();
        this.setMaxImageHeight(imageData.height);
        this.setMaxImageWidth(imageData.width);
        this.setImageByteArray(null);
    }

    private void setDeleteLinkEnabled(boolean enabled) {
        this.deleteImageLink.setEnabled(enabled);
        if (this.deleteItem != null) {
            this.deleteItem.setEnabled(enabled);
        }
    }

    private void disposePictureImage() {
        if (this.resizedPictureImage != null && !this.resizedPictureImage.isDisposed()) {
            this.resizedPictureImage.dispose();
        }
    }

    public void dispose() {
        this.disposePictureImage();
        super.dispose();
    }

    protected abstract Label createLabel(Composite var1, int var2);

    protected abstract T createLink(Composite var1, int var2);

    protected abstract Composite createComposite(Composite var1, int var2);

    protected abstract void setLinkText(T var1, String var2);

    protected abstract void addModifyImageHandler(T var1);

    protected abstract void addDeleteImageHandler(T var1);
}

