/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.net.URLConnection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.nebula.widgets.geomap.OsmTileServer;
import org.eclipse.nebula.widgets.geomap.PointD;
import org.eclipse.nebula.widgets.geomap.TileRef;
import org.eclipse.nebula.widgets.geomap.TileServer;
import org.eclipse.nebula.widgets.geomap.internal.DefaultMouseHandler;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class GeoMap
extends Canvas {
    private static final Logger log = Logger.getLogger(GeoMap.class.getName());
    public static final String NAMEFINDER_URL = "http://nominatim.openstreetmap.org/search";
    public static final String ABOUT_MSG = "MapWidget - Minimal Openstreetmap/Maptile Viewer\r\nRequirements: Java + SWT. Opensource and licensed under EPL.\r\n\r\nWeb/Source: <a href=\"http://mappanel.sourceforge.net\">http://mappanel.sourceforge.net</a>\r\nWritten by stepan.rutz. Contact <a href=\"mailto:stepan.rutz@gmx.de?subject=SWT%20MapWidget\">stepan.rutz@gmx.de</a>\r\n\r\nTileserver and Nominationserver are accessed online and are part of Openstreetmap.org and not of this software.\r\n";
    private static final int TILE_SIZE = 256;
    public static final int DEFAULT_CACHE_SIZE = 256;
    public static final int DEFAULT_NUMBER_OF_IMAGEFETCHER_THREADS = 4;
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private Point mapSize = new Point(0, 0);
    private Point mapPosition = new Point(0, 0);
    private int zoom;
    private AtomicLong zoomStamp = new AtomicLong();
    private TileServer tileServer = OsmTileServer.TILESERVERS[0];
    private TileCache cache = new TileCache();
    private Stats stats = new Stats();
    private Point mouseCoords = new Point(0, 0);
    private DefaultMouseHandler defaultMouseHandler = new DefaultMouseHandler(this);
    private BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private ThreadFactory threadFactory = new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("Async Image Loader " + t.getId() + " " + System.identityHashCode(t));
            t.setDaemon(true);
            return t;
        }
    };
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 16, 2L, TimeUnit.SECONDS, this.workQueue, this.threadFactory);
    private Color waitBackground;
    private Color waitForeground;
    private final int cacheSize;
    private int zoomMargin = 10;

    private void redraw(TileRef tile) {
        this.redraw();
    }

    public GeoMap(Composite parent, int style) {
        this(parent, style, new Point(275091, 180145), 11);
    }

    public GeoMap(Composite parent, int style, Point mapPosition, int zoom) {
        this(parent, style, mapPosition, zoom, 256);
    }

    public GeoMap(Composite parent, int style, Point mapPosition, int zoom, int cacheSize) {
        super(parent, 0x20000000 | style);
        this.cacheSize = cacheSize;
        this.waitBackground = new Color((Device)this.getDisplay(), 136, 136, 136);
        this.waitForeground = new Color((Device)this.getDisplay(), 119, 119, 119);
        this.setZoom(zoom);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GeoMap.this.widgetDisposed(e);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GeoMap.this.paintControl(e);
            }
        });
        MouseCoordsHandler mouseCoordsHandler = new MouseCoordsHandler();
        this.addMouseListener(mouseCoordsHandler);
        this.addMouseMoveListener(mouseCoordsHandler);
        this.setMapPosition(mapPosition);
        this.addMouseHandler((EventListener)((Object)this.defaultMouseHandler));
    }

    public DefaultMouseHandler getDefaultMouseHandler() {
        return this.defaultMouseHandler;
    }

    public void addMouseHandler(EventListener listener) {
        if (listener instanceof MouseListener) {
            this.addMouseListener((MouseListener)listener);
        }
        if (listener instanceof MouseMoveListener) {
            this.addMouseMoveListener((MouseMoveListener)listener);
        }
        if (listener instanceof MouseTrackListener) {
            this.addMouseTrackListener((MouseTrackListener)listener);
        }
        if (listener instanceof MouseWheelListener) {
            this.addMouseWheelListener((MouseWheelListener)listener);
        }
        if (listener instanceof PaintListener) {
            this.addPaintListener((PaintListener)listener);
        }
    }

    public void removeMouseHandler(EventListener listener) {
        if (listener instanceof MouseListener) {
            this.removeMouseListener((MouseListener)listener);
        }
        if (listener instanceof MouseMoveListener) {
            this.removeMouseMoveListener((MouseMoveListener)listener);
        }
        if (listener instanceof MouseTrackListener) {
            this.removeMouseTrackListener((MouseTrackListener)listener);
        }
        if (listener instanceof MouseWheelListener) {
            this.removeMouseWheelListener((MouseWheelListener)listener);
        }
        if (listener instanceof PaintListener) {
            this.removePaintListener((PaintListener)listener);
        }
    }

    public TileServer getTileServer() {
        return this.tileServer;
    }

    public Stats getStats() {
        return this.stats;
    }

    public TileCache getCache() {
        return this.cache;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    protected void paintControl(PaintEvent e) {
        this.stats.reset();
        long t0 = System.currentTimeMillis();
        int x0 = (int)Math.floor((double)this.mapPosition.x / 256.0);
        int y0 = (int)Math.floor((double)this.mapPosition.y / 256.0);
        Point size = this.getSize();
        int x1 = (int)Math.ceil(((double)this.mapPosition.x + (double)size.x) / 256.0);
        int y1 = (int)Math.ceil(((double)this.mapPosition.y + (double)size.y) / 256.0);
        int dy = y0 * 256 - this.mapPosition.y;
        int y = y0;
        while (y < y1) {
            int dx = x0 * 256 - this.mapPosition.x;
            int x = x0;
            while (x < x1) {
                if (dx + 256 >= e.x && dy + 256 >= e.y && dx <= e.x + e.width && dy <= e.y + e.height) {
                    this.paintTile(e.gc, dx, dy, x, y);
                } else {
                    System.out.println(String.valueOf(dx) + "," + dy + " -> " + e.x + "," + e.y + "-" + e.width + "x" + e.height);
                }
                dx += 256;
                ++this.stats.tileCount;
                ++x;
            }
            dy += 256;
            ++y;
        }
        long t1 = System.currentTimeMillis();
        this.stats.dt = t1 - t0;
    }

    private void paintTile(GC gc, int dx, int dy, int x, int y) {
        boolean drawImage;
        Display display = this.getDisplay();
        boolean DRAW_IMAGES = true;
        boolean DEBUG = false;
        boolean DRAW_OUT_OF_BOUNDS = true;
        boolean imageDrawn = false;
        int xTileCount = 1 << this.zoom;
        int yTileCount = 1 << this.zoom;
        boolean tileInBounds = x >= 0 && x < xTileCount && y >= 0 && y < yTileCount;
        boolean bl = drawImage = DRAW_IMAGES && tileInBounds;
        if (drawImage) {
            TileRef tileRef = new TileRef(x, y, this.zoom);
            AsyncImage image = (AsyncImage)this.cache.get(tileRef);
            if (image == null) {
                image = new AsyncImage(tileRef, this.tileServer.getTileURL(tileRef));
                this.cache.put(tileRef, image);
            }
            if (image.getImage(this.getDisplay()) != null) {
                gc.drawImage(image.getImage(this.getDisplay()), dx, dy);
                imageDrawn = true;
            } else {
                tileRef = new TileRef(x / 2, y / 2, this.zoom - 1);
                image = (AsyncImage)this.cache.get(tileRef);
                if (image != null && image.getImage(this.getDisplay()) != null) {
                    gc.drawImage(image.getImage(this.getDisplay()), x % 2 == 0 ? 0 : 128, y % 2 == 0 ? 0 : 128, 128, 128, dx, dy, 256, 256);
                    imageDrawn = true;
                }
            }
        }
        if (DEBUG && !imageDrawn && (tileInBounds || DRAW_OUT_OF_BOUNDS)) {
            gc.setBackground(display.getSystemColor(tileInBounds ? 5 : 3));
            gc.fillRectangle(dx + 4, dy + 4, 248, 248);
            gc.setForeground(display.getSystemColor(2));
            String s = "T " + x + ", " + y + (!tileInBounds ? " #" : "");
            gc.drawString(s, dx + 4 + 8, dy + 4 + 12);
        } else if (!DEBUG && !imageDrawn && tileInBounds) {
            gc.setBackground(this.waitBackground);
            gc.fillRectangle(dx, dy, 256, 256);
            gc.setForeground(this.waitForeground);
            int yl = 0;
            while (yl < 256) {
                gc.drawLine(dx, dy + yl, dx + 256, dy + yl);
                yl += 32;
            }
            int xl = 0;
            while (xl < 256) {
                gc.drawLine(dx + xl, dy, dx + xl, dy + 256);
                xl += 32;
            }
        }
    }

    protected void widgetDisposed(DisposeEvent e) {
        this.waitBackground.dispose();
        this.waitForeground.dispose();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void setTileServer(TileServer tileServer) {
        this.tileServer = tileServer;
        this.cache.clear();
        this.redraw();
    }

    public Point getMapPosition() {
        return new Point(this.mapPosition.x, this.mapPosition.y);
    }

    public void setMapPosition(Point mapPosition) {
        this.setMapPosition(mapPosition.x, mapPosition.y);
    }

    public void setMapPosition(int x, int y) {
        if (this.mapPosition.x == x && this.mapPosition.y == y) {
            return;
        }
        Point oldMapPosition = this.getMapPosition();
        this.mapPosition.x = x;
        this.mapPosition.y = y;
        this.pcs.firePropertyChange("mapPosition", oldMapPosition, this.getMapPosition());
    }

    public void translateMapPosition(int tx, int ty) {
        this.setMapPosition(this.mapPosition.x + tx, this.mapPosition.y + ty);
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (zoom == this.zoom) {
            return;
        }
        this.zoomStamp.incrementAndGet();
        int oldZoom = this.zoom;
        this.zoom = Math.min(this.tileServer.getMaxZoom(), zoom);
        this.mapSize.x = this.getXMax();
        this.mapSize.y = this.getYMax();
        this.pcs.firePropertyChange("zoom", oldZoom, zoom);
    }

    public void zoomIn(Point pivot) {
        if (this.getZoom() >= this.tileServer.getMaxZoom()) {
            return;
        }
        Point mapPosition = this.getMapPosition();
        int dx = pivot.x;
        int dy = pivot.y;
        this.setZoom(this.getZoom() + 1);
        this.setMapPosition(mapPosition.x * 2 + dx, mapPosition.y * 2 + dy);
        this.redraw();
    }

    public void zoomOut(Point pivot) {
        if (this.getZoom() <= 1) {
            return;
        }
        Point mapPosition = this.getMapPosition();
        int dx = pivot.x;
        int dy = pivot.y;
        this.setZoom(this.getZoom() - 1);
        this.setMapPosition((mapPosition.x - dx) / 2, (mapPosition.y - dy) / 2);
        this.redraw();
    }

    public void zoomTo(Rectangle rect) {
        Rectangle zoomRectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        Point mapSize = this.getSize();
        Point pivot = new Point(0, 0);
        do {
            this.zoomOut(pivot);
            zoomRectangle.x /= 2;
            zoomRectangle.y /= 2;
            zoomRectangle.width /= 2;
            zoomRectangle.height /= 2;
        } while (Math.min(mapSize.x / (zoomRectangle.width + this.zoomMargin), mapSize.y / (zoomRectangle.height + this.zoomMargin)) < 1);
        while (Math.min(mapSize.x / (zoomRectangle.width + this.zoomMargin), mapSize.y / (zoomRectangle.height + this.zoomMargin)) > 1) {
            this.zoomIn(pivot);
            zoomRectangle.x *= 2;
            zoomRectangle.y *= 2;
            zoomRectangle.width *= 2;
            zoomRectangle.height *= 2;
        }
        this.setMapPosition(zoomRectangle.x + (zoomRectangle.width - mapSize.x) / 2, zoomRectangle.y + (zoomRectangle.height - mapSize.y) / 2);
    }

    public int getXTileCount() {
        return 1 << this.zoom;
    }

    public int getYTileCount() {
        return 1 << this.zoom;
    }

    public int getXMax() {
        return 256 * this.getXTileCount();
    }

    public int getYMax() {
        return 256 * this.getYTileCount();
    }

    public Point getCursorPosition() {
        return new Point(this.mapPosition.x + this.mouseCoords.x, this.mapPosition.y + this.mouseCoords.y);
    }

    public Point getTile(Point position) {
        return new Point((int)Math.floor((double)position.x / 256.0), (int)Math.floor((double)position.y / 256.0));
    }

    public Point getCenterPosition() {
        Point size = this.getSize();
        return new Point(this.mapPosition.x + size.x / 2, this.mapPosition.y + size.y / 2);
    }

    public void setCenterPosition(Point p) {
        Point size = this.getSize();
        this.setMapPosition(p.x - size.x / 2, p.y - size.y / 2);
    }

    public PointD getLongitudeLatitude(Point position) {
        return new PointD(GeoMap.position2lon(position.x, this.getZoom()), GeoMap.position2lat(position.y, this.getZoom()));
    }

    public Point computePosition(PointD coords) {
        int x = GeoMap.lon2position(coords.x, this.getZoom());
        int y = GeoMap.lat2position(coords.y, this.getZoom());
        return new Point(x, y);
    }

    public static String format(double d) {
        return String.format("%.5f", d);
    }

    public static double position2lon(int x, int z) {
        double xmax = 256 * (1 << z);
        return (double)x / xmax * 360.0 - 180.0;
    }

    public static double position2lat(int y, int z) {
        double ymax = 256 * (1 << z);
        return Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * (double)y / ymax)));
    }

    public static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    public static double tile2lat(int y, int z) {
        return Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z))));
    }

    public static int lon2position(double lon, int z) {
        double xmax = 256 * (1 << z);
        return (int)Math.floor((lon + 180.0) / 360.0 * xmax);
    }

    public static int lat2position(double lat, int z) {
        double ymax = 256 * (1 << z);
        return (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * ymax);
    }

    public static String getTileNumber(TileServer tileServer, double lat, double lon, int zoom) {
        int x = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int y = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        return tileServer.getTileURL(new TileRef(x, y, zoom));
    }

    public final class AsyncImage
    implements Runnable {
        private final TileRef tile;
        private final String tileUrl;
        private volatile long stamp;
        private final AtomicReference<ImageData> imageData;
        private Image image;

        public AsyncImage(TileRef tile, String tileUrl) {
            this.stamp = GeoMap.this.zoomStamp.longValue();
            this.imageData = new AtomicReference();
            this.image = null;
            this.tile = tile;
            this.tileUrl = tileUrl;
            GeoMap.this.executor.execute(new FutureTask<Boolean>(this, Boolean.TRUE));
        }

        public void run() {
            if (this.stamp != GeoMap.this.zoomStamp.longValue()) {
                try {
                    if (!GeoMap.this.getDisplay().isDisposed()) {
                        GeoMap.this.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                GeoMap.this.cache.remove(AsyncImage.this.tile);
                            }
                        });
                    }
                }
                catch (SWTException sWTException) {
                    log.log(Level.INFO, "swt exception during redraw display-race, ignoring");
                }
                return;
            }
            try {
                URLConnection con = new URL(this.tileUrl).openConnection();
                con.setRequestProperty("User-Agent", "org.eclipse.nebula.widgets.geomap.GeoMap");
                this.imageData.set(new ImageData(con.getInputStream()));
                try {
                    if (!GeoMap.this.getDisplay().isDisposed()) {
                        GeoMap.this.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                GeoMap.this.redraw(AsyncImage.this.tile);
                            }
                        });
                    }
                }
                catch (SWTException sWTException) {
                    log.log(Level.INFO, "swt exception during redraw display-race, ignoring");
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "failed to load imagedata from url: " + this.tileUrl, e);
            }
        }

        public Image getImage(Display display) {
            this.checkThread(display);
            if (this.image == null && this.imageData.get() != null) {
                this.image = new Image((Device)display, this.imageData.get());
            }
            return this.image;
        }

        public void dispose(Display display) {
            this.checkThread(display);
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
        }

        private void checkThread(Display display) {
            if (display.getThread() != Thread.currentThread()) {
                throw new IllegalStateException("wrong thread to pick up the image");
            }
        }
    }

    private class MouseCoordsHandler
    implements MouseListener,
    MouseMoveListener {
        private MouseCoordsHandler() {
        }

        private void setMouseCoords(MouseEvent e) {
            GeoMap.this.mouseCoords = new Point(e.x, e.y);
        }

        public void mouseDown(MouseEvent e) {
            this.setMouseCoords(e);
        }

        public void mouseMove(MouseEvent e) {
            this.setMouseCoords(e);
        }

        public void mouseUp(MouseEvent e) {
            this.setMouseCoords(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.setMouseCoords(e);
        }
    }

    public static class Stats {
        public int tileCount;
        public long dt;

        private Stats() {
            this.reset();
        }

        private void reset() {
            this.tileCount = 0;
            this.dt = 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TileCache
    extends LinkedHashMap<TileRef, AsyncImage> {
        private TileCache() {
            super(GeoMap.this.cacheSize, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<TileRef, AsyncImage> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > GeoMap.this.cacheSize;
            if (remove) {
                eldest.getValue().dispose(GeoMap.this.getDisplay());
            }
            return remove;
        }
    }
}

