/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.nebula.widgets.geomap.GeoMap;
import org.eclipse.nebula.widgets.geomap.internal.InfoPage;
import org.eclipse.nebula.widgets.geomap.internal.PageContainer;
import org.eclipse.nebula.widgets.geomap.internal.ResultsPage;
import org.eclipse.nebula.widgets.geomap.internal.SearchPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class GeoMapBrowser
extends Composite {
    private SashForm sashForm;
    private PageContainer pageContainer;
    private GeoMap geoMap;
    private SearchPage searchPage;
    private ResultsPage resultsPage;
    private InfoPage infoPage;

    public GeoMapBrowser(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.sashForm = new SashForm((Composite)this, 256);
        this.sashForm.setLayout((Layout)new FillLayout());
        this.pageContainer = new PageContainer((Composite)this.sashForm, 0);
        this.geoMap = new GeoMap((Composite)this.sashForm, 0);
        this.sashForm.setWeights(new int[]{100, 200});
        this.searchPage = new SearchPage(this);
        this.resultsPage = new ResultsPage(this);
        this.infoPage = new InfoPage(this);
        this.pageContainer.setPages(this.searchPage, this.resultsPage, this.infoPage);
        this.pageContainer.showPage(0);
        this.geoMap.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                GeoMapBrowser.this.infoPage.updateInfos();
            }
        });
        this.geoMap.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GeoMapBrowser.this.infoPage.updateInfos();
            }
        });
        this.geoMap.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                GeoMapBrowser.this.infoPage.updateInfos();
            }
        });
    }

    public GeoMap getGeoMap() {
        return this.geoMap;
    }

    public SearchPage getSearchPage() {
        return this.searchPage;
    }

    public InfoPage getInfoPage() {
        return this.infoPage;
    }

    public ResultsPage getResultsPage() {
        return this.resultsPage;
    }

    public PageContainer getPageContainer() {
        return this.pageContainer;
    }

    private void createMenu(Shell shell) {
        Menu bar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(bar);
        MenuItem fileItem = new MenuItem(bar, 64);
        fileItem.setText("&File");
        Menu submenu = new Menu((Decorations)shell, 4);
        fileItem.setMenu(submenu);
        MenuItem item = new MenuItem(submenu, 8);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Runtime.getRuntime().halt(0);
            }
        });
        item.setText("E&xit\tCtrl+W");
        item.setAccelerator(SWT.MOD1 + 87);
    }
}

