/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap;

import java.text.MessageFormat;
import org.eclipse.nebula.widgets.geomap.TileRef;

public class TileServer {
    private String url;
    private String urlFormat = "{0}/{1}/{2}.png";
    private final int maxZoom;
    private boolean broken;

    private void parseUrl(String url) {
        int pos = url.indexOf("{");
        if (pos > 0) {
            this.url = url.substring(0, pos);
            this.urlFormat = url.substring(pos);
        } else {
            this.url = url;
        }
    }

    public TileServer(String url, int maxZoom, String urlFormat) {
        this.url = url;
        this.maxZoom = maxZoom;
        this.urlFormat = urlFormat;
    }

    public TileServer(String url, int maxZoom) {
        this.parseUrl(url);
        this.maxZoom = maxZoom;
    }

    protected Object[] getURLFormatArguments(TileRef tile) {
        return new Object[]{String.valueOf(tile.z), String.valueOf(tile.x), String.valueOf(tile.y)};
    }

    protected String getTileURL(TileRef tile, String urlFormat, Object[] formatArguments) {
        return String.valueOf(this.url) + MessageFormat.format(urlFormat, formatArguments);
    }

    public String getTileURL(TileRef tile) {
        return this.urlFormat != null ? this.getTileURL(tile, this.urlFormat, this.getURLFormatArguments(tile)) : null;
    }

    public String toString() {
        return this.url;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public String getURL() {
        return this.url;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }
}

