/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.renderers.navigation;

import java.util.Locale;
import org.eclipse.nebula.widgets.pagination.AbstractPageControllerComposite;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.PaginationHelper;
import org.eclipse.nebula.widgets.pagination.Resources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class ResultAndNavigationPageLinksRenderer
extends AbstractPageControllerComposite
implements SelectionListener {
    private static final RGB RED_COLOR = new RGB(255, 0, 0);
    private static final String END_HREF = "</a>";
    private static final String OPEN_START_HREF = "<a href=\"";
    private static final String OPEN_END_HREF = "\" >";
    private Label resultLabel;
    private Link previousLink;
    private Link nextLink;
    private Link pageLinks;

    public ResultAndNavigationPageLinksRenderer(Composite parent, int style, PageableController controller) {
        super(parent, style, controller);
        this.refreshEnabled(controller);
    }

    protected void createUI(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createLeftContainer(parent);
        this.createRightContainer(parent);
    }

    private void createLeftContainer(Composite parent) {
        Composite left = this.createComposite(parent, 0);
        GridData data = new GridData(768);
        left.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        left.setLayout((Layout)layout);
        this.resultLabel = new Label(left, 0);
        this.resultLabel.setLayoutData((Object)new GridData(768));
    }

    private void createRightContainer(Composite parent) {
        Composite right = this.createComposite(parent, 0);
        right.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        right.setLayout((Layout)layout);
        this.previousLink = this.createHyperlink(right, 0);
        this.setLinkText(this.previousLink, Resources.getText("PaginationRenderer.previous", this.getLocale()));
        this.previousLink.setLayoutData((Object)new GridData(131072));
        this.previousLink.addSelectionListener((SelectionListener)this);
        this.pageLinks = this.createHyperlink(right, 0);
        this.pageLinks.setForeground(this.getColor());
        this.pageLinks.setLayoutData((Object)new GridData(768));
        this.pageLinks.addSelectionListener((SelectionListener)this);
        this.nextLink = this.createHyperlink(right, 0);
        this.setLinkText(this.nextLink, Resources.getText("PaginationRenderer.next", this.getLocale()));
        this.nextLink.setLayoutData((Object)new GridData(16384));
        this.nextLink.addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Link hyperlink = (Link)e.getSource();
        int newCurrentPage = 0;
        if (hyperlink == this.previousLink) {
            newCurrentPage = this.getController().getCurrentPage() - 1;
        } else if (hyperlink == this.nextLink) {
            newCurrentPage = this.getController().getCurrentPage() + 1;
        } else if (hyperlink == this.pageLinks) {
            newCurrentPage = Integer.parseInt(e.text);
        }
        this.getController().setCurrentPage(newCurrentPage);
    }

    public void pageIndexChanged(int oldPageNumber, int newPageNumber, PageableController controller) {
        int[] indexes = PaginationHelper.getPageIndexes(controller.getCurrentPage(), controller.getTotalPages(), 10);
        this.pageLinks.setText(this.rebuildLinks(indexes, newPageNumber));
        this.refreshEnabled(controller);
    }

    private String rebuildLinks(int[] indexes, int newPageNumber) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < indexes.length) {
            int j = indexes[i];
            if (i > 0) {
                s.append(' ');
            }
            if (j == -1) {
                s.append(Resources.getText("PaginationRenderer.separator", this.getLocale()));
            } else if (j == newPageNumber) {
                s.append(String.valueOf(j + 1));
            } else {
                this.addA(String.valueOf(j), String.valueOf(j + 1), s);
            }
            ++i;
        }
        return s.toString();
    }

    public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
    }

    public void totalElementsChanged(long oldTotalElements, long newTotalElements, PageableController controller) {
        int[] indexes = PaginationHelper.getPageIndexes(controller.getCurrentPage(), controller.getTotalPages(), 10);
        this.pageLinks.setText(this.rebuildLinks(indexes, 0));
        this.refreshEnabled(controller);
    }

    public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController paginationController) {
    }

    private void refreshEnabled(PageableController controller) {
        this.resultLabel.setText(PaginationHelper.getResultsText(controller, this.getLocale()));
        this.nextLink.setEnabled(controller.hasNextPage());
        this.previousLink.setEnabled(controller.hasPreviousPage());
    }

    protected Composite createComposite(Composite parent, int style) {
        return new Composite(parent, style);
    }

    protected Link createHyperlink(Composite parent, int style) {
        return new Link(parent, style);
    }

    protected void setLinkText(Link link, String text) {
        StringBuilder a = new StringBuilder();
        this.addA(text, text, a);
        link.setText(a.toString());
    }

    private void addA(String href, String content, StringBuilder a) {
        a.append(OPEN_START_HREF);
        a.append(href);
        a.append(OPEN_END_HREF);
        a.append(content);
        a.append(END_HREF);
    }

    protected Color getColor() {
        return Resources.getColor(RED_COLOR);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.setLinkText(this.previousLink, Resources.getText("PaginationRenderer.previous", this.getLocale()));
        this.setLinkText(this.nextLink, Resources.getText("PaginationRenderer.next", this.getLocale()));
        this.resultLabel.setText(PaginationHelper.getResultsText(this.getController(), this.getLocale()));
    }
}

