/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.radiogroup;

import org.eclipse.nebula.widgets.radiogroup.RadioGroup;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class RadioItem
extends Item {
    private RadioGroup parent;
    private Button button;

    public RadioItem(RadioGroup parent, int style) {
        this(parent, style, -1);
    }

    public RadioItem(RadioGroup parent, int style, int index) {
        super((Widget)parent, RadioItem.checkStyle(style), RadioItem.checkIndex(parent, index));
        this.parent = parent;
        this.button = parent.createButton(this.getStyle(), index);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    RadioItem.this.handleSelection(event);
                } else if (event.type == 12) {
                    RadioItem.this.handleDispose(event);
                }
            }
        };
        this.button.addListener(13, listener);
        this.addListener(12, listener);
        parent.addItem(this, index);
    }

    private static int checkStyle(int style) {
        int result = 0;
        if ((style & 0x4000) != 0) {
            result |= 0x4000;
        } else if ((style & 0x1000000) != 0) {
            result |= 0x1000000;
        } else if ((style & 0x20000) != 0) {
            result |= 0x20000;
        }
        return result;
    }

    private static int checkIndex(RadioGroup parent, int position) {
        if (position == -1) {
            return parent.getItemCount();
        }
        if (position < 0 || position > parent.getItemCount()) {
            SWT.error((int)5);
        }
        return position;
    }

    private void handleSelection(Event event) {
        this.parent.itemSelected(this);
    }

    private void handleDispose(Event event) {
        if (this.parent != null) {
            this.parent.removeItem(this);
        }
        if (this.button != null) {
            this.button.dispose();
            if (this.parent != null && !this.parent.isDisposed()) {
                this.parent.layout(false);
            }
        }
        this.parent = null;
        this.button = null;
    }

    public RadioGroup getParent() {
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.button.getText();
    }

    public void setText(String string) {
        this.checkWidget();
        this.button.setText(string);
        this.parent.layout(new Control[]{this.button});
    }

    public Image getImage() {
        this.checkWidget();
        return this.button.getImage();
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.button.setImage(image);
        this.parent.layout(new Control[]{this.button});
    }

    public Color getForeground() {
        this.checkWidget();
        return this.button.getForeground();
    }

    public void setForeground(Color foreground) {
        this.checkWidget();
        if (foreground == null) {
            SWT.error((int)4);
        }
        this.button.setForeground(foreground);
    }

    public Color getBackground() {
        this.checkWidget();
        return this.button.getBackground();
    }

    public void setBackground(Color background) {
        this.checkWidget();
        if (background == null) {
            SWT.error((int)4);
        }
        this.button.setBackground(background);
    }

    public Font getFont() {
        this.checkWidget();
        return this.button.getFont();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font == null) {
            SWT.error((int)4);
        }
        this.button.setFont(font);
    }

    public Button getButton() {
        return this.button;
    }

    public boolean isSelected() {
        return this.button.getSelection();
    }

    void select() {
        this.button.setSelection(true);
        this.parent.itemSelected(this);
    }

    void deselect() {
        this.button.setSelection(false);
        this.parent.itemSelected(this);
    }

    void clear() {
        this.setText("");
        this.setImage(null);
        this.setFont(this.parent.getFont());
        this.setForeground(this.parent.getForeground());
        this.setBackground(this.parent.getBackground());
    }
}

