/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.treemapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.nebula.widgets.treemapper.INewMappingListener;
import org.eclipse.nebula.widgets.treemapper.ISemanticTreeMapperSupport;
import org.eclipse.nebula.widgets.treemapper.TreeMapperUIConfigProvider;
import org.eclipse.nebula.widgets.treemapper.internal.Activator;
import org.eclipse.nebula.widgets.treemapper.internal.LinkFigure;
import org.eclipse.nebula.widgets.treemapper.internal.Messages;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMapper<M, L, R>
implements ISelectionProvider {
    private SashForm control;
    private TreeMapperUIConfigProvider uiConfig;
    private TreeViewer leftTreeViewer;
    private TreeViewer rightTreeViewer;
    private TreeItem leftTopItem;
    private TreeItem rightTopItem;
    private Canvas linkCanvas;
    private LightweightSystem linkSystem;
    private Figure linkRootFigure;
    private boolean canvasNeedRedraw;
    private List<M> mappings;
    private Map<LinkFigure, M> figuresToMappings;
    private Map<M, LinkFigure> mappingsToFigures;
    private LinkFigure selectedFigure;
    private M selectedMapping;
    private ISemanticTreeMapperSupport<M, L, R> semanticSupport;
    private IFigure warningFigure;
    private List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private IStructuredSelection currentSelection = new StructuredSelection();
    private List<INewMappingListener<M>> creationListeners = new ArrayList<INewMappingListener<M>>();

    public TreeMapper(Composite parent, ISemanticTreeMapperSupport<M, L, R> semanticSupport, TreeMapperUIConfigProvider uiConfig) {
        this.uiConfig = uiConfig;
        this.semanticSupport = semanticSupport;
        this.control = new SashForm(parent, 256);
        this.control.setLayout((Layout)new FillLayout());
        this.leftTreeViewer = new TreeViewer((Composite)this.control);
        this.linkCanvas = new Canvas((Composite)this.control, 0);
        this.linkCanvas.setLayout((Layout)new FillLayout());
        this.linkCanvas.setBackground(ColorConstants.white);
        this.linkSystem = new LightweightSystem(this.linkCanvas);
        this.linkRootFigure = new Figure();
        this.linkRootFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.linkSystem.setContents((IFigure)this.linkRootFigure);
        this.rightTreeViewer = new TreeViewer((Composite)this.control);
        this.figuresToMappings = new HashMap<LinkFigure, M>();
        this.mappingsToFigures = new HashMap<M, LinkFigure>();
        ControlListener resizeListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                TreeMapper.this.canvasNeedRedraw = true;
            }

            public void controlMoved(ControlEvent e) {
                TreeMapper.this.canvasNeedRedraw = true;
            }
        };
        this.leftTreeViewer.getTree().addControlListener(resizeListener);
        this.rightTreeViewer.getTree().addControlListener(resizeListener);
        this.linkCanvas.addControlListener(resizeListener);
        this.leftTreeViewer.getTree().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TreeMapper.this.canvasNeedRedraw || TreeMapper.this.leftTreeViewer.getTree().getTopItem() != TreeMapper.this.leftTopItem) {
                    TreeMapper.this.leftTopItem = TreeMapper.this.leftTreeViewer.getTree().getTopItem();
                    TreeMapper.this.redrawMappings();
                }
            }
        });
        this.rightTreeViewer.getTree().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TreeMapper.this.canvasNeedRedraw || TreeMapper.this.rightTreeViewer.getTree().getTopItem() != TreeMapper.this.rightTopItem) {
                    TreeMapper.this.rightTopItem = TreeMapper.this.rightTreeViewer.getTree().getTopItem();
                    TreeMapper.this.redrawMappings();
                    TreeMapper.this.canvasNeedRedraw = false;
                }
            }
        });
        TreeListener treeListener = new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                TreeMapper.this.canvasNeedRedraw = true;
            }

            public void treeCollapsed(TreeEvent e) {
                TreeMapper.this.canvasNeedRedraw = true;
            }
        };
        this.leftTreeViewer.getTree().addTreeListener(treeListener);
        this.rightTreeViewer.getTree().addTreeListener(treeListener);
        this.control.setWeights(new int[]{1, 2, 1});
        this.bindTreeForDND(this.leftTreeViewer, this.rightTreeViewer, 0x2000000);
        this.bindTreeForDND(this.rightTreeViewer, this.leftTreeViewer, 0x4000000);
    }

    public void setContentProviders(ITreeContentProvider leftContentProvider, ITreeContentProvider rightTreeContentProvider) {
        this.leftTreeViewer.setContentProvider((IContentProvider)leftContentProvider);
        this.rightTreeViewer.setContentProvider((IContentProvider)rightTreeContentProvider);
    }

    public void setLabelProviders(IBaseLabelProvider leftLabelProvider, IBaseLabelProvider rightLabelProvider) {
        this.leftTreeViewer.setLabelProvider(leftLabelProvider);
        this.rightTreeViewer.setLabelProvider(rightLabelProvider);
    }

    public void setInput(Object leftTreeInput, Object rightTreeInput, List<M> mappings) {
        this.clearFigures();
        if (leftTreeInput != null) {
            this.leftTreeViewer.setInput(leftTreeInput);
        }
        if (rightTreeInput != null) {
            this.rightTreeViewer.setInput(rightTreeInput);
        }
        if (mappings != null) {
            this.mappings = mappings;
            this.canvasNeedRedraw = true;
        } else {
            this.mappings = new ArrayList<M>();
        }
        for (M mapping : this.mappings) {
            L leftItem = this.semanticSupport.resolveLeftItem(mapping);
            this.leftTreeViewer.expandToLevel(leftItem, 0);
            R rightItem = this.semanticSupport.resolveRightItem(mapping);
            this.rightTreeViewer.expandToLevel(rightItem, 0);
        }
    }

    private void redrawMappings() {
        if (this.mappings == null) {
            return;
        }
        boolean everythingOK = true;
        for (M mapping : this.mappings) {
            everythingOK &= this.drawMapping(mapping);
            if (mapping != this.selectedMapping) continue;
            LinkFigure newSelectedFigure = this.mappingsToFigures.get(mapping);
            this.applySelectedMappingFeedback(newSelectedFigure);
            this.selectedFigure = newSelectedFigure;
        }
        if (everythingOK && this.warningFigure != null) {
            this.linkRootFigure.remove(this.warningFigure);
            this.warningFigure = null;
        } else if (!everythingOK && this.warningFigure == null) {
            this.warningFigure = this.createWarningFigure();
            this.linkRootFigure.add(this.warningFigure, (Object)new Rectangle(5, 5, -1, -1));
        }
    }

    private IFigure createWarningFigure() {
        Image image = Display.getDefault().getSystemImage(8);
        ImageFigure res = new ImageFigure(image);
        res.setPreferredSize(10, 10);
        Label label = new Label(Messages.widgetInconsistency);
        res.setToolTip((IFigure)label);
        return res;
    }

    private void bindTreeForDND(final TreeViewer sourceTreeViewer, final TreeViewer targetTreeViewer, final int direction) {
        LocalSelectionTransfer sourceTransfer = LocalSelectionTransfer.getTransfer();
        LocalSelectionTransfer targetTransfer = LocalSelectionTransfer.getTransfer();
        sourceTreeViewer.addDragSupport(4, new Transfer[]{sourceTransfer}, (DragSourceListener)new TreeDragSourceEffect(sourceTreeViewer.getTree()){

            public void dragStart(DragSourceEvent event) {
                event.doit = !sourceTreeViewer.getSelection().isEmpty();
            }
        });
        targetTreeViewer.addDropSupport(4, new Transfer[]{targetTransfer}, (DropTargetListener)new TreeDropTargetEffect(targetTreeViewer.getTree()){

            public void dragEnter(DropTargetEvent event) {
                event.feedback = 25;
                event.detail = 4;
                super.dragEnter(event);
            }

            public void drop(DropTargetEvent event) {
                TreeMapper.this.performMappingByDrop(sourceTreeViewer, sourceTreeViewer.getSelection(), targetTreeViewer, (TreeItem)this.getItem(event.x, event.y), direction);
            }
        });
    }

    protected void performMappingByDrop(TreeViewer sourceTreeViewer, ISelection sourceData, TreeViewer targetTreeViewer, TreeItem targetTreeItem, int direction) {
        Object resolvedTargetItem = this.resolveTreeViewerItem(targetTreeViewer, targetTreeItem);
        for (Object sourceItem : ((IStructuredSelection)sourceData).toList()) {
            if (direction == 0x2000000) {
                this.createMapping(sourceItem, resolvedTargetItem);
                continue;
            }
            if (direction != 0x4000000) continue;
            this.createMapping(resolvedTargetItem, sourceItem);
        }
    }

    private void createMapping(L leftItem, R rightItem) {
        M newMapping = this.semanticSupport.createSemanticMappingObject(leftItem, rightItem);
        if (newMapping != null) {
            this.mappings.add(newMapping);
            this.refresh();
            this.drawMapping(newMapping);
            for (INewMappingListener<M> listener : this.creationListeners) {
                listener.mappingCreated(newMapping);
            }
        }
    }

    private boolean drawMapping(final M mapping) {
        LinkFigure previousFigure = this.mappingsToFigures.get(mapping);
        if (previousFigure != null) {
            previousFigure.deleteFromParent();
            this.mappingsToFigures.remove(mapping);
            this.figuresToMappings.remove(previousFigure);
        }
        final LinkFigure arrowFigure = new LinkFigure((IFigure)this.linkRootFigure);
        boolean leftItemVisible = true;
        TreeItem leftTreeItem = (TreeItem)this.leftTreeViewer.testFindItem(this.semanticSupport.resolveLeftItem(mapping));
        if (leftTreeItem == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.nebula.widgets.treemapper", "Could not find left entry of mapping " + mapping.toString() + " in left treeViewer."));
            return false;
        }
        TreeItem lastVisibleLeftTreeItem = leftTreeItem;
        while (leftTreeItem.getParentItem() != null) {
            if (!leftTreeItem.getParentItem().getExpanded()) {
                lastVisibleLeftTreeItem = leftTreeItem.getParentItem();
                leftItemVisible = false;
            }
            leftTreeItem = leftTreeItem.getParentItem();
        }
        arrowFigure.setLeftPoint(0, lastVisibleLeftTreeItem.getBounds().y + lastVisibleLeftTreeItem.getBounds().height / 2);
        arrowFigure.setLeftMappingVisible(leftItemVisible);
        boolean rightItemVisible = true;
        TreeItem rightTreeItem = (TreeItem)this.rightTreeViewer.testFindItem(this.semanticSupport.resolveRightItem(mapping));
        if (rightTreeItem == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.nebula.widgets.treemapper", "Could not find right entry of mapping " + mapping.toString() + " in right treeViewer."));
            return false;
        }
        TreeItem lastVisibleRightTreeItem = rightTreeItem;
        while (rightTreeItem.getParentItem() != null) {
            if (!rightTreeItem.getParentItem().getExpanded()) {
                lastVisibleRightTreeItem = rightTreeItem.getParentItem();
                rightItemVisible = false;
            }
            rightTreeItem = rightTreeItem.getParentItem();
        }
        arrowFigure.setRightPoint(this.linkRootFigure.getBounds().width, lastVisibleRightTreeItem.getBounds().y + rightTreeItem.getBounds().height / 2);
        arrowFigure.setRightMappingVisible(rightItemVisible);
        arrowFigure.setLineWidth(this.uiConfig.getDefaultArrowWidth());
        arrowFigure.seLineColor(this.uiConfig.getDefaultMappingColor());
        arrowFigure.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent me) {
                TreeMapper.this.fireMappingSelection(mapping, arrowFigure);
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        arrowFigure.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                TreeMapper.this.fireMouseEntered(mapping, arrowFigure);
            }

            public void mouseExited(MouseEvent me) {
                TreeMapper.this.fireMouseExited(mapping, arrowFigure);
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
        this.figuresToMappings.put(arrowFigure, mapping);
        this.mappingsToFigures.put(mapping, arrowFigure);
        return true;
    }

    private Object resolveTreeViewerItem(TreeViewer treeViewer, TreeItem treeItem) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
        ArrayList<Integer> locations = new ArrayList<Integer>();
        TreeItem parentTreeItem = treeItem.getParentItem();
        while (parentTreeItem != null) {
            int index = Arrays.asList(parentTreeItem.getItems()).indexOf(treeItem);
            locations.add(index);
            treeItem = parentTreeItem;
            parentTreeItem = treeItem.getParentItem();
        }
        if (treeItem != null) {
            int rootIndex = Arrays.asList(treeViewer.getTree().getItems()).indexOf(treeItem);
            locations.add(rootIndex);
        }
        Collections.reverse(locations);
        Object current = contentProvider.getElements(treeViewer.getInput())[(Integer)locations.get(0)];
        locations.remove(0);
        Iterator iterator = locations.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            current = contentProvider.getChildren(current)[index];
        }
        return current;
    }

    public SashForm getControl() {
        return this.control;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public IStructuredSelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection strSelection = (IStructuredSelection)selection;
        if (strSelection.isEmpty()) {
            this.currentSelection = new StructuredSelection();
            this.fireMouseExited(this.selectedMapping, this.mappingsToFigures.get(this.selectedMapping));
        } else {
            Object mapping = strSelection.getFirstElement();
            this.fireMappingSelection(mapping, this.mappingsToFigures.get(mapping));
        }
    }

    protected void fireMappingSelection(M mapping, LinkFigure arrowFigure) {
        if (this.selectedFigure != null) {
            this.applyDefaultMappingStyle(this.selectedFigure);
        }
        this.applySelectedMappingFeedback(arrowFigure);
        this.selectedFigure = arrowFigure;
        this.selectedMapping = mapping;
        this.currentSelection = new StructuredSelection(this.selectedMapping);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentSelection));
        }
    }

    private void unselect() {
        this.selectedMapping = null;
        this.selectedFigure = null;
        this.currentSelection = new StructuredSelection();
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentSelection));
        }
    }

    public void addNewMappingListener(INewMappingListener<M> listener) {
        this.creationListeners.add(listener);
    }

    private void applyDefaultMappingStyle(LinkFigure figure) {
        figure.seLineColor(this.uiConfig.getDefaultMappingColor());
        figure.setLineWidth(this.uiConfig.getDefaultArrowWidth());
    }

    private void applySelectedMappingFeedback(LinkFigure arrowFigure) {
        arrowFigure.seLineColor(this.uiConfig.getSelectedMappingColor());
        arrowFigure.setLineWidth(this.uiConfig.getHoverArrowWidth());
    }

    protected void fireMouseExited(M mapping, LinkFigure arrowFigure) {
        if (arrowFigure != this.selectedFigure) {
            this.applyDefaultMappingStyle(arrowFigure);
        }
    }

    protected void fireMouseEntered(M mapping, LinkFigure arrowFigure) {
        if (arrowFigure != this.selectedFigure) {
            arrowFigure.setLineWidth(this.uiConfig.getHoverArrowWidth());
        }
    }

    public TreeViewer getLeftTreeViewer() {
        return this.leftTreeViewer;
    }

    public TreeViewer getRightTreeViewer() {
        return this.rightTreeViewer;
    }

    public void refresh() {
        this.setInput(this.leftTreeViewer.getInput(), this.rightTreeViewer.getInput(), this.mappings);
        if (!this.mappings.contains(this.selectedMapping)) {
            this.unselect();
        }
        this.leftTreeViewer.refresh();
        this.rightTreeViewer.refresh();
        this.canvasNeedRedraw = true;
        this.control.layout(true);
    }

    private void clearFigures() {
        for (Map.Entry<M, LinkFigure> entry : this.mappingsToFigures.entrySet()) {
            entry.getValue().deleteFromParent();
        }
        this.mappingsToFigures.clear();
        this.figuresToMappings.clear();
    }
}

