/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw.example;

import org.eclipse.nebula.effects.stw.Transition;
import org.eclipse.nebula.effects.stw.example.AbstractSTWDemoFrame;
import org.eclipse.nebula.effects.stw.example.TransitionTest;
import org.eclipse.nebula.effects.stw.example.TransitionTest1;
import org.eclipse.nebula.effects.stw.example.TransitionTest2;
import org.eclipse.nebula.effects.stw.transitions.CubicRotationTransition;
import org.eclipse.nebula.effects.stw.transitions.FadeTransition;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class STWDemo {
    static final String[] demos = new String[]{"Demo1", "Demo2", "Demo3"};
    AbstractSTWDemoFrame[] demoFrames = new AbstractSTWDemoFrame[]{new TransitionTest(), new TransitionTest1(), new TransitionTest2()};
    static final String[] transitions = new String[]{"Fade", "Slide", "Cubic Rotation"};
    Shell sShell;
    Composite frameHolder;
    StackLayout frameHolderStackLayout;
    Composite currentSpecificOptionsComposite;
    Composite fadeOptionsComposite;
    Composite cubicRotationOptionsComposite;
    AbstractSTWDemoFrame currentDemo;
    Transition currentTransition;
    int currentDirection;
    int currentT;
    int currentFPS;
    int currentFOS;
    int currentFOP;
    int currentFIS;
    int currentFIP;
    int currentQuality;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        STWDemo thisClass = new STWDemo();
        thisClass.createSShell();
        thisClass.sShell.open();
        while (!thisClass.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void createSShell() {
        this.sShell = new Shell();
        this.sShell.setText("STW Demo");
        this.sShell.setSize(new Point(1000, 600));
        this.sShell.setLayout((Layout)new FillLayout());
        this.createMainComposite((Composite)this.sShell, 0);
    }

    private Composite createMainComposite(Composite parent, int style) {
        Composite mainComposite = new Composite(parent, style);
        mainComposite.setLayout((Layout)new FormLayout());
        this.frameHolder = new Composite(mainComposite, 2048);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(75, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.frameHolder.setLayoutData((Object)fd);
        this.frameHolderStackLayout = new StackLayout();
        this.frameHolder.setLayout((Layout)this.frameHolderStackLayout);
        this.sShell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                STWDemo.this.frameHolder.layout();
            }
        });
        AbstractSTWDemoFrame[] abstractSTWDemoFrameArray = this.demoFrames;
        int n = this.demoFrames.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSTWDemoFrame frame = abstractSTWDemoFrameArray[n2];
            frame.init(this.frameHolder);
            frame.getContainerComposiste().setVisible(false);
            ++n2;
        }
        Composite optionsComposite = new Composite(mainComposite, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.frameHolder, 5);
        fd.right = new FormAttachment(100, -5);
        fd.top = new FormAttachment(0, 5);
        fd.bottom = new FormAttachment(100, -5);
        optionsComposite.setLayoutData((Object)fd);
        optionsComposite.setLayout((Layout)new RowLayout(512));
        new Label(optionsComposite, 0x40000000).setText("Demo:");
        final Combo comboDemo = new Combo(optionsComposite, 12);
        comboDemo.setItems(demos);
        comboDemo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                STWDemo.this.selectDemo(comboDemo.getSelectionIndex());
            }
        });
        comboDemo.select(0);
        this.currentDemo = this.demoFrames[0];
        new Label(optionsComposite, 0x40000000).setText("Transition Effect:");
        final Combo comboTransition = new Combo(optionsComposite, 12);
        comboTransition.setItems(transitions);
        comboTransition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                STWDemo.this.selectTransition(comboTransition.getSelectionIndex());
            }
        });
        comboTransition.select(0);
        this.currentTransition = this.currentDemo.getTransitionEffect(0);
        this.currentDemo.getTransitionManager().setTransition(this.currentTransition);
        new Label(optionsComposite, 0x40000000).setText("Direction:");
        final Combo comboDirection = new Combo(optionsComposite, 12);
        comboDirection.setItems(AbstractSTWDemoFrame.DIRECTIONS_NAMES);
        comboDirection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                STWDemo.this.selectDirection(comboDirection.getSelectionIndex());
            }
        });
        comboDirection.select(0);
        this.currentDirection = 0;
        this.currentDemo.selectDirection(0);
        new Label(optionsComposite, 0x40000000).setText("Total Transition Time (ms):");
        final Spinner spnrT = new Spinner(optionsComposite, 0);
        spnrT.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                STWDemo.this.setT(spnrT.getSelection());
            }
        });
        spnrT.setMinimum(0);
        spnrT.setMaximum(Integer.MAX_VALUE);
        spnrT.setIncrement(1);
        spnrT.setPageIncrement(50);
        spnrT.setSelection(1000);
        this.setT(1000);
        new Label(optionsComposite, 0x40000000).setText("Frames Per Second (fps):");
        final Spinner spnrFPS = new Spinner(optionsComposite, 0);
        spnrFPS.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                STWDemo.this.setFPS(spnrFPS.getSelection());
            }
        });
        spnrFPS.setMinimum(1);
        spnrFPS.setMaximum(Integer.MAX_VALUE);
        spnrFPS.setIncrement(1);
        spnrFPS.setPageIncrement(10);
        spnrFPS.setSelection(60);
        this.setFPS(60);
        Composite specificOptionsComposite = new Composite(optionsComposite, 0);
        StackLayout specificOptionsStackLayout = new StackLayout();
        specificOptionsComposite.setLayout((Layout)specificOptionsStackLayout);
        this.fadeOptionsComposite = new Composite(specificOptionsComposite, 0);
        this.fadeOptionsComposite.setLayout((Layout)new RowLayout(512));
        new Label(this.fadeOptionsComposite, 0x40000000).setText("Fade Out Start (%):");
        final Spinner spnrFOS = new Spinner(this.fadeOptionsComposite, 0);
        spnrFOS.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                STWDemo.this.setFOS(spnrFOS.getSelection());
            }
        });
        spnrFOS.setMinimum(0);
        spnrFOS.setMaximum(100);
        spnrFOS.setIncrement(1);
        spnrFOS.setPageIncrement(10);
        spnrFOS.setSelection(0);
        this.setFOS(0);
        new Label(this.fadeOptionsComposite, 0x40000000).setText("Fade Out Stop (%):");
        final Spinner spnrFOP = new Spinner(this.fadeOptionsComposite, 0);
        spnrFOP.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                STWDemo.this.setFOP(spnrFOP.getSelection());
            }
        });
        spnrFOP.setMinimum(0);
        spnrFOP.setMaximum(100);
        spnrFOP.setIncrement(1);
        spnrFOP.setPageIncrement(10);
        spnrFOP.setSelection(100);
        this.setFOP(100);
        new Label(this.fadeOptionsComposite, 0x40000000).setText("Fade In Start (%):");
        final Spinner spnrFIS = new Spinner(this.fadeOptionsComposite, 0);
        spnrFIS.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                STWDemo.this.setFIS(spnrFIS.getSelection());
            }
        });
        spnrFIS.setMinimum(0);
        spnrFIS.setMaximum(100);
        spnrFIS.setIncrement(1);
        spnrFIS.setPageIncrement(10);
        spnrFIS.setSelection(0);
        this.setFIS(0);
        new Label(this.fadeOptionsComposite, 0x40000000).setText("Fade In Stop (%):");
        final Spinner spnrFIP = new Spinner(this.fadeOptionsComposite, 0);
        spnrFIP.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                STWDemo.this.setFIP(spnrFIP.getSelection());
            }
        });
        spnrFIP.setMinimum(0);
        spnrFIP.setMaximum(100);
        spnrFIP.setIncrement(1);
        spnrFIP.setPageIncrement(10);
        spnrFIP.setSelection(100);
        this.setFIP(100);
        this.cubicRotationOptionsComposite = new Composite(specificOptionsComposite, 0);
        this.cubicRotationOptionsComposite.setLayout((Layout)new RowLayout(512));
        new Label(this.cubicRotationOptionsComposite, 0x40000000).setText("Quality (%):");
        final Spinner spnrQuality = new Spinner(this.cubicRotationOptionsComposite, 0);
        spnrQuality.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                STWDemo.this.setQuality(spnrQuality.getSelection());
            }
        });
        spnrQuality.setMinimum(0);
        spnrQuality.setMaximum(100);
        spnrQuality.setIncrement(1);
        spnrQuality.setPageIncrement(10);
        spnrQuality.setSelection(100);
        this.setQuality(100);
        this.currentSpecificOptionsComposite = this.fadeOptionsComposite;
        specificOptionsStackLayout.topControl = this.currentSpecificOptionsComposite;
        this.selectDemo(0);
        return mainComposite;
    }

    private void selectDemo(int index) {
        if (this.currentDemo != null) {
            this.currentDemo.getContainerComposiste().setVisible(false);
        }
        this.currentDemo = this.demoFrames[index];
        this.currentDemo.getContainerComposiste().setVisible(true);
        this.frameHolderStackLayout.topControl = this.currentDemo.getContainerComposiste();
        this.currentDemo.getTransitionManager().setTransition(this.currentTransition);
        this.currentDemo.selectDirection(this.currentDirection);
        this.currentTransition.setTotalTransitionTime((long)this.currentT);
        this.currentTransition.setFPS((long)this.currentFPS);
    }

    private void selectTransition(int index) {
        this.currentTransition = this.currentDemo.getTransitionEffect(index);
        if (this.currentSpecificOptionsComposite != null) {
            this.currentSpecificOptionsComposite.setVisible(false);
        }
        if (this.currentTransition instanceof FadeTransition) {
            this.currentSpecificOptionsComposite = this.fadeOptionsComposite;
            this.currentSpecificOptionsComposite.setVisible(true);
        } else if (this.currentTransition instanceof CubicRotationTransition) {
            this.currentSpecificOptionsComposite = this.cubicRotationOptionsComposite;
            this.currentSpecificOptionsComposite.setVisible(true);
        } else {
            this.currentSpecificOptionsComposite = null;
        }
        this.currentDemo.getTransitionManager().setTransition(this.currentTransition);
        this.currentTransition.setTotalTransitionTime((long)this.currentT);
        this.currentTransition.setFPS((long)this.currentFPS);
    }

    private void selectDirection(int index) {
        this.currentDirection = index;
        this.currentDemo.selectDirection(this.currentDirection);
    }

    private void setT(int T) {
        this.currentT = T;
        this.currentTransition.setTotalTransitionTime((long)this.currentT);
    }

    private void setFPS(int fps) {
        this.currentFPS = fps;
        this.currentTransition.setFPS((long)this.currentFPS);
    }

    private void setFOS(int fos) {
        this.currentFOS = fos;
        if (this.currentTransition instanceof FadeTransition) {
            ((FadeTransition)this.currentTransition).setFadeOutStart((double)this.currentFOS);
        }
    }

    private void setFOP(int fop) {
        this.currentFOP = fop;
        if (this.currentTransition instanceof FadeTransition) {
            ((FadeTransition)this.currentTransition).setFadeOutStop((double)this.currentFOP);
        }
    }

    private void setFIS(int fis) {
        this.currentFIS = fis;
        if (this.currentTransition instanceof FadeTransition) {
            ((FadeTransition)this.currentTransition).setFadeInStart((double)this.currentFIS);
        }
    }

    private void setFIP(int fip) {
        this.currentFIP = fip;
        if (this.currentTransition instanceof FadeTransition) {
            ((FadeTransition)this.currentTransition).setFadeInStop((double)this.currentFIP);
        }
    }

    private void setQuality(int quality) {
        this.currentQuality = quality;
        if (this.currentTransition instanceof CubicRotationTransition) {
            ((CubicRotationTransition)this.currentTransition).setQuality((double)this.currentQuality);
        }
    }
}

