/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw.transitions;

import org.eclipse.nebula.effects.stw.Transition;
import org.eclipse.nebula.effects.stw.TransitionManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class CubicRotationTransition
extends Transition {
    private int _w;
    private int _halfW;
    private int _h;
    private int _halfH;
    private double _a1;
    private double _a2;
    private double _x;
    private double _y;
    private double _x0;
    private double _y0;
    private double _v0;
    private boolean _flag1;
    private ImageData _fromData;
    private long _halfT;
    private long _t1;
    private long _tSqrd;
    private double _dy1;
    private double _dx1;
    private double _dx2;
    private double _dy2;
    private double _x1;
    private double _y1;
    private double _x2;
    private double _y2;
    private double _destHeight;
    private double _destWidth;
    private double _destHeight0;
    private double _destWidth0;
    private double _destHeightV0;
    private double _destWidthV0;
    private double _ratio1;
    private double _ratio2;
    private double _remainedSize;
    private double _quality = 100.0;

    public CubicRotationTransition(TransitionManager transitionManager) {
        this(transitionManager, 60L, 1000L);
    }

    public CubicRotationTransition(TransitionManager transitionManager, long fps, long T) {
        super(transitionManager, fps, T);
    }

    @Override
    protected void initTransition(Image from, Image to, GC gc, double direction) {
        this._halfT = (long)((double)this._T / 2.0);
        this._fromData = from.getImageData();
        this._w = this._fromData.width;
        this._h = this._fromData.height;
        this._halfW = (int)((double)this._w / 2.0);
        this._halfH = (int)((double)this._h / 2.0);
        switch ((int)direction) {
            case 0: {
                this._a1 = (double)this._w / (double)(this._halfT * this._halfT);
                this._a2 = (double)this._h / (double)(this._halfT * this._halfT);
                this._x = 0.0;
                this._destHeight = 0.0;
                this._dx1 = this._dx2 = (double)this._w - this._quality * (double)(this._w - 1) / 100.0;
                this._remainedSize = (double)this._w - (double)((int)((double)this._w / this._dx1)) * this._dx1;
                break;
            }
            case 180: {
                this._a1 = (double)this._w / (double)(this._halfT * this._halfT);
                this._a2 = (double)this._h / (double)(this._halfT * this._halfT);
                this._x = this._w;
                this._destHeight = this._h;
                this._dx1 = this._dx2 = (double)this._w - this._quality * (double)(this._w - 1) / 100.0;
                this._remainedSize = (double)this._w - (double)((int)((double)this._w / this._dx1)) * this._dx1;
                break;
            }
            case 90: {
                this._a1 = (double)this._h / (double)(this._halfT * this._halfT);
                this._a2 = (double)this._w / (double)(this._halfT * this._halfT);
                this._y = this._h;
                this._destWidth = this._w;
                this._dy1 = this._dy2 = (double)this._h - this._quality * (double)(this._h - 1) / 100.0;
                this._remainedSize = (double)this._h - (double)((int)((double)this._h / this._dy1)) * this._dy1;
                break;
            }
            case 270: {
                this._a1 = (double)this._h / (double)(this._halfT * this._halfT);
                this._a2 = (double)this._w / (double)(this._halfT * this._halfT);
                this._y = 0.0;
                this._destWidth = 0.0;
                this._dy1 = this._dy2 = (double)this._h - this._quality * (double)(this._h - 1) / 100.0;
                this._remainedSize = (double)this._h - (double)((int)((double)this._h / this._dy1)) * this._dy1;
            }
        }
        this._flag1 = false;
    }

    @Override
    protected void stepTransition(long t, Image from, Image to, GC gc, double direction) {
        switch ((int)direction) {
            case 0: {
                this._ratio1 = ((double)this._w - this._x) / (double)this._w;
                this._ratio2 = this._x / (double)this._w;
                this._dy1 = this._dx1 * this._destHeight / (2.0 * (double)this._w);
                this._dy2 = this._dx2 * ((double)this._h - this._destHeight) / (2.0 * (double)this._w);
                this._x1 = 0.0;
                this._y1 = 0.0;
                this._x2 = 0.0;
                this._y2 = ((double)this._h - this._destHeight) / 2.0;
                while (this._x1 < (double)this._w) {
                    try {
                        this._x2 = this._x1;
                        gc.drawImage(from, (int)this._x1, 0, (int)this._dx1, this._h, (int)(this._x + this._x1 * this._ratio1), (int)this._y1, (int)this._dx1, (int)((double)this._h - this._y1 - this._y1));
                        gc.drawImage(to, (int)this._x2, 0, (int)this._dx2, this._h, (int)(this._x2 * this._ratio2), (int)this._y2, (int)this._dx2, (int)((double)this._h - this._y2 - this._y2));
                        this._y1 += this._dy1;
                        this._y2 -= this._dy2;
                    }
                    catch (Exception exception) {
                        gc.drawImage(from, (int)this._x1, 0, (int)this._remainedSize, this._h, (int)(this._x + this._x1 * this._ratio1), (int)this._y1, (int)this._remainedSize, (int)((double)this._h - this._y1 - this._y1));
                        gc.drawImage(to, (int)this._x2, 0, (int)this._remainedSize, this._h, (int)(this._x2 * this._ratio2), (int)this._y2, (int)this._remainedSize, (int)((double)this._h - this._y2 - this._y2));
                    }
                    this._x1 += this._dx1;
                }
                if (t <= this._halfT) {
                    this._tSqrd = t * t;
                    this._x = Math.min(0.5 * this._a1 * (double)this._tSqrd, (double)this._halfW);
                    this._destHeight = Math.min(0.5 * this._a2 * (double)this._tSqrd, (double)this._halfH);
                    break;
                }
                if (!this._flag1) {
                    this._x0 = this._x;
                    this._destHeight0 = this._destHeight;
                    this._v0 = this._a1 * (double)t;
                    this._destHeightV0 = this._a2 * (double)t;
                    this._a1 *= -1.0;
                    this._a2 *= -1.0;
                    this._flag1 = true;
                }
                this._t1 = t - this._halfT;
                this._tSqrd = this._t1 * this._t1;
                this._x = Math.min(this._x0 + this._v0 * (double)this._t1 + 0.5 * this._a1 * (double)this._tSqrd, (double)this._w);
                this._destHeight = Math.min(this._destHeight0 + this._destHeightV0 * (double)this._t1 + 0.5 * this._a2 * (double)this._tSqrd, (double)this._h);
                break;
            }
            case 180: {
                this._ratio1 = this._x / (double)this._w;
                this._ratio2 = ((double)this._w - this._x) / (double)this._w;
                this._dy1 = this._dx1 * ((double)this._h - this._destHeight) / (2.0 * (double)this._w);
                this._dy2 = this._dx2 * this._destHeight / (2.0 * (double)this._w);
                this._x1 = 0.0;
                this._y1 = ((double)this._h - this._destHeight) / 2.0;
                this._x2 = 0.0;
                this._y2 = 0.0;
                while (this._x1 < (double)this._w) {
                    try {
                        gc.drawImage(from, (int)this._x1, 0, (int)this._dx1, this._h, (int)(this._x1 * this._ratio1), (int)this._y1, (int)this._dx1, (int)((double)this._h - this._y1 - this._y1));
                        this._y1 -= this._dy1;
                    }
                    catch (Exception exception) {
                        gc.drawImage(from, (int)this._x1, 0, (int)this._remainedSize, this._h, (int)(this._x1 * this._ratio1), (int)this._y1, (int)this._remainedSize, (int)((double)this._h - this._y1 - this._y1));
                    }
                    this._x1 += this._dx1;
                }
                while (this._x2 < (double)this._w) {
                    try {
                        gc.drawImage(to, (int)this._x2, 0, (int)this._dx2, this._h, (int)(this._x + this._x2 * this._ratio2), (int)this._y2, (int)this._dx2, (int)((double)this._h - this._y2 - this._y2));
                        this._y2 += this._dy2;
                    }
                    catch (Exception exception) {
                        gc.drawImage(to, (int)this._x2, 0, (int)this._remainedSize, this._h, (int)(this._x + this._x2 * this._ratio2), (int)this._y2, (int)this._remainedSize, (int)((double)this._h - this._y2 - this._y2));
                    }
                    this._x2 += this._dx2;
                }
                if (t <= this._halfT) {
                    this._tSqrd = t * t;
                    this._x = (double)this._w - Math.min(0.5 * this._a1 * (double)this._tSqrd, (double)this._halfW);
                    this._destHeight = (double)this._h - Math.min(0.5 * this._a2 * (double)this._tSqrd, (double)this._halfH);
                    break;
                }
                if (!this._flag1) {
                    this._x0 = (double)this._w - this._x;
                    this._destHeight0 = (double)this._h - this._destHeight;
                    this._v0 = this._a1 * (double)t;
                    this._destHeightV0 = this._a2 * (double)t;
                    this._a1 *= -1.0;
                    this._a2 *= -1.0;
                    this._flag1 = true;
                }
                this._t1 = t - this._halfT;
                this._tSqrd = this._t1 * this._t1;
                this._x = (double)this._w - Math.min(this._x0 + this._v0 * (double)this._t1 + 0.5 * this._a1 * (double)this._tSqrd, (double)this._w);
                this._destHeight = (double)this._h - Math.min(this._destHeight0 + this._destHeightV0 * (double)this._t1 + 0.5 * this._a2 * (double)this._tSqrd, (double)this._h);
                break;
            }
            case 90: {
                this._ratio1 = this._y / (double)this._h;
                this._ratio2 = ((double)this._h - this._y) / (double)this._h;
                this._dx1 = this._dy1 * ((double)this._w - this._destWidth) / (2.0 * (double)this._h);
                this._dx2 = this._dy2 * this._destWidth / (2.0 * (double)this._h);
                this._y1 = 0.0;
                this._x1 = ((double)this._w - this._destWidth) / 2.0;
                this._y2 = 0.0;
                this._x2 = 0.0;
                while (this._y1 < (double)this._h) {
                    try {
                        gc.drawImage(from, 0, (int)this._y1, this._w, (int)this._dy1, (int)this._x1, (int)(this._y1 * this._ratio1), (int)((double)this._w - this._x1 - this._x1), (int)this._dy1);
                        this._x1 -= this._dx1;
                    }
                    catch (Exception exception) {
                        gc.drawImage(from, 0, (int)this._y1, this._w, (int)this._remainedSize, (int)this._x1, (int)(this._y1 * this._ratio1), (int)((double)this._w - this._x1 - this._x1), (int)this._remainedSize);
                    }
                    this._y1 += this._dy1;
                }
                while (this._y2 < (double)this._h) {
                    try {
                        gc.drawImage(to, 0, (int)this._y2, this._w, (int)this._dy2, (int)this._x2, (int)(this._y + this._y2 * this._ratio2), (int)((double)this._w - this._x2 - this._x2), (int)this._dy2);
                        this._x2 += this._dx2;
                    }
                    catch (Exception exception) {
                        gc.drawImage(to, 0, (int)this._y2, this._w, (int)this._remainedSize, (int)this._x2, (int)(this._y + this._y2 * this._ratio2), (int)((double)this._w - this._x2 - this._x2), (int)this._remainedSize);
                    }
                    this._y2 += this._dy2;
                }
                if (t <= this._halfT) {
                    this._tSqrd = t * t;
                    this._y = (double)this._h - Math.min(0.5 * this._a1 * (double)this._tSqrd, (double)this._halfH);
                    this._destWidth = (double)this._w - Math.min(0.5 * this._a2 * (double)this._tSqrd, (double)this._halfW);
                    break;
                }
                if (!this._flag1) {
                    this._y0 = (double)this._h - this._y;
                    this._destWidth0 = (double)this._w - this._destWidth;
                    this._v0 = this._a1 * (double)t;
                    this._destWidthV0 = this._a2 * (double)t;
                    this._a1 *= -1.0;
                    this._a2 *= -1.0;
                    this._flag1 = true;
                }
                this._t1 = t - this._halfT;
                this._tSqrd = this._t1 * this._t1;
                this._y = (double)this._h - Math.min(this._y0 + this._v0 * (double)this._t1 + 0.5 * this._a1 * (double)this._tSqrd, (double)this._h);
                this._destWidth = (double)this._w - Math.min(this._destWidth0 + this._destWidthV0 * (double)this._t1 + 0.5 * this._a2 * (double)this._tSqrd, (double)this._w);
                break;
            }
            case 270: {
                this._ratio1 = ((double)this._h - this._y) / (double)this._h;
                this._ratio2 = this._y / (double)this._h;
                this._dx1 = this._dy1 * this._destWidth / (2.0 * (double)this._h);
                this._dx2 = this._dy2 * ((double)this._w - this._destWidth) / (2.0 * (double)this._h);
                this._y1 = 0.0;
                this._x1 = 0.0;
                this._y2 = 0.0;
                this._x2 = ((double)this._w - this._destWidth) / 2.0;
                while (this._y1 < (double)this._h) {
                    try {
                        this._y2 = this._y1;
                        gc.drawImage(from, 0, (int)this._y1, this._w, (int)this._dy1, (int)this._x1, (int)(this._y + this._y1 * this._ratio1), (int)((double)this._w - this._x1 - this._x1), (int)this._dy1);
                        gc.drawImage(to, 0, (int)this._y2, this._w, (int)this._dy2, (int)this._x2, (int)(this._y2 * this._ratio2), (int)((double)this._w - this._x2 - this._x2), (int)this._dy2);
                        this._x1 += this._dx1;
                        this._x2 -= this._dx2;
                    }
                    catch (Exception exception) {
                        gc.drawImage(from, 0, (int)this._y1, this._w, (int)this._remainedSize, (int)this._x1, (int)(this._y + this._y1 * this._ratio1), (int)((double)this._w - this._x1 - this._x1), (int)this._remainedSize);
                        gc.drawImage(to, 0, (int)this._y2, this._w, (int)this._remainedSize, (int)this._x2, (int)(this._y2 * this._ratio2), (int)((double)this._w - this._x2 - this._x2), (int)this._remainedSize);
                    }
                    this._y1 += this._dy1;
                }
                if (t <= this._halfT) {
                    this._tSqrd = t * t;
                    this._y = Math.min(0.5 * this._a1 * (double)this._tSqrd, (double)this._halfH);
                    this._destWidth = Math.min(0.5 * this._a2 * (double)this._tSqrd, (double)this._halfW);
                    break;
                }
                if (!this._flag1) {
                    this._y0 = this._y;
                    this._destWidth0 = this._destWidth;
                    this._v0 = this._a1 * (double)t;
                    this._destWidthV0 = this._a2 * (double)t;
                    this._a1 *= -1.0;
                    this._a2 *= -1.0;
                    this._flag1 = true;
                }
                this._t1 = t - this._halfT;
                this._tSqrd = this._t1 * this._t1;
                this._y = Math.min(this._y0 + this._v0 * (double)this._t1 + 0.5 * this._a1 * (double)this._tSqrd, (double)this._h);
                this._destWidth = Math.min(this._destWidth0 + this._destWidthV0 * (double)this._t1 + 0.5 * this._a2 * (double)this._tSqrd, (double)this._w);
            }
        }
    }

    @Override
    protected void endTransition(Image from, Image to, GC gc, double direction) {
    }

    public void setQuality(double quality) {
        if (quality >= 0.0 && quality <= 100.0) {
            this._quality = quality;
        }
    }

    public double getQuality() {
        return this._quality;
    }
}

