/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.examples;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExamplesView
extends ViewPart {
    private TabFolder tabFolder;
    private static ImageRegistry imgRegistry = new ImageRegistry();
    private static FontRegistry fontRegistry = new FontRegistry();

    public void createPartControl(Composite parent) {
        this.tabFolder = new TabFolder(parent, 128);
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.nebula.examples.examples");
        HashMap<String, IConfigurationElement> elementsMap = new HashMap<String, IConfigurationElement>();
        int i = 0;
        while (i < elements.length) {
            elementsMap.put(elements[i].getAttribute("name"), elements[i]);
            ++i;
        }
        TreeMap sortedElements = new TreeMap(elementsMap);
        Iterator iter = sortedElements.entrySet().iterator();
        while (iter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)iter.next().getValue();
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(element.getAttribute("name"));
            try {
                AbstractExampleTab part = (AbstractExampleTab)element.createExecutableExtension("class");
                Composite client = new Composite((Composite)this.tabFolder, 0);
                part.create(client);
                item.setControl((Control)client);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (this.tabFolder.getItems().length > 0) {
            this.tabFolder.setSelection(this.tabFolder.getItem(0));
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.nebula.examples", (String)path);
    }

    public static Image getImage(String path) {
        Image i = imgRegistry.get(path);
        if (i == null) {
            ImageDescriptor id = ExamplesView.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            i = id.createImage();
            imgRegistry.put(path, i);
        }
        return i;
    }

    public static Font getFont(String fontLookupKey) {
        return fontRegistry.get(fontLookupKey);
    }

    public static void setFont(String fontLookupKey, FontData[] fontData) {
        fontRegistry.put(fontLookupKey, fontData);
    }
}

