/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.cdatetime;

import java.util.Date;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class CDateTimeObservableValue
extends AbstractObservableValue {
    protected final CDateTime dateTime;
    protected boolean updating = false;
    protected Date currentSelection;
    private SelectionListener listener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            if (!CDateTimeObservableValue.this.updating) {
                Date newSelection = CDateTimeObservableValue.this.dateTime.getSelection();
                CDateTimeObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)CDateTimeObservableValue.this.currentSelection, (Object)newSelection));
                CDateTimeObservableValue.this.currentSelection = newSelection;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (!CDateTimeObservableValue.this.updating) {
                Date newSelection = CDateTimeObservableValue.this.dateTime.getSelection();
                CDateTimeObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)CDateTimeObservableValue.this.currentSelection, (Object)newSelection));
                CDateTimeObservableValue.this.currentSelection = newSelection;
            }
        }
    };

    public CDateTimeObservableValue(CDateTime dateTime) {
        this.dateTime = dateTime;
        this.currentSelection = dateTime.getSelection();
        this.dateTime.addSelectionListener(this.listener);
    }

    public synchronized void dispose() {
        this.dateTime.removeSelectionListener(this.listener);
        super.dispose();
    }

    protected Object doGetValue() {
        if (!this.dateTime.isDisposed()) {
            return this.dateTime.getSelection();
        }
        return null;
    }

    protected void doSetValue(Object value) {
        if ((value instanceof Date || value == null) && !this.dateTime.isDisposed()) {
            try {
                this.updating = true;
                Date oldValue = this.dateTime.getSelection();
                Date newValue = (Date)value;
                this.dateTime.setSelection(newValue);
                this.currentSelection = newValue;
                this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
            }
            finally {
                this.updating = false;
            }
        }
    }

    public Object getValueType() {
        return Date.class;
    }
}

