/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import java.util.ArrayList;
import org.eclipse.nebula.paperclips.core.Margins;
import org.eclipse.nebula.paperclips.core.NullPrintPiece;
import org.eclipse.nebula.paperclips.core.PageEnumeration;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.PaperClipsUtil;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class PaperClips {
    static boolean debug = false;
    public static final int ORIENTATION_DEFAULT = -1;
    public static final int ORIENTATION_PORTRAIT = 512;
    public static final int ORIENTATION_LANDSCAPE = 256;

    private PaperClips() {
    }

    public static void error(int code) {
        SWT.error((int)code, null);
    }

    public static void error(String detail) {
        SWT.error((int)1, null, (String)detail);
    }

    public static void error(int code, String detail) {
        SWT.error((int)code, null, (String)detail);
    }

    public static void setDebug(boolean debug) {
        PaperClips.debug = debug;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static PrinterData getDefaultPrinterData() {
        PrinterData[] list;
        PrinterData printerData = Printer.getDefaultPrinterData();
        if (printerData == null && (list = Printer.getPrinterList()).length > 0) {
            printerData = list[0];
        }
        return printerData;
    }

    public static PrintPiece next(PrintIterator iterator, int width, int height) {
        PrintPiece result;
        Util.notNull(iterator);
        if (width < 0 || height < 0) {
            PaperClips.error(5, "PrintPiece size " + width + "x" + height + " not possible");
        }
        if (!iterator.hasNext()) {
            PaperClips.error("Iterator " + iterator + " has no more content.");
        }
        if ((result = iterator.next(width, height)) != null) {
            Point size = result.getSize();
            if (size.x > width || size.y > height) {
                PaperClips.error("Iterator " + iterator + " produced a " + size.x + "x" + size.y + " piece for a " + width + "x" + height + " area.");
            }
        } else if (debug) {
            return new NullPrintPiece();
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void print(PrintJob printJob, PrinterData printerData) {
        Printer printer = new Printer(printerData);
        try {
            PaperClips.print(printJob, printer);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            printer.dispose();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        printer.dispose();
    }

    /*
     * Exception decompiling
     */
    public static void print(PrintJob printJob, Printer printer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 40->43)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void startJob(Printer printer, String jobName) {
        if (!printer.startJob(jobName)) {
            PaperClips.error("Unable to start print job");
        }
    }

    private static void cancelJob(Printer printer) {
        if (PaperClips.isGTK()) {
            printer.endJob();
        } else {
            printer.cancelJob();
        }
    }

    private static GC createAndConfigureGC(Printer printer) {
        GC gc = new GC((Drawable)printer);
        gc.setAdvanced(true);
        return gc;
    }

    private static void print(PrintJob printJob, Printer printer, GC gc) {
        int noncollatedCopies;
        int collatedCopies;
        PrinterData printerData = printer.getPrinterData();
        PrintPiece[] pages = PaperClips.getPages(printJob, printer, gc);
        int startPage = 0;
        int endPage = pages.length - 1;
        if (printerData.scope == 1) {
            startPage = Math.max(startPage, printerData.startPage - 1);
            endPage = Math.min(endPage, printerData.endPage - 1);
        }
        if (printerData.collate) {
            collatedCopies = printerData.copyCount;
            noncollatedCopies = 1;
        } else {
            noncollatedCopies = printerData.copyCount;
            collatedCopies = 1;
        }
        PaperClips.printPages(printer, gc, pages, startPage, endPage, collatedCopies, noncollatedCopies);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void printPages(Printer printer, GC gc, PrintPiece[] pages, int startPage, int endPage, int collatedCopies, int noncollatedCopies) {
        PaperClips.disposeUnusedPages(pages, startPage, endPage);
        Rectangle paperBounds = PaperClips.getPaperBounds(printer);
        int x = paperBounds.x;
        int y = paperBounds.y;
        try {
            int collated = 0;
            block3: while (collated < collatedCopies) {
                int pageIndex = startPage;
                block4: while (true) {
                    if (pageIndex > endPage) {
                        ++collated;
                        continue block3;
                    }
                    int noncollated = 0;
                    while (true) {
                        if (noncollated >= noncollatedCopies) {
                            ++pageIndex;
                            continue block4;
                        }
                        if (printer.startPage()) {
                            pages[pageIndex].paint(gc, x, y);
                            pages[pageIndex].dispose();
                            printer.endPage();
                        } else {
                            PaperClips.error("Unable to start page " + pageIndex);
                        }
                        ++noncollated;
                    }
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            PaperClipsUtil.dispose(pages);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        PaperClipsUtil.dispose(pages);
    }

    private static void disposeUnusedPages(PrintPiece[] pages, int startPage, int endPage) {
        PaperClipsUtil.dispose(pages, 0, startPage);
        PaperClipsUtil.dispose(pages, endPage + 1, pages.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrintPiece[] getPages(PrintJob printJob, Printer printer) {
        PrintPiece[] printPieceArray;
        PaperClips.startDummyJob(printer, printJob.getName());
        try {
            GC gc = PaperClips.createAndConfigureGC(printer);
            try {
                printPieceArray = PaperClips.getPages(printJob, printer, gc);
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                gc.dispose();
                throw throwable;
            }
            gc.dispose();
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            PaperClips.endDummyJob(printer);
            throw throwable;
        }
        PaperClips.endDummyJob(printer);
        return printPieceArray;
    }

    public static void startDummyJob(Printer printer, String name) {
        if (PaperClips.isCarbon() || PaperClips.isGTK()) {
            PaperClips.startJob(printer, name);
        }
    }

    public static void endDummyJob(Printer printer) {
        if (PaperClips.isGTK()) {
            printer.endJob();
        } else if (PaperClips.isCarbon()) {
            if (SWT.getVersion() < 3346) {
                printer.endJob();
            } else {
                printer.cancelJob();
            }
        }
    }

    private static boolean isCarbon() {
        return SWT.getPlatform().equals("carbon");
    }

    private static boolean isGTK() {
        return SWT.getPlatform().equals("gtk");
    }

    private static PrintPiece[] getPages(PrintJob printJob, Printer printer, GC gc) {
        PageEnumeration enumeration = new PageEnumeration(printJob, printer, gc);
        ArrayList<PrintPiece> pages = new ArrayList<PrintPiece>();
        while (enumeration.hasNext()) {
            PrintPiece page = enumeration.nextPage();
            if (page == null) {
                int pageNumber = pages.size() + 1;
                PaperClipsUtil.dispose(pages);
                PaperClips.error("Unable to layout page " + pageNumber);
            }
            pages.add(page);
        }
        return pages.toArray(new PrintPiece[pages.size()]);
    }

    public static PageEnumeration getPageEnumeration(PrintJob printJob, Printer printer, GC gc) {
        return new PageEnumeration(printJob, printer, gc);
    }

    public static Rectangle getPaperBounds(Printer printer) {
        Rectangle rect = PaperClips.getPrintableBounds(printer);
        return printer.computeTrim(rect.x, rect.y, rect.width, rect.height);
    }

    public static Rectangle getPrintableBounds(Printer printer) {
        return printer.getClientArea();
    }

    public static Rectangle getMarginBounds(Margins margins, Printer printer) {
        Rectangle paperBounds = PaperClips.getPaperBounds(printer);
        Point dpi = printer.getDPI();
        int top = paperBounds.y + margins.top * dpi.y / 72;
        int left = paperBounds.x + margins.left * dpi.x / 72;
        int right = paperBounds.x + paperBounds.width - margins.right * dpi.x / 72;
        int bottom = paperBounds.y + paperBounds.height - margins.bottom * dpi.y / 72;
        Rectangle printableBounds = PaperClips.getPrintableBounds(printer);
        if (top < printableBounds.y) {
            top = printableBounds.y;
        }
        if (left < printableBounds.x) {
            left = printableBounds.x;
        }
        if (right > printableBounds.x + printableBounds.width) {
            right = printableBounds.x + printableBounds.width;
        }
        if (bottom > printableBounds.y + printableBounds.height) {
            bottom = printableBounds.y + printableBounds.height;
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }
}

