/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.grid.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.paperclips.core.CompositeEntry;
import org.eclipse.nebula.paperclips.core.CompositePiece;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.grid.GridCell;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLookPainter;
import org.eclipse.nebula.paperclips.core.grid.GridMargins;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.grid.internal.GridCellImpl;
import org.eclipse.nebula.paperclips.core.grid.internal.GridCellIterator;
import org.eclipse.nebula.paperclips.core.grid.internal.GridLookPainterPiece;
import org.eclipse.nebula.paperclips.core.internal.util.PaperClipsUtil;
import org.eclipse.nebula.paperclips.core.internal.util.PrintSizeStrategy;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class GridIterator
implements PrintIterator {
    final Device device;
    final Point dpi;
    final GridColumn[] columns;
    final int[][] columnGroups;
    final GridLookPainter look;
    final GridCellIterator[][] header;
    final GridCellIterator[][] body;
    final GridCellIterator[][] footer;
    final boolean cellClippingEnabled;
    final int[] minimumColSizes;
    final int[] preferredColSizes;
    final Point minimumSize;
    final Point preferredSize;
    private int row;
    private boolean rowStarted;

    public GridIterator(GridPrint grid, Device device, GC gc) {
        this.device = device;
        this.dpi = device.getDPI();
        this.columns = new GridColumn[grid.getColumns().length];
        System.arraycopy(grid.getColumns(), 0, this.columns, 0, grid.getColumns().length);
        this.columnGroups = grid.getColumnGroups();
        this.header = GridIterator.createGridCellIterators(grid.getHeaderCells(), device, gc);
        this.body = GridIterator.createGridCellIterators(grid.getBodyCells(), device, gc);
        this.footer = GridIterator.createGridCellIterators(grid.getFooterCells(), device, gc);
        this.cellClippingEnabled = grid.isCellClippingEnabled();
        this.look = grid.getLook().getPainter(device, gc);
        this.minimumColSizes = this.computeColumnSizes(PrintSizeStrategy.MINIMUM);
        this.preferredColSizes = this.computeColumnSizes(PrintSizeStrategy.PREFERRED);
        this.minimumSize = this.computeSize(PrintSizeStrategy.MINIMUM, this.minimumColSizes);
        this.preferredSize = this.computeSize(PrintSizeStrategy.PREFERRED, this.preferredColSizes);
        this.row = 0;
        this.rowStarted = false;
    }

    private static GridCellIterator[][] createGridCellIterators(GridCell[][] gridCells, Device device, GC gc) {
        GridCellIterator[][] result = new GridCellIterator[gridCells.length][];
        int rowIndex = 0;
        while (rowIndex < result.length) {
            result[rowIndex] = GridIterator.createRowCellIterators(gridCells[rowIndex], device, gc);
            ++rowIndex;
        }
        return result;
    }

    private static GridCellIterator[] createRowCellIterators(GridCell[] rowCells, Device device, GC gc) {
        GridCellIterator[] result = new GridCellIterator[rowCells.length];
        int cellIndex = 0;
        while (cellIndex < rowCells.length) {
            result[cellIndex] = ((GridCellImpl)rowCells[cellIndex]).iterator(device, gc);
            ++cellIndex;
        }
        return result;
    }

    private GridIterator(GridIterator that) {
        this.device = that.device;
        this.dpi = that.dpi;
        this.columns = that.columns;
        this.columnGroups = that.columnGroups;
        this.header = that.header;
        this.body = GridIterator.cloneRows(that.body, that.row);
        this.footer = that.footer;
        this.cellClippingEnabled = that.cellClippingEnabled;
        this.look = that.look;
        this.minimumColSizes = that.minimumColSizes;
        this.preferredColSizes = that.preferredColSizes;
        this.minimumSize = that.minimumSize;
        this.preferredSize = that.preferredSize;
        this.row = that.row;
        this.rowStarted = that.rowStarted;
    }

    private static GridCellIterator[][] cloneRows(GridCellIterator[][] rows, int firstRow) {
        GridCellIterator[][] result = (GridCellIterator[][])rows.clone();
        return result;
    }

    private int computeCellWidth(GridCellIterator entry, GridColumn col, PrintSizeStrategy strategy) {
        if (col.size == -1) {
            return strategy.computeSize((PrintIterator)entry.getTarget()).x;
        }
        if (col.size == 0) {
            return entry.getTarget().preferredSize().x;
        }
        return Math.round((float)(col.size * this.device.getDPI().x) / 72.0f);
    }

    private static boolean isExplicitSize(GridColumn col) {
        return col.size > 0;
    }

    private void applyColumnGrouping(int[] columnSizes) {
        int groupIndex = 0;
        while (groupIndex < this.columnGroups.length) {
            int col;
            int[] group = this.columnGroups[groupIndex];
            int maxSize = 0;
            int columnInGroupIndex = 0;
            while (columnInGroupIndex < group.length) {
                col = group[columnInGroupIndex];
                maxSize = Math.max(maxSize, columnSizes[col]);
                ++columnInGroupIndex;
            }
            columnInGroupIndex = 0;
            while (columnInGroupIndex < group.length) {
                col = group[columnInGroupIndex];
                columnSizes[col] = maxSize;
                ++columnInGroupIndex;
            }
            ++groupIndex;
        }
    }

    private boolean isColumnGrouped(int col) {
        int groupIndex = 0;
        while (groupIndex < this.columnGroups.length) {
            int[] group = this.columnGroups[groupIndex];
            int columnInGroupIndex = 0;
            while (columnInGroupIndex < group.length) {
                int groupedColumn = group[columnInGroupIndex];
                if (groupedColumn == col) {
                    return true;
                }
                ++columnInGroupIndex;
            }
            ++groupIndex;
        }
        return false;
    }

    private int[] computeColumnSizes(PrintSizeStrategy strategy) {
        int[] result = new int[this.columns.length];
        GridCellIterator[][] rows = this.aggregateHeaderBodyAndFooterCells();
        this.calculateExplicitlySizedColumnWidths(result);
        this.calculateColumnWidthsForCellsSpanningOneColumn(result, rows, strategy);
        this.applyColumnGrouping(result);
        this.calculateColumnWidthsForCellsSpanningMultipleColumns(result, rows, strategy);
        this.applyColumnGrouping(result);
        return result;
    }

    private GridCellIterator[][] aggregateHeaderBodyAndFooterCells() {
        GridCellIterator[][] rows = new GridCellIterator[this.body.length + this.header.length + this.footer.length][];
        int offset = 0;
        System.arraycopy(this.body, 0, rows, offset, this.body.length);
        System.arraycopy(this.header, 0, rows, offset += this.body.length, this.header.length);
        System.arraycopy(this.footer, 0, rows, offset += this.header.length, this.footer.length);
        return rows;
    }

    private void calculateColumnWidthsForCellsSpanningMultipleColumns(int[] colSizes, GridCellIterator[][] rows, PrintSizeStrategy strategy) {
        int horizontalSpacing = this.look.getMargins().getHorizontalSpacing();
        int rowIndex = 0;
        while (rowIndex < rows.length) {
            GridCellIterator[] row = rows[rowIndex];
            int columnIndex = 0;
            int cellIndex = 0;
            while (cellIndex < row.length) {
                int minimumWidth;
                int currentWidth;
                GridCellIterator entry = row[cellIndex];
                int colspan = entry.getColspan();
                if (colspan > 1 && (currentWidth = PaperClipsUtil.sum(colSizes, columnIndex, colspan)) < (minimumWidth = strategy.computeSize((PrintIterator)entry.getTarget()).x - horizontalSpacing * (colspan - 1))) {
                    int extraWidth = minimumWidth - currentWidth;
                    int[] indices = this.getExpandableColumnIndices(columnIndex, colspan);
                    int totalWidth = PaperClipsUtil.sumByIndex(colSizes, indices);
                    if (totalWidth == 0) {
                        this.resizeColumnsEqually(colSizes, extraWidth, indices);
                    } else {
                        this.resizeColumnsProportionateToCurrentSizes(colSizes, indices, extraWidth, totalWidth);
                    }
                }
                columnIndex += colspan;
                ++cellIndex;
            }
            ++rowIndex;
        }
    }

    private void resizeColumnsProportionateToCurrentSizes(int[] colSizes, int[] columnIndices, int adjustment, int totalWidth) {
        int i = 0;
        while (i < columnIndices.length && totalWidth != 0 && adjustment != 0) {
            int columnIndex = columnIndices[i];
            int addedWidth = (int)((long)adjustment * (long)colSizes[columnIndex] / (long)totalWidth);
            totalWidth -= colSizes[columnIndex];
            adjustment -= addedWidth;
            int n = columnIndex;
            colSizes[n] = colSizes[n] + addedWidth;
            ++i;
        }
    }

    private void resizeColumnsEqually(int[] colSizes, int adjustment, int[] expandableColumns) {
        int expandableCols = expandableColumns.length;
        int expandableColIndex = 0;
        while (expandableColIndex < expandableCols) {
            int addedWidth;
            int expandableColumn = expandableColumns[expandableColIndex];
            colSizes[expandableColumn] = addedWidth = adjustment / expandableCols;
            adjustment -= addedWidth;
            --expandableCols;
            ++expandableColIndex;
        }
    }

    private void calculateColumnWidthsForCellsSpanningOneColumn(int[] colSizes, GridCellIterator[][] rows, PrintSizeStrategy strategy) {
        int rowIndex = 0;
        while (rowIndex < rows.length) {
            GridCellIterator[] row = rows[rowIndex];
            int col = 0;
            int cellIndex = 0;
            while (cellIndex < row.length) {
                GridCellIterator entry = row[cellIndex];
                if (entry.getColspan() == 1 && !GridIterator.isExplicitSize(this.columns[col])) {
                    colSizes[col] = Math.max(colSizes[col], this.computeCellWidth(entry, this.columns[col], strategy));
                }
                col += entry.getColspan();
                ++cellIndex;
            }
            ++rowIndex;
        }
    }

    private void calculateExplicitlySizedColumnWidths(int[] colSizes) {
        int col = 0;
        while (col < this.columns.length) {
            if (GridIterator.isExplicitSize(this.columns[col])) {
                colSizes[col] = Math.round((float)(this.columns[col].size * this.dpi.x) / 72.0f);
            }
            ++col;
        }
    }

    private int[] getExpandableColumnIndices(int firstColumn, int colspan) {
        Condition[] conditions = this.getExpandableColumnConditions();
        int i = 0;
        while (i < conditions.length) {
            int[] columns = this.findColumns(firstColumn, colspan, conditions[i]);
            if (columns != null && columns.length > 0) {
                return columns;
            }
            ++i;
        }
        return new int[0];
    }

    private Condition[] getExpandableColumnConditions() {
        return new Condition[]{new Condition(){

            public boolean satisfiedBy(int col) {
                return !GridIterator.this.isColumnGrouped(col) && GridIterator.this.columns[col].weight > 0;
            }
        }, new Condition(){

            public boolean satisfiedBy(int col) {
                return GridIterator.this.isColumnGrouped(col) && GridIterator.this.columns[col].weight > 0;
            }
        }, new Condition(){

            public boolean satisfiedBy(int col) {
                return !GridIterator.this.isColumnGrouped(col) && GridIterator.this.columns[col].size == 0;
            }
        }, new Condition(){

            public boolean satisfiedBy(int col) {
                return GridIterator.this.isColumnGrouped(col) && GridIterator.this.columns[col].size == 0;
            }
        }, new Condition(){

            public boolean satisfiedBy(int col) {
                return !GridIterator.this.isColumnGrouped(col) && GridIterator.this.columns[col].size == -1;
            }
        }, new Condition(){

            public boolean satisfiedBy(int col) {
                return GridIterator.this.isColumnGrouped(col) && GridIterator.this.columns[col].size == -1;
            }
        }};
    }

    private int[] findColumns(Condition condition) {
        return this.findColumns(0, this.columns.length, condition);
    }

    private int[] findColumns(int start, int count, Condition condition) {
        int[] resultTemp = null;
        int matches = 0;
        int end = start + count;
        int index = start;
        while (index < end) {
            if (condition.satisfiedBy(index)) {
                if (resultTemp == null) {
                    resultTemp = new int[count];
                }
                resultTemp[matches++] = index;
            }
            ++index;
        }
        if (matches == 0) {
            return new int[0];
        }
        int[] result = new int[matches];
        System.arraycopy(resultTemp, 0, result, 0, matches);
        return result;
    }

    private Point computeSize(PrintSizeStrategy strategy, int[] colSizes) {
        GridMargins margins = this.look.getMargins();
        int width = this.computeMarginWidth() + PaperClipsUtil.sum(colSizes);
        int height = 0;
        height = this.header.length > 0 ? (height += this.computeHeaderHeight(margins, strategy)) : (height += Math.max(margins.getBodyTop(false, true), margins.getBodyTop(false, false)));
        height += this.computeMaxBodyRowHeight(strategy);
        height = this.footer.length > 0 ? (height += this.computeFooterHeight(strategy, margins)) : (height += Math.max(margins.getBodyBottom(false, false), margins.getBodyBottom(false, true)));
        return new Point(width, height);
    }

    private int computeHeaderHeight(GridMargins margins, PrintSizeStrategy strategy) {
        int headerHeight = margins.getHeaderTop() + margins.getHeaderVerticalSpacing() * (this.header.length - 1) + Math.max(margins.getBodyTop(true, true), margins.getBodyTop(true, false));
        int rowIndex = 0;
        while (rowIndex < this.header.length) {
            GridCellIterator[] row = this.header[rowIndex];
            int rowHeight = 0;
            int cellIndex = 0;
            while (cellIndex < row.length) {
                GridCellIterator entry = row[cellIndex];
                rowHeight = Math.max(rowHeight, strategy.computeSize((PrintIterator)entry.getTarget()).y);
                entry.getColspan();
                ++cellIndex;
            }
            headerHeight += rowHeight;
            ++rowIndex;
        }
        return headerHeight;
    }

    private int computeMaxBodyRowHeight(PrintSizeStrategy strategy) {
        int maxBodyRowHeight = 0;
        int rowIndex = 0;
        while (rowIndex < this.body.length) {
            GridCellIterator[] row = this.body[rowIndex];
            int cellIndex = 0;
            while (cellIndex < row.length) {
                GridCellIterator entry = row[cellIndex];
                maxBodyRowHeight = Math.max(maxBodyRowHeight, strategy.computeSize((PrintIterator)entry.getTarget()).y);
                entry.getColspan();
                ++cellIndex;
            }
            ++rowIndex;
        }
        return maxBodyRowHeight;
    }

    private int computeFooterHeight(PrintSizeStrategy strategy, GridMargins margins) {
        int footerHeight = Math.max(margins.getBodyBottom(true, false), margins.getBodyBottom(true, true)) + margins.getFooterVerticalSpacing() * (this.footer.length - 1) + margins.getFooterBottom();
        int rowIndex = 0;
        while (rowIndex < this.footer.length) {
            GridCellIterator[] row = this.footer[rowIndex];
            int rowHeight = 0;
            int cellIndex = 0;
            while (cellIndex < row.length) {
                GridCellIterator entry = row[cellIndex];
                rowHeight = Math.max(rowHeight, strategy.computeSize((PrintIterator)entry.getTarget()).y);
                entry.getColspan();
                ++cellIndex;
            }
            footerHeight += rowHeight;
            ++rowIndex;
        }
        return footerHeight;
    }

    public Point minimumSize() {
        return new Point(this.minimumSize.x, this.minimumSize.y);
    }

    public Point preferredSize() {
        return new Point(this.preferredSize.x, this.preferredSize.y);
    }

    private Condition[] getShrinkableColumnConditions() {
        return new Condition[]{new Condition(){

            public boolean satisfiedBy(int col) {
                int size = GridIterator.this.columns[col].size;
                return size == -1 || size == 0;
            }
        }};
    }

    private int[] findShrinkableColumns(int extraWidth) {
        Condition[] conditions = this.getShrinkableColumnConditions();
        int i = 0;
        while (i < conditions.length) {
            int[] indices = this.findColumns(conditions[i]);
            if (PaperClipsUtil.sumByIndex(this.minimumColSizes, indices) >= extraWidth) {
                return indices;
            }
            ++i;
        }
        return this.findAllColumns();
    }

    private int[] findAllColumns() {
        int[] result = new int[this.columns.length];
        int i = 0;
        while (i < result.length) {
            result[i] = i;
            ++i;
        }
        return result;
    }

    private int[] computeColumnWidths(int width) {
        int minimumWidth = PaperClipsUtil.sum(this.minimumColSizes);
        int preferredWidth = PaperClipsUtil.sum(this.preferredColSizes);
        if (width < minimumWidth) {
            return this.reduceMinimumColumnWidths(minimumWidth - width);
        }
        if (width == minimumWidth) {
            return this.minimumColSizes;
        }
        if (width < preferredWidth) {
            return this.expandMinimumColumnWidths(width - minimumWidth);
        }
        if (preferredWidth == width) {
            return this.preferredColSizes;
        }
        return this.expandPreferredColumnWidthsByWeight(width - preferredWidth);
    }

    private int[] expandPreferredColumnWidthsByWeight(int extraWidth) {
        int[] weightedCols = this.findColumns(new Condition(){

            public boolean satisfiedBy(int col) {
                return GridIterator.this.columns[col].weight > 0;
            }
        });
        int totalWeight = 0;
        int i = 0;
        while (i < weightedCols.length) {
            totalWeight += this.columns[weightedCols[i]].weight;
            ++i;
        }
        int[] colSizes = PaperClipsUtil.copy(this.preferredColSizes);
        int weightedColIndex = 0;
        while (weightedColIndex < weightedCols.length) {
            int columnIndex = weightedCols[weightedColIndex];
            int columnWeight = this.columns[columnIndex].weight;
            int addWidth = (int)((long)extraWidth * (long)columnWeight / (long)totalWeight);
            int n = columnIndex;
            colSizes[n] = colSizes[n] + addWidth;
            extraWidth -= addWidth;
            totalWeight -= columnWeight;
            ++weightedColIndex;
        }
        return colSizes;
    }

    private int[] expandMinimumColumnWidths(int expansion) {
        int difference = PaperClipsUtil.sum(this.preferredColSizes) - PaperClipsUtil.sum(this.minimumColSizes);
        int[] colSizes = PaperClipsUtil.copy(this.minimumColSizes);
        int i = 0;
        while (i < this.columns.length && difference != 0 && expansion != 0) {
            int columnDifference = this.preferredColSizes[i] - this.minimumColSizes[i];
            int change = (int)((long)expansion * (long)columnDifference / (long)difference);
            int n = i++;
            colSizes[n] = colSizes[n] + change;
            expansion -= change;
            difference -= columnDifference;
        }
        return colSizes;
    }

    private int computeMarginWidth() {
        GridMargins margins = this.look.getMargins();
        return margins.getLeft() + margins.getRight() + margins.getHorizontalSpacing() * (this.columns.length - 1);
    }

    private int[] reduceMinimumColumnWidths(int reduction) {
        int[] colSizes = PaperClipsUtil.copy(this.minimumColSizes);
        int[] shrinkableCols = this.findShrinkableColumns(reduction);
        int shrinkableWidth = PaperClipsUtil.sumByIndex(colSizes, shrinkableCols);
        int i = 0;
        while (i < shrinkableCols.length && shrinkableWidth != 0 && reduction != 0) {
            int col = shrinkableCols[i];
            int columnReduction = (int)((long)colSizes[col] * (long)reduction / (long)shrinkableWidth);
            shrinkableWidth -= colSizes[col];
            int n = col;
            colSizes[n] = colSizes[n] - columnReduction;
            reduction -= columnReduction;
            ++i;
        }
        return colSizes;
    }

    public boolean hasNext() {
        return this.row < this.body.length;
    }

    private PrintPiece nextRow(GridCellIterator[] cells, int[] columnWidths, int height, boolean bottomOpen) {
        if (bottomOpen && GridIterator.rowContainsNonDefaultVertAlignment(cells)) {
            return null;
        }
        if (height < 0) {
            return null;
        }
        int[] cellWidths = this.calculateCellWidths(cells, columnWidths);
        PrintPiece[] pieces = GridIterator.layoutCellsWithNonFillVertAlignment(cells, height, bottomOpen, cellWidths);
        if (pieces == null) {
            return null;
        }
        int rowHeight = GridIterator.calculateRowHeight(pieces, cells);
        if ((pieces = GridIterator.layoutCellsWithFillVertAlignment(cells, rowHeight, cellWidths, pieces)) == null) {
            return null;
        }
        int[] xOffsets = new int[cells.length];
        int[] yOffsets = new int[cells.length];
        this.applyCellAlignment(cells, cellWidths, pieces, rowHeight, xOffsets, yOffsets);
        return GridIterator.createRowResult(pieces, xOffsets, yOffsets);
    }

    private static boolean rowContainsNonDefaultVertAlignment(GridCellIterator[] cells) {
        int i = 0;
        while (i < cells.length) {
            if (!GridIterator.isDefaultVerticalAlignment(cells[i].getVerticalAlignment())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDefaultVerticalAlignment(int vAlignment) {
        return vAlignment == -1 || vAlignment == 128;
    }

    private int[] calculateCellWidths(GridCellIterator[] cells, int[] columnWidths) {
        int[] result = new int[cells.length];
        int horzSpacing = this.look.getMargins().getHorizontalSpacing();
        int col = 0;
        int cellIndex = 0;
        while (cellIndex < cells.length) {
            int colspan = cells[cellIndex].getColspan();
            result[cellIndex] = (colspan - 1) * horzSpacing + PaperClipsUtil.sum(columnWidths, col, colspan);
            col += colspan;
            ++cellIndex;
        }
        return result;
    }

    private static PrintPiece[] layoutCellsWithNonFillVertAlignment(GridCellIterator[] cells, int height, boolean bottomOpen, int[] cellWidths) {
        PrintPiece[] pieces = new PrintPiece[cells.length];
        int cellIndex = 0;
        while (cellIndex < cells.length) {
            PrintPiece piece;
            GridCellIterator cell = cells[cellIndex];
            PrintIterator iter = cell.getTarget();
            int cellWidth = cellWidths[cellIndex];
            if (iter.hasNext() && cell.getVerticalAlignment() != 4 && ((piece = (pieces[cellIndex] = PaperClips.next(iter, cellWidth, height))) == null || iter.hasNext() && !bottomOpen)) {
                PaperClipsUtil.dispose(piece, pieces);
                return null;
            }
            ++cellIndex;
        }
        return pieces;
    }

    private static int calculateRowHeight(PrintPiece[] cellPieces, GridCellIterator[] cells) {
        int maxHeight = 0;
        int cellIndex = 0;
        while (cellIndex < cells.length) {
            GridCellIterator cell = cells[cellIndex];
            if (cell.getVerticalAlignment() == 4) {
                maxHeight = Math.max(maxHeight, cell.getTarget().minimumSize().y);
            } else if (cellPieces[cellIndex] != null) {
                maxHeight = Math.max(maxHeight, cellPieces[cellIndex].getSize().y);
            }
            ++cellIndex;
        }
        return maxHeight;
    }

    private static PrintPiece[] layoutCellsWithFillVertAlignment(GridCellIterator[] cells, int height, int[] cellWidths, PrintPiece[] cellPieces) {
        int cellIndex = 0;
        while (cellIndex < cells.length) {
            PrintPiece piece;
            GridCellIterator cell = cells[cellIndex];
            PrintIterator iter = cell.getTarget();
            if (cell.getVerticalAlignment() == 4 && ((piece = (cellPieces[cellIndex] = PaperClips.next(iter, cellWidths[cellIndex], height))) == null || iter.hasNext())) {
                PaperClipsUtil.dispose(piece, cellPieces);
                return null;
            }
            ++cellIndex;
        }
        return cellPieces;
    }

    private void applyCellAlignment(GridCellIterator[] cells, int[] cellWidths, PrintPiece[] pieces, int rowHeight, int[] xOffsets, int[] yOffsets) {
        int horzSpacing = this.look.getMargins().getHorizontalSpacing();
        int x = 0;
        int col = 0;
        int cellIndex = 0;
        while (cellIndex < cells.length) {
            xOffsets[cellIndex] = x;
            yOffsets[cellIndex] = 0;
            GridCellIterator cell = cells[cellIndex];
            PrintPiece piece = pieces[cellIndex];
            if (piece != null) {
                Point size = piece.getSize();
                int hAlignment = GridIterator.resolveHorzAlignment(cell.getHorizontalAlignment(), this.columns[col].align);
                int n = cellIndex;
                xOffsets[n] = xOffsets[n] + GridIterator.getHorzAlignmentOffset(hAlignment, size.x, cellWidths[cellIndex]);
                int n2 = cellIndex;
                yOffsets[n2] = yOffsets[n2] + GridIterator.getVertAlignmentOffset(cell.getVerticalAlignment(), size.y, rowHeight);
            }
            x += cellWidths[cellIndex] + horzSpacing;
            col += cell.getColspan();
            ++cellIndex;
        }
    }

    private static int resolveHorzAlignment(int cellAlignment, int columnAlignment) {
        return cellAlignment == -1 ? columnAlignment : cellAlignment;
    }

    private static int getHorzAlignmentOffset(int alignment, int pieceWidth, int totalWidth) {
        if (alignment == 0x1000000) {
            return (totalWidth - pieceWidth) / 2;
        }
        if (alignment == 131072) {
            return totalWidth - pieceWidth;
        }
        return 0;
    }

    private static int getVertAlignmentOffset(int alignment, int pieceHeight, int cellHeight) {
        int offset = 0;
        if (alignment == 0x1000000) {
            offset = (cellHeight - pieceHeight) / 2;
        } else if (alignment == 1024) {
            offset = cellHeight - pieceHeight;
        }
        return offset;
    }

    private static PrintPiece createRowResult(PrintPiece[] pieces, int[] xOffsets, int[] yOffsets) {
        ArrayList<CompositeEntry> result = new ArrayList<CompositeEntry>();
        int cellIndex = 0;
        while (cellIndex < pieces.length) {
            if (pieces[cellIndex] != null) {
                result.add(new CompositeEntry(pieces[cellIndex], new Point(xOffsets[cellIndex], yOffsets[cellIndex])));
            }
            ++cellIndex;
        }
        return new CompositePiece(result);
    }

    private static boolean hasNext(GridCellIterator[] cells) {
        int i = 0;
        while (i < cells.length) {
            if (cells[i].getTarget().hasNext()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PrintPiece next(int width, int height) {
        if (!this.hasNext()) {
            PaperClips.error(1, "No more content");
        }
        GridMargins margins = this.look.getMargins();
        int[] colSizes = this.computeColumnWidths(width - this.computeMarginWidth());
        boolean headerPresent = this.header.length > 0;
        int[] headerHeights = new int[this.header.length];
        int[][] headerColSpans = new int[this.header.length][];
        PrintPiece headerPiece = null;
        if (headerPresent) {
            headerPiece = this.nextHeaderPiece(colSizes, height -= margins.getHeaderTop(), headerHeights, headerColSpans);
            if (headerPiece == null) {
                return null;
            }
            height -= headerPiece.getSize().y;
        }
        boolean footerPresent = this.footer.length > 0;
        int[] footerHeights = new int[this.footer.length];
        int[][] footerColSpans = new int[this.footer.length][];
        PrintPiece footerPiece = null;
        if (footerPresent) {
            footerPiece = this.nextFooterPiece(colSizes, height -= margins.getFooterBottom(), footerHeights, footerColSpans);
            if (footerPiece == null) {
                PaperClipsUtil.dispose(headerPiece);
                return null;
            }
            height -= footerPiece.getSize().y;
        }
        int firstRow = this.row;
        boolean topOpen = this.rowStarted;
        ArrayList bodyRows = new ArrayList();
        ArrayList bodyColSpans = new ArrayList();
        PrintPiece bodyPiece = this.nextBodyPiece(colSizes, height -= margins.getBodyTop(headerPresent, topOpen), bodyRows, bodyColSpans, footerPresent);
        if (bodyPiece == null) {
            return null;
        }
        boolean bottomOpen = this.rowStarted;
        return this.createResult(colSizes, headerPiece, headerHeights, headerColSpans, firstRow, topOpen, bodyPiece, PaperClipsUtil.toIntArray(bodyRows), PaperClipsUtil.toIntIntArray(bodyColSpans), bottomOpen, footerPiece, footerHeights, footerColSpans);
    }

    private PrintPiece nextHeaderPiece(int[] colSizes, int height, int[] rowHeights, int[][] colSpans) {
        return this.nextHeaderOrFooterPiece(colSizes, height, rowHeights, colSpans, this.look.getMargins().getHeaderVerticalSpacing(), this.header);
    }

    private PrintPiece nextFooterPiece(int[] colSizes, int height, int[] rowHeights, int[][] colSpans) {
        return this.nextHeaderOrFooterPiece(colSizes, height, rowHeights, colSpans, this.look.getMargins().getFooterVerticalSpacing(), this.footer);
    }

    private PrintPiece nextHeaderOrFooterPiece(int[] colSizes, int height, int[] rowHeights, int[][] colSpans, int rowSpacing, GridCellIterator[][] headerOrFooter) {
        int y = 0;
        ArrayList<CompositeEntry> entries = new ArrayList<CompositeEntry>();
        int rowIndex = 0;
        while (rowIndex < headerOrFooter.length) {
            GridCellIterator[] row = GridIterator.cloneRow(headerOrFooter[rowIndex]);
            colSpans[rowIndex] = new int[row.length];
            int cellIndex = 0;
            while (cellIndex < row.length) {
                colSpans[rowIndex][cellIndex] = row[cellIndex].getColspan();
                ++cellIndex;
            }
            PrintPiece rowPiece = this.nextRow(row, colSizes, height - y, false);
            boolean hasNext = GridIterator.hasNext(row);
            if (rowPiece == null || hasNext) {
                PaperClipsUtil.dispose(rowPiece);
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    CompositeEntry entry = (CompositeEntry)iter.next();
                    entry.dispose();
                }
                return null;
            }
            int rowHeight = rowHeights[rowIndex] = rowPiece.getSize().y;
            entries.add(new CompositeEntry(rowPiece, new Point(0, y)));
            y += rowHeight + rowSpacing;
            ++rowIndex;
        }
        return new CompositePiece(entries);
    }

    private PrintPiece nextBodyPiece(int[] colSizes, int height, List rowHeights, List colSpans, boolean footerPresent) {
        GridMargins margins = this.look.getMargins();
        int rowSpacing = margins.getBodyVerticalSpacing();
        int bodyBottomSpacingOpen = margins.getBodyBottom(footerPresent, true);
        int bodyBottomSpacingClosed = margins.getBodyBottom(footerPresent, false);
        int y = 0;
        ArrayList<CompositeEntry> entries = new ArrayList<CompositeEntry>();
        while (this.hasNext()) {
            GridCellIterator[] thisRow = GridIterator.cloneRow(this.body[this.row]);
            PrintPiece rowPiece = this.nextRow(thisRow, colSizes, height - y - bodyBottomSpacingClosed, this.rowStarted);
            boolean hasNext = GridIterator.hasNext(thisRow);
            if ((this.cellClippingEnabled || entries.isEmpty()) && (rowPiece == null || hasNext)) {
                thisRow = GridIterator.cloneRow(this.body[this.row]);
                rowPiece = this.nextRow(thisRow, colSizes, height - y - bodyBottomSpacingOpen, true);
                hasNext = true;
            }
            if (rowPiece == null) break;
            entries.add(new CompositeEntry(rowPiece, new Point(0, y)));
            this.body[this.row] = thisRow;
            int[] rowColSpans = new int[thisRow.length];
            int cellIndex = 0;
            while (cellIndex < rowColSpans.length) {
                rowColSpans[cellIndex] = thisRow[cellIndex].getColspan();
                ++cellIndex;
            }
            colSpans.add(rowColSpans);
            int rowHeight = rowPiece.getSize().y;
            rowHeights.add(new Integer(rowHeight));
            this.rowStarted = hasNext;
            if (hasNext) break;
            y += rowHeight + rowSpacing;
            ++this.row;
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new CompositePiece(entries);
    }

    private static GridCellIterator[] cloneRow(GridCellIterator[] row) {
        GridCellIterator[] result = (GridCellIterator[])row.clone();
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].copy();
            ++i;
        }
        return result;
    }

    private PrintPiece createResult(int[] colSizes, PrintPiece headerPiece, int[] headerRows, int[][] headerColSpans, int firstRow, boolean topOpen, PrintPiece bodyPiece, int[] bodyRows, int[][] bodyColSpans, boolean bottomOpen, PrintPiece footerPiece, int[] footerRows, int[][] footerColSpans) {
        if (bodyPiece == null) {
            if (headerPiece != null) {
                headerPiece.dispose();
            }
            if (footerPiece != null) {
                footerPiece.dispose();
            }
            return null;
        }
        ArrayList<CompositeEntry> sections = new ArrayList<CompositeEntry>();
        GridLookPainterPiece lookPiece = new GridLookPainterPiece(this.look, colSizes, headerRows, headerColSpans, firstRow, topOpen, bodyRows, bodyColSpans, bottomOpen, footerRows, footerColSpans);
        sections.add(new CompositeEntry(lookPiece, new Point(0, 0)));
        GridMargins margins = this.look.getMargins();
        int x = margins.getLeft();
        int y = 0;
        if (headerPiece != null) {
            y = margins.getHeaderTop();
            sections.add(new CompositeEntry(headerPiece, new Point(x, y)));
            y += headerPiece.getSize().y;
        }
        sections.add(new CompositeEntry(bodyPiece, new Point(x, y += margins.getBodyTop(headerPiece != null, topOpen))));
        y += bodyPiece.getSize().y + margins.getBodyBottom(footerPiece != null, bottomOpen);
        if (footerPiece != null) {
            sections.add(new CompositeEntry(footerPiece, new Point(x, y)));
        }
        return new CompositePiece(sections);
    }

    public PrintIterator copy() {
        return new GridIterator(this);
    }

    private static interface Condition {
        public boolean satisfiedBy(int var1);
    }
}

