/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.page;

import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.ResourcePool;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPiece;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class PageNumberIterator
implements PrintIterator {
    private final Device device;
    private final GC gc;
    final PageNumber pageNumber;
    final TextStyle textStyle;
    final PageNumberFormat format;
    final Point size;
    boolean hasNext = true;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PageNumberIterator(PageNumberPrint print, Device device, GC gc) {
        this.device = device;
        this.gc = gc;
        this.pageNumber = print.pageNumber;
        this.textStyle = print.textStyle;
        this.format = print.format;
        Font oldFont = gc.getFont();
        try {
            gc.setFont(ResourcePool.forDevice(device).getFont(this.textStyle.getFontData()));
            this.size = gc.textExtent(this.format.format(new PageNumber(){

                public int getPageCount() {
                    return 9999;
                }

                public int getPageNumber() {
                    return 9998;
                }
            }));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            gc.setFont(oldFont);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        gc.setFont(oldFont);
    }

    PageNumberIterator(PageNumberIterator that) {
        this.device = that.device;
        this.gc = that.gc;
        this.pageNumber = that.pageNumber;
        this.textStyle = that.textStyle;
        this.format = that.format;
        this.size = that.size;
        this.hasNext = that.hasNext;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Point minimumSize() {
        return this.size;
    }

    public Point preferredSize() {
        return this.size;
    }

    public PrintPiece next(int width, int height) {
        if (width < this.size.x || height < this.size.y) {
            return null;
        }
        Point size = new Point(this.size.x, this.size.y);
        int align = this.textStyle.getAlignment();
        if (align == 0x1000000 || align == 131072) {
            size.x = width;
        }
        PageNumberPiece piece = new PageNumberPiece(this, this.device, size);
        this.hasNext = false;
        return piece;
    }

    public PrintIterator copy() {
        return new PageNumberIterator(this);
    }
}

