/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime.example;

import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CDateTimeExampleTab
extends AbstractExampleTab {
    private CDateTime cdc;
    private int style = 1;
    private int format;
    private String pattern;
    private Locale locale;
    private Button simple;
    private Button drop;
    private Button hour12;
    private Button hour24;
    private Combo tzCombo;

    public Control createControl(Composite parent) {
        this.cdc = new CDateTime(parent, this.style);
        if (this.locale != null) {
            this.cdc.setLocale(this.locale);
        }
        if (this.format > 0) {
            this.cdc.setFormat(this.format);
        } else if (this.pattern != null) {
            this.setPattern();
        }
        return this.cdc;
    }

    public String[] createLinks() {
        return new String[]{"<a href=\"http://www.eclipse.org/nebula/widgets/cdatetime/cdatetime.php\">CDateTime Home Page</a>", "<a href=\"http://www.eclipse.org/nebula/widgets/cdatetime/snippets.php\">Snippets</a>", "<a href=\"https://bugs.eclipse.org/bugs/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=&classification=Technology&product=Nebula&component=CDateTime&long_desc_type=allwordssubstr&long_desc=&bug_file_loc_type=allwordssubstr&bug_file_loc=&status_whiteboard_type=allwordssubstr&status_whiteboard=&keywords_type=allwords&keywords=&emailtype1=substring&email1=&emailtype2=substring&email2=&bugidtype=include&bug_id=&votes=&chfieldfrom=&chfieldto=Now&chfieldvalue=&cmdtype=doit&order=Reuse+same+sort+as+last+time&field0-0-0=noop&type0-0-0=noop&value0-0-0=\">Bugs</a>"};
    }

    public void createParameters(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Group g = new Group(parent, 2048);
        g.setText("Styles:");
        g.setLayout((Layout)new GridLayout());
        g.setLayoutData((Object)new GridData(4, 4, false, false));
        this.simple = new Button((Composite)g, 32);
        this.simple.setText("Simple");
        this.simple.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CDateTimeExampleTab.this.simple.getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style | 4;
                    CDateTimeExampleTab cDateTimeExampleTab2 = CDateTimeExampleTab.this;
                    cDateTimeExampleTab2.style = cDateTimeExampleTab2.style & 0xFFFFFFFD;
                    CDateTimeExampleTab.this.drop.setSelection(false);
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xFFFFFFFB;
                }
                CDateTimeExampleTab.this.recreateAndLayout();
            }
        });
        this.drop = new Button((Composite)g, 32);
        this.drop.setText("Drop Down");
        this.drop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style | 2;
                    CDateTimeExampleTab cDateTimeExampleTab2 = CDateTimeExampleTab.this;
                    cDateTimeExampleTab2.style = cDateTimeExampleTab2.style & 0xFFFFFFFB;
                    CDateTimeExampleTab.this.simple.setSelection(false);
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xFFFFFFFD;
                }
                CDateTimeExampleTab.this.recreateAndLayout();
            }
        });
        Button b = new Button((Composite)g, 32);
        b.setText("Border");
        b.setSelection(true);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style | 1;
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xFFFFFFFE;
                }
                CDateTimeExampleTab.this.recreateAndLayout();
            }
        });
        b = new Button((Composite)g, 32);
        b.setText("Compact");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style | 0x8000;
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xFFFF7FFF;
                }
                CDateTimeExampleTab.this.recreateAndLayout();
            }
        });
        b = new Button((Composite)g, 32);
        b.setText("Spinner");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style | 0x4000000;
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xFBFFFFFF;
                }
                CDateTimeExampleTab.this.recreateAndLayout();
            }
        });
        b = new Button((Composite)g, 16);
        b.setText("Analog Clock");
        b.setSelection(true);
        b = new Button((Composite)g, 16);
        b.setText("Discrete Clock");
        b.setSelection(false);
        final Composite dc = new Composite((Composite)g, 0);
        GridData data = new GridData();
        data.exclude = true;
        dc.setLayoutData((Object)data);
        dc.setLayout((Layout)new GridLayout(2, true));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style | 0x8000000;
                    ((GridData)dc.getLayoutData()).exclude = false;
                    dc.setVisible(true);
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xF7FFFFFF;
                    ((GridData)dc.getLayoutData()).exclude = true;
                    dc.setVisible(false);
                }
                CDateTimeExampleTab.this.recreateAndLayout();
                dc.getParent().getParent().layout(true);
            }
        });
        b = new Button(dc, 16);
        b.setText("Horizontal");
        b.setSelection(false);
        data = new GridData();
        data.horizontalIndent = 20;
        b.setLayoutData((Object)data);
        b = new Button(dc, 16);
        b.setText("Vertical");
        b.setSelection(true);
        b.setLayoutData((Object)new GridData());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xFFFFF7FF;
                    CDateTimeExampleTab cDateTimeExampleTab2 = CDateTimeExampleTab.this;
                    cDateTimeExampleTab2.style = cDateTimeExampleTab2.style | 0x1000;
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xFFFFEFFF;
                    CDateTimeExampleTab cDateTimeExampleTab3 = CDateTimeExampleTab.this;
                    cDateTimeExampleTab3.style = cDateTimeExampleTab3.style | 0x800;
                }
                CDateTimeExampleTab.this.recreateAndLayout();
            }
        });
        this.hour12 = new Button((Composite)g, 32);
        this.hour12.setText("Force 12 Hour Clock");
        this.hour12.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CDateTimeExampleTab.this.hour12.getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style | 0x10000000;
                    CDateTimeExampleTab cDateTimeExampleTab2 = CDateTimeExampleTab.this;
                    cDateTimeExampleTab2.style = cDateTimeExampleTab2.style & 0xDFFFFFFF;
                    CDateTimeExampleTab.this.hour24.setSelection(false);
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xEFFFFFFF;
                }
                CDateTimeExampleTab.this.recreateAndLayout();
            }
        });
        this.hour24 = new Button((Composite)g, 32);
        this.hour24.setText("Force 24 Hour Clock");
        this.hour24.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CDateTimeExampleTab.this.hour24.getSelection()) {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style | 0x20000000;
                    CDateTimeExampleTab cDateTimeExampleTab2 = CDateTimeExampleTab.this;
                    cDateTimeExampleTab2.style = cDateTimeExampleTab2.style & 0xEFFFFFFF;
                    CDateTimeExampleTab.this.hour12.setSelection(false);
                } else {
                    CDateTimeExampleTab cDateTimeExampleTab = CDateTimeExampleTab.this;
                    cDateTimeExampleTab.style = cDateTimeExampleTab.style & 0xDFFFFFFF;
                }
                CDateTimeExampleTab.this.recreateAndLayout();
            }
        });
        g = new Group(parent, 2048);
        g.setText("Settings:");
        g.setLayout((Layout)new GridLayout());
        g.setLayoutData((Object)new GridData(4, 4, false, false));
        final Combo combo1 = new Combo((Composite)g, 133124);
        combo1.add("Type in a custom pattern");
        combo1.add("MM/dd/yyyy HH:mm.ss z");
        combo1.add("dd/MM/yy HH:mm.ss");
        combo1.add("dd/MM/yy HH:mm.ss.SSS");
        combo1.add("DATE_SHORT");
        combo1.add("DATE_SHORT");
        combo1.add("DATE_MEDIUM");
        combo1.add("DATE_LONG");
        combo1.add("TIME_SHORT");
        combo1.add("TIME_MEDIUM");
        combo1.add("DATE_SHORT | TIME_SHORT");
        combo1.add("DATE_MEDIUM | TIME_MEDIUM");
        combo1.add("DATE_LONG | TIME_MEDIUM");
        combo1.select(1);
        data = new GridData(4, 4, false, false);
        data.horizontalSpan = 2;
        combo1.setLayoutData((Object)data);
        b = new Button((Composite)g, 8);
        b.setText("Set Format");
        data = new GridData(131072, 4, false, false);
        data.horizontalSpan = 2;
        b.setLayoutData((Object)data);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = combo1.getSelectionIndex();
                if (index < 3) {
                    CDateTimeExampleTab.this.pattern = combo1.getText();
                    CDateTimeExampleTab.this.format = -1;
                    CDateTimeExampleTab.this.setPattern();
                } else {
                    CDateTimeExampleTab.this.pattern = null;
                    switch (index) {
                        case 3: {
                            CDateTimeExampleTab.this.format = 0x100000;
                            break;
                        }
                        case 4: {
                            CDateTimeExampleTab.this.format = 0x200000;
                            break;
                        }
                        case 5: {
                            CDateTimeExampleTab.this.format = 0x400000;
                            break;
                        }
                        case 6: {
                            CDateTimeExampleTab.this.format = 0x800000;
                            break;
                        }
                        case 7: {
                            CDateTimeExampleTab.this.format = 0x1000000;
                            break;
                        }
                        case 8: {
                            CDateTimeExampleTab.this.format = 0x900000;
                            break;
                        }
                        case 9: {
                            CDateTimeExampleTab.this.format = 0x1200000;
                            break;
                        }
                        case 10: {
                            CDateTimeExampleTab.this.format = 0x1400000;
                        }
                    }
                    CDateTimeExampleTab.this.cdc.setFormat(CDateTimeExampleTab.this.format);
                }
                CDateTimeExampleTab.this.relayoutExample();
            }
        });
        data = new GridData(4, 4, false, false);
        data.horizontalSpan = 2;
        Button clear = new Button((Composite)g, 8);
        clear.setText("Selection to Null");
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDateTimeExampleTab.this.cdc.setSelection(null);
                CDateTimeExampleTab.this.relayoutExample();
            }
        });
        clear.setLayoutData((Object)data);
        final Combo localeCombo = new Combo((Composite)g, 12);
        localeCombo.setLayoutData((Object)data);
        Locale[] la = Locale.getAvailableLocales();
        int i = 0;
        while (i < la.length) {
            localeCombo.add(la[i].getDisplayName());
            ++i;
        }
        Object[] items = localeCombo.getItems();
        Arrays.sort(items);
        localeCombo.setItems((String[])items);
        Locale local = Locale.getDefault();
        localeCombo.select(Arrays.binarySearch(items, local.getDisplayName()));
        localeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDateTimeExampleTab.this.locale = Locale.getAvailableLocales()[localeCombo.getSelectionIndex()];
                CDateTimeExampleTab.this.cdc.setLocale(CDateTimeExampleTab.this.locale);
                CDateTimeExampleTab.this.relayoutExample();
            }
        });
        Label label2 = new Label((Composite)g, 0);
        label2.setLayoutData((Object)data);
        label2.setText("Comma separated timezones to roll");
        this.tzCombo = new Combo((Composite)g, 2048);
        this.tzCombo.setLayoutData((Object)data);
        Object[] zones = TimeZone.getAvailableIDs();
        Arrays.sort(zones);
        this.tzCombo.add("UTC, CET, CAT, EAT");
        int i2 = 0;
        while (i2 < zones.length) {
            this.tzCombo.add((String)zones[i2]);
            ++i2;
        }
        this.tzCombo.setText("UTC, CET, CAT, EAT");
    }

    protected void setPattern() {
        if (this.pattern.endsWith("z")) {
            String[] zones = this.tzCombo.getText().split(",");
            TimeZone[] tZones = new TimeZone[zones.length];
            int i = 0;
            while (i < zones.length) {
                tZones[i] = TimeZone.getTimeZone(zones[i].trim());
                ++i;
            }
            this.cdc.setPattern(this.pattern, tZones);
            this.cdc.setTimeZone(tZones[0]);
        } else {
            this.cdc.setPattern(this.pattern);
            this.cdc.setTimeZone(null);
        }
    }

    private void recreateAndLayout() {
        this.recreateExample();
        this.relayoutExample();
    }
}

