/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable.day.internal;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.compositetable.timeeditor.CalendarableItem;
import org.eclipse.swt.graphics.Point;

public class EventLayoutComputer {
    private static final int START = 0;
    private static final int END = 1;
    private final int numberOfDivisionsInHour;

    public EventLayoutComputer(int numberOfDivisionsInHour) {
        this.numberOfDivisionsInHour = numberOfDivisionsInHour;
    }

    private int computeBaseSlot(GregorianCalendar gc) {
        return gc.get(11) * this.numberOfDivisionsInHour;
    }

    private float computeAdditionalSlots(GregorianCalendar gc) {
        return (float)gc.get(12) / 60.0f * (float)this.numberOfDivisionsInHour;
    }

    private int getSlotForStartTime(Date time) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(time);
        return this.computeBaseSlot(gc) + (int)this.computeAdditionalSlots(gc);
    }

    private int getSlotForEndTime(Date time) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(time);
        int baseSlot = this.computeBaseSlot(gc);
        float additionalSlots = this.computeAdditionalSlots(gc);
        return this.keepExtraTimeIfEndTimePushesIntoNextTimeSlot(baseSlot, additionalSlots);
    }

    private int keepExtraTimeIfEndTimePushesIntoNextTimeSlot(int baseSlot, float additionalSlots) {
        if (additionalSlots % (float)((int)additionalSlots) > 0.0f) {
            return baseSlot + (int)additionalSlots;
        }
        return baseSlot + (int)additionalSlots - 1;
    }

    private int[] getSlotsForEvent(CalendarableItem event) {
        int startTime = this.getSlotForStartTime(event.getStartTime());
        int endTime = this.getSlotForEndTime(event.getEndTime());
        if (endTime >= startTime) {
            return new int[]{startTime, endTime};
        }
        return new int[]{startTime, startTime};
    }

    public CalendarableItem[][] computeEventLayout(List calendarables) {
        int eventColumn;
        int[] slotsEventSpans;
        CalendarableItem event;
        Collections.sort(calendarables, CalendarableItem.comparator);
        int timeSlotsInDay = 24 * this.numberOfDivisionsInHour;
        EventLayout eventLayout = new EventLayout(timeSlotsInDay);
        Iterator eventsIter = calendarables.iterator();
        while (eventsIter.hasNext()) {
            event = (CalendarableItem)eventsIter.next();
            if (event.isAllDayEvent()) continue;
            slotsEventSpans = this.getSlotsForEvent(event);
            eventColumn = this.findColumnForEvent(eventLayout, slotsEventSpans);
            this.placeEvent(event, eventLayout.getLayout(), eventColumn, slotsEventSpans);
        }
        eventsIter = calendarables.iterator();
        block1: while (eventsIter.hasNext()) {
            event = (CalendarableItem)eventsIter.next();
            if (event.isAllDayEvent()) continue;
            slotsEventSpans = this.getSlotsForEvent(event);
            eventColumn = this.findEventColumn(event, eventLayout.getLayout(), slotsEventSpans);
            if (eventColumn >= eventLayout.getNumberOfColumns()) continue;
            int nextColumn = eventColumn + 1;
            while (nextColumn < eventLayout.getNumberOfColumns()) {
                if (!this.columnIsAvailable(nextColumn, eventLayout.getLayout(), slotsEventSpans)) continue block1;
                this.placeEvent(event, eventLayout.getLayout(), nextColumn, slotsEventSpans);
                ++nextColumn;
            }
        }
        return eventLayout.getLayout();
    }

    private int findEventColumn(CalendarableItem event, CalendarableItem[][] layout, int[] slotsEventSpans) {
        int column = 0;
        while (column < layout.length) {
            if (layout[column][slotsEventSpans[0]] == event) {
                return column;
            }
            ++column;
        }
        throw new IndexOutOfBoundsException("Could not find event");
    }

    private int findColumnForEvent(EventLayout eventLayout, int[] slotsEventSpans) {
        int currentColumn = 0;
        CalendarableItem[][] layout;
        while (!this.columnIsAvailable(currentColumn, layout = eventLayout.getLayout(), slotsEventSpans)) {
            if (this.isNewColumnNeeded(currentColumn, layout)) {
                eventLayout.addColumn();
            }
            ++currentColumn;
        }
        return currentColumn;
    }

    private boolean columnIsAvailable(int column, CalendarableItem[][] layout, int[] slotsEventSpans) {
        int currentSlot = slotsEventSpans[0];
        while (currentSlot <= slotsEventSpans[1]) {
            if (this.isSlotAlreadyOccupiedInColumn(currentSlot, layout, column)) {
                return false;
            }
            ++currentSlot;
        }
        return true;
    }

    private void placeEvent(CalendarableItem event, CalendarableItem[][] eventLayout, int currentColumn, int[] slotsEventSpans) {
        int slot = slotsEventSpans[0];
        while (slot <= slotsEventSpans[1]) {
            eventLayout[currentColumn][slot] = event;
            Point position = new Point(currentColumn, slot);
            if (event.getUpperLeftPositionInDayRowCoordinates() == null) {
                event.setUpperLeftPositionInDayRowCoordinates(position);
            } else {
                event.setLowerRightPositionInDayRowCoordinates(position);
            }
            ++slot;
        }
    }

    private boolean isSlotAlreadyOccupiedInColumn(int slot, CalendarableItem[][] layout, int currentColumn) {
        return layout[currentColumn][slot] != null;
    }

    private boolean isNewColumnNeeded(int currentColumn, CalendarableItem[][] layout) {
        return currentColumn >= layout.length - 1;
    }

    private class EventLayout {
        private CalendarableItem[][] eventLayout;
        private final int timeSlotsInDay;

        public EventLayout(int timeSlotsInDay) {
            this.timeSlotsInDay = timeSlotsInDay;
            this.eventLayout = new CalendarableItem[1][timeSlotsInDay];
            this.initializeColumn(0, timeSlotsInDay);
        }

        private void initializeColumn(int column, int timeSlotsInDay) {
            this.eventLayout[column] = new CalendarableItem[timeSlotsInDay];
            int slot = 0;
            while (slot < this.eventLayout[column].length) {
                this.eventLayout[column][slot] = null;
                ++slot;
            }
        }

        public void addColumn() {
            CalendarableItem[][] old = this.eventLayout;
            this.eventLayout = new CalendarableItem[old.length + 1][this.timeSlotsInDay];
            int i = 0;
            while (i < old.length) {
                this.eventLayout[i] = old[i];
                ++i;
            }
            this.initializeColumn(this.eventLayout.length - 1, this.timeSlotsInDay);
        }

        public CalendarableItem[][] getLayout() {
            return this.eventLayout;
        }

        public int getNumberOfColumns() {
            return this.eventLayout.length;
        }
    }
}

