/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class GridItem
extends Item {
    private static final int NO_ROW = -1;
    private List<GridItem> children;
    @Deprecated
    private Color defaultBackground;
    @Deprecated
    private Font defaultFont;
    @Deprecated
    private Color defaultForeground;
    private int height = 1;
    private boolean expanded = false;
    private boolean hasChildren = false;
    private int level = 0;
    private final Grid parent;
    private GridItem parentItem;
    private boolean visible = true;
    private String headerText = null;
    private Image headerImage = null;
    private Color headerBackground = null;
    public Color headerForeground = null;
    private boolean hasSetData = false;
    private int row = -1;
    private final Object ROW_LOCK = new Object();

    public GridItem(Grid parent, int style) {
        this(parent, style, -1);
    }

    public GridItem(Grid parent, int style, int index) {
        super((Widget)parent, style, index);
        this.parent = parent;
        this.row = parent.newItem(this, index, true);
        parent.newRootItem(this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowIndex() {
        Object object = this.ROW_LOCK;
        synchronized (object) {
            if (this.row != -1) {
                return this.row;
            }
        }
        return this.parent.indexOf(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseRow() {
        Object object = this.ROW_LOCK;
        synchronized (object) {
            ++this.row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseRow() {
        Object object = this.ROW_LOCK;
        synchronized (object) {
            --this.row;
        }
    }

    public GridItem(GridItem parent, int style) {
        this(parent, style, -1);
    }

    public GridItem(GridItem parent, int style, int index) {
        super((Widget)parent, style, index);
        this.parentItem = parent;
        this.parent = this.parentItem.getParent();
        this.row = this.parent.newItem(this, index, false);
        this.level = this.parentItem.getLevel() + 1;
        this.parentItem.newItem(this, index);
        this.parentItem.indexOf(this);
        if (parent.isVisible() && parent.isExpanded()) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public void dispose() {
        if (!this.parent.isDisposing()) {
            this.parent.removeItem(this);
            if (this.parentItem != null) {
                this.parentItem.remove(this);
            } else {
                this.parent.removeRootItem(this);
            }
            if (this.hasChildren) {
                int i = this.children.size() - 1;
                while (i >= 0) {
                    this.children.get(i).dispose();
                    --i;
                }
            }
        }
        if (this.parent.getDataVisualizer() != null) {
            this.parent.getDataVisualizer().clearRow(this);
        }
        this.noRow();
        super.dispose();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(11, (Listener)typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(11, (SWTEventListener)listener);
    }

    public void fireEvent(int eventId) {
        this.checkWidget();
        Event e = new Event();
        e.display = this.getDisplay();
        e.widget = this;
        e.item = this;
        e.type = eventId;
        this.getParent().notifyListeners(eventId, e);
    }

    public void fireCheckEvent(int column) {
        this.checkWidget();
        Event selectionEvent = new Event();
        selectionEvent.display = this.getDisplay();
        selectionEvent.widget = this;
        selectionEvent.item = this;
        selectionEvent.type = 13;
        selectionEvent.detail = 32;
        selectionEvent.index = column;
        this.getParent().notifyListeners(13, selectionEvent);
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.defaultBackground == null) {
            return this.parent.getBackground();
        }
        return this.defaultBackground;
    }

    public Color getBackground(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.parent.getDataVisualizer().getBackground(this, index);
    }

    public Rectangle getBounds(int columnIndex) {
        this.checkWidget();
        if (!this.isVisible()) {
            return new Rectangle(-1000, -1000, 0, 0);
        }
        if (!this.parent.isShown(this)) {
            return new Rectangle(-1000, -1000, 0, 0);
        }
        Point origin = this.parent.getOrigin(this.parent.getColumn(columnIndex), this);
        if (origin.x < 0 && this.parent.isRowHeaderVisible()) {
            return new Rectangle(-1000, -1000, 0, 0);
        }
        Point cellSize = this.getCellSize(columnIndex);
        return new Rectangle(origin.x, origin.y, cellSize.x, cellSize.y);
    }

    protected Point getCellSize(int columnIndex) {
        int width = 0;
        int span = this.getColumnSpan(columnIndex);
        int i = 0;
        while (i <= span) {
            if (this.parent.getColumnCount() <= columnIndex + i) break;
            width += this.parent.getColumn(columnIndex + i).getWidth();
            ++i;
        }
        int indexOfCurrentItem = this.parent.getIndexOfItem(this);
        GridItem item = this.parent.getItem(indexOfCurrentItem);
        int height = item.getHeight();
        span = this.getRowSpan(columnIndex);
        int itemCount = this.parent.getItemCount();
        int i2 = 1;
        while (i2 <= span) {
            if (itemCount <= indexOfCurrentItem + i2) break;
            item = this.parent.getItem(indexOfCurrentItem + i2);
            if (item.isVisible()) {
                height += item.getHeight() + 1;
            }
            ++i2;
        }
        return new Point(width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        return this.parent.getDataVisualizer().getChecked(this, 0);
    }

    public boolean getChecked(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.parent.getDataVisualizer().getChecked(this, index);
    }

    public int getColumnSpan(int index) {
        this.checkWidget();
        return this.parent.getDataVisualizer().getColumnSpan(this, index);
    }

    public int getRowSpan(int index) {
        this.checkWidget();
        return this.parent.getDataVisualizer().getRowSpan(this, index);
    }

    public Font getFont() {
        if (this.defaultFont == null) {
            return this.parent.getFont();
        }
        return this.defaultFont;
    }

    public Font getFont(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.parent.getDataVisualizer().getFont(this, index);
    }

    public Color getForeground() {
        if (this.defaultForeground == null) {
            return this.parent.getForeground();
        }
        return this.defaultForeground;
    }

    public Color getForeground(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.parent.getDataVisualizer().getForeground(this, index);
    }

    public boolean getGrayed() {
        return this.getGrayed(0);
    }

    public boolean getGrayed(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.parent.getDataVisualizer().getGrayed(this, index);
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public Image getImage() {
        this.checkWidget();
        return this.parent.getDataVisualizer().getImage(this, 0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.parent.getDataVisualizer().getImage(this, index);
    }

    public GridItem getItem(int index) {
        this.checkWidget();
        if (!this.hasChildren) {
            throw new IllegalArgumentException("GridItem has no children!");
        }
        return this.children.get(index);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.hasChildren) {
            return 0;
        }
        return this.children.size();
    }

    public int indexOf(GridItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.isDisposed()) {
            SWT.error((int)5);
        }
        if (!this.hasChildren) {
            throw new IllegalArgumentException("GridItem has no children!");
        }
        return this.children.indexOf((Object)item);
    }

    public GridItem[] getItems() {
        if (!this.hasChildren) {
            return new GridItem[0];
        }
        return this.children.toArray(new GridItem[this.children.size()]);
    }

    public int getLevel() {
        this.checkWidget();
        return this.level;
    }

    public Grid getParent() {
        this.checkWidget();
        return this.parent;
    }

    public GridItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public String getText() {
        this.checkWidget();
        return this.parent.getDataVisualizer().getText(this, 0);
    }

    public String getText(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.parent.getDataVisualizer().getText(this, index);
    }

    public boolean hasChildren() {
        this.checkWidget();
        return this.hasChildren;
    }

    public boolean isExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public void setBackground(Color background) {
        this.checkWidget();
        if (background != null && background.isDisposed()) {
            SWT.error((int)5);
        }
        this.defaultBackground = background;
        this.parent.redraw();
    }

    public void setBackground(int index, Color background) {
        this.checkWidget();
        if (background != null && background.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent.getDataVisualizer().setBackground(this, index, background);
        this.parent.redraw();
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        this.parent.getDataVisualizer().setChecked(this, 0, checked);
        this.parent.redraw();
    }

    public void setChecked(int index, boolean checked) {
        this.checkWidget();
        this.parent.getDataVisualizer().setChecked(this, index, checked);
        this.parent.redraw();
    }

    public void setColumnSpan(int index, int span) {
        this.checkWidget();
        this.parent.getDataVisualizer().setColumnSpan(this, index, span);
        this.parent.setHasSpanning(true);
        this.parent.redraw();
    }

    public void setRowSpan(int index, int span) {
        this.checkWidget();
        this.parent.getDataVisualizer().setRowSpan(this, index, span);
        this.parent.setHasSpanning(true);
        this.parent.redraw();
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        boolean unselected = false;
        if (this.hasChildren) {
            for (GridItem item : this.children) {
                item.setVisible(expanded && this.visible);
                if (expanded) continue;
                if (!this.getParent().getCellSelectionEnabled()) {
                    if (this.getParent().isSelected(item)) {
                        unselected = true;
                        this.getParent().deselect(item.getRowIndex());
                    }
                    if (!this.deselectChildren(item)) continue;
                    unselected = true;
                    continue;
                }
                if (!this.deselectCells(item)) continue;
                unselected = true;
            }
        }
        this.getParent().topIndex = -1;
        this.getParent().bottomIndex = -1;
        this.getParent().setScrollValuesObsolete();
        if (unselected) {
            Event e = new Event();
            e.item = this;
            this.getParent().notifyListeners(13, e);
        }
        if (this.getParent().getFocusItem() != null && !this.getParent().getFocusItem().isVisible()) {
            this.getParent().setFocusItem(this);
        }
        if (this.getParent().getCellSelectionEnabled()) {
            this.getParent().updateColumnSelection();
        }
    }

    private boolean deselectCells(GridItem item) {
        boolean flag = false;
        int index = item.getRowIndex();
        GridColumn[] columns = this.getParent().getColumns();
        int i = 0;
        while (i < columns.length) {
            Point cell = new Point(this.getParent().indexOf(columns[i]), index);
            if (this.getParent().isCellSelected(cell)) {
                flag = true;
                this.getParent().deselectCell(cell);
            }
            ++i;
        }
        GridItem[] kids = item.getItems();
        int i2 = 0;
        while (i2 < kids.length) {
            if (this.deselectCells(kids[i2])) {
                flag = true;
            }
            ++i2;
        }
        return flag;
    }

    private boolean deselectChildren(GridItem item) {
        boolean flag = false;
        GridItem[] kids = item.getItems();
        int i = 0;
        while (i < kids.length) {
            if (this.getParent().isSelected(kids[i])) {
                flag = true;
            }
            this.getParent().deselect(kids[i].getRowIndex());
            if (this.deselectChildren(kids[i])) {
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public void setFont(Font f) {
        this.checkWidget();
        if (f != null && f.isDisposed()) {
            SWT.error((int)5);
        }
        this.defaultFont = f;
        this.parent.redraw();
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent.getDataVisualizer().setFont(this, index, font);
        this.parent.redraw();
    }

    public void setForeground(Color foreground) {
        this.checkWidget();
        if (foreground != null && foreground.isDisposed()) {
            SWT.error((int)5);
        }
        this.defaultForeground = foreground;
        this.parent.redraw();
    }

    public void setForeground(int index, Color foreground) {
        this.checkWidget();
        if (foreground != null && foreground.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent.getDataVisualizer().setForeground(this, index, foreground);
        this.parent.redraw();
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        this.parent.getDataVisualizer().setGrayed(this, 0, grayed);
        this.parent.redraw();
    }

    public void setGrayed(int index, boolean grayed) {
        this.checkWidget();
        this.parent.getDataVisualizer().setGrayed(this, index, grayed);
        this.parent.redraw();
    }

    public void setHeight(int newHeight) {
        this.checkWidget();
        if (newHeight < 1) {
            SWT.error((int)5);
        }
        this.height = newHeight;
        this.parent.hasDifferingHeights = true;
        if (this.isVisible()) {
            int myIndex = this.getRowIndex();
            if (this.parent.getTopIndex() <= myIndex && myIndex <= this.parent.getBottomIndex()) {
                this.parent.bottomIndex = -1;
            }
        }
        this.parent.setScrollValuesObsolete();
        this.parent.redraw();
    }

    public void pack() {
        this.checkWidget();
        int maxPrefHeight = 2;
        GridColumn[] columns = this.parent.getColumns();
        GC gc = new GC((Drawable)this.parent);
        int cnt = 0;
        while (cnt < columns.length) {
            if (columns[cnt].isVisible()) {
                GridCellRenderer renderer = columns[cnt].getCellRenderer();
                renderer.setAlignment(columns[cnt].getAlignment());
                renderer.setCheck(columns[cnt].isCheck());
                renderer.setColumn(cnt);
                renderer.setTree(columns[cnt].isTree());
                renderer.setWordWrap(columns[cnt].getWordWrap());
                Point size = renderer.computeSize(gc, columns[cnt].getWidth(), -1, (Object)this);
                if (size != null) {
                    maxPrefHeight = Math.max(maxPrefHeight, size.y);
                }
            }
            ++cnt;
        }
        gc.dispose();
        this.setHeight(maxPrefHeight);
    }

    public void setImage(Image image) {
        this.parent.getDataVisualizer().setImage(this, 0, image);
        this.parent.redraw();
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent.getDataVisualizer().setImage(this, index, image);
        this.parent.imageSetOnItem(index, this);
        this.parent.redraw();
    }

    public void setText(int index, String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        this.parent.getDataVisualizer().setText(this, index, text);
        this.parent.redraw();
    }

    public void setText(String string) {
        this.parent.getDataVisualizer().setText(this, 0, string);
        this.parent.redraw();
    }

    private void remove(GridItem child) {
        if (!this.hasChildren) {
            throw new IllegalArgumentException("GridItem has no children!");
        }
        this.children.remove((Object)child);
        this.parent.getDataVisualizer().clearRow(child);
        this.hasChildren = !this.children.isEmpty();
    }

    public boolean isVisible() {
        return this.visible;
    }

    void newItem(GridItem item, int index) {
        this.setHasChildren(true);
        if (this.children == null) {
            this.children = new ArrayList<GridItem>();
        }
        if (index == -1) {
            this.children.add(item);
        } else {
            this.children.add(index, item);
        }
    }

    void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        if (visible) {
            this.parent.updateVisibleItems(1);
        } else {
            this.parent.updateVisibleItems(-1);
        }
        if (this.hasChildren) {
            boolean childrenVisible = visible;
            if (visible) {
                childrenVisible = this.expanded;
            }
            for (GridItem item : this.children) {
                item.setVisible(childrenVisible);
            }
        }
    }

    public String getHeaderText() {
        this.checkWidget();
        return this.headerText;
    }

    public Image getHeaderImage() {
        this.checkWidget();
        return this.headerImage;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return this.headerBackground;
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return this.headerForeground;
    }

    public void setHeaderText(String text) {
        this.checkWidget();
        if (text != this.headerText) {
            GC gc = new GC((Drawable)this.parent);
            int oldWidth = this.headerText == null ? 0 : this.parent.getRowHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)this)).x;
            this.headerText = text;
            int newWidth = this.parent.getRowHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)this)).x;
            gc.dispose();
            this.parent.recalculateRowHeaderWidth(this, oldWidth, newWidth);
        }
        this.parent.redraw();
    }

    public void setHeaderImage(Image image) {
        this.checkWidget();
        if (image != this.headerImage) {
            GC gc = new GC((Drawable)this.parent);
            int oldWidth = this.parent.getRowHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)this)).x;
            int oldHeight = this.parent.getRowHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)this)).y;
            this.headerImage = image;
            int newWidth = this.parent.getRowHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)this)).x;
            int newHeight = this.parent.getRowHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)this)).y;
            gc.dispose();
            this.parent.recalculateRowHeaderWidth(this, oldWidth, newWidth);
            this.parent.recalculateRowHeaderHeight(this, oldHeight, newHeight);
        }
        this.parent.redraw();
    }

    public void setHeaderBackground(Color headerBackground) {
        this.checkWidget();
        this.headerBackground = headerBackground;
        this.parent.redraw();
    }

    public void setHeaderForeground(Color headerForeground) {
        this.checkWidget();
        this.headerForeground = headerForeground;
        this.parent.redraw();
    }

    public boolean getCheckable(int index) {
        this.checkWidget();
        if (!this.parent.getColumn(index).getCheckable()) {
            return false;
        }
        return this.parent.getDataVisualizer().getCheckable(this, index);
    }

    public void setCheckable(int index, boolean checked) {
        this.checkWidget();
        this.parent.getDataVisualizer().setCheckable(this, index, checked);
    }

    public String getToolTipText(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.parent.getDataVisualizer().getToolTipText(this, index);
    }

    public void setToolTipText(int index, String tooltip) {
        this.checkWidget();
        this.parent.getDataVisualizer().setToolTipText(this, index, tooltip);
    }

    void columnAdded(int index) {
        this.hasSetData = false;
    }

    private void handleVirtual() {
        if ((this.getParent().getStyle() & 0x10000000) != 0 && !this.hasSetData) {
            this.hasSetData = true;
            Event event = new Event();
            event.item = this;
            event.index = this.parentItem == null ? this.getRowIndex() : this.parentItem.indexOf(this);
            this.getParent().notifyListeners(36, event);
        }
    }

    void initializeHeight(int height) {
        this.height = height;
    }

    void setHasSetData(boolean hasSetData) {
        this.hasSetData = hasSetData;
    }

    void clear(boolean allChildren) {
        this.defaultForeground = null;
        this.defaultBackground = null;
        this.defaultFont = null;
        this.hasSetData = false;
        this.headerText = null;
        this.headerImage = null;
        this.headerBackground = null;
        this.headerForeground = null;
        if (allChildren && this.hasChildren) {
            int i = this.children.size() - 1;
            while (i >= 0) {
                this.children.get(i).clear(true);
                --i;
            }
        }
    }

    public void disposeOnly() {
        if (this.hasChildren) {
            int i = this.children.size() - 1;
            while (i >= 0) {
                this.children.get(i).disposeOnly();
                --i;
            }
        }
        if (this.parent.getDataVisualizer() != null) {
            this.parent.getDataVisualizer().clearRow(this);
        }
        this.noRow();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noRow() {
        Object object = this.ROW_LOCK;
        synchronized (object) {
            this.row = -1;
        }
    }
}

