/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pgroup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.pgroup.AbstractGroupStrategy;
import org.eclipse.nebula.widgets.pgroup.AbstractRenderer;
import org.eclipse.nebula.widgets.pgroup.AbstractToolItemRenderer;
import org.eclipse.nebula.widgets.pgroup.ChevronsToggleRenderer;
import org.eclipse.nebula.widgets.pgroup.PGroupToolItem;
import org.eclipse.nebula.widgets.pgroup.RectangleGroupStrategy;
import org.eclipse.nebula.widgets.pgroup.SimpleToolItemRenderer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class PGroup
extends Canvas {
    private AbstractGroupStrategy strategy;
    private Image image;
    private String text = "";
    private Font initialFont;
    private int imagePosition = 16384;
    private int togglePosition = 131072;
    private int linePosition = 0x1000000;
    private boolean expanded = true;
    private boolean overToggle = false;
    private AbstractRenderer toggleRenderer;
    private AbstractToolItemRenderer toolItemRenderer;
    private Color backgroundColor;
    private List toolitems = new ArrayList();
    private PGroupToolItem activeToolItem;

    private static int checkStyle(int style) {
        int mask = 0x6010000;
        return style & mask | 0x20000000;
    }

    public PGroup(Composite parent, int style) {
        super(parent, PGroup.checkStyle(style));
        this.setStrategy(new RectangleGroupStrategy());
        this.setToggleRenderer(new ChevronsToggleRenderer());
        this.setToolItemRenderer(new SimpleToolItemRenderer());
        this.initialFont = new Font((Device)this.getDisplay(), this.getFont().getFontData()[0].getName(), this.getFont().getFontData()[0].getHeight(), 1);
        super.setFont(this.initialFont);
        this.strategy.initialize(this);
        this.initListeners();
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.backgroundColor == null) {
            return super.getBackground();
        }
        return this.backgroundColor;
    }

    Color internalGetBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.backgroundColor = color;
        this.redraw();
    }

    public AbstractRenderer getToggleRenderer() {
        this.checkWidget();
        return this.toggleRenderer;
    }

    public void setToggleRenderer(AbstractRenderer toggleRenderer) {
        this.checkWidget();
        this.toggleRenderer = toggleRenderer;
        this.strategy.update();
        this.redraw();
    }

    private void initListeners() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PGroup.this.onDispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PGroup.this.onPaint(e);
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                PGroup.this.redraw();
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                PGroup.this.redraw();
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                PGroup.this.onKeyDown(e);
            }
        });
        this.addListener(7, new Listener(){

            public void handleEvent(Event e) {
                PGroup.this.onMouseExit(e);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                PGroup.this.onMouseMove(e);
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                PGroup.this.onMouseDown(e);
            }
        });
    }

    private void onPaint(PaintEvent e) {
        Color back = e.gc.getBackground();
        Color fore = e.gc.getForeground();
        this.strategy.paint(e.gc);
        e.gc.setBackground(back);
        e.gc.setForeground(fore);
        if (this.toggleRenderer != null) {
            this.toggleRenderer.setExpanded(this.expanded);
            this.toggleRenderer.setFocus(this.isFocusControl());
            this.toggleRenderer.setHover(this.overToggle);
            this.toggleRenderer.paint(e.gc, (Object)this);
        }
        if (this.toolItemRenderer != null && this.toolitems.size() > 0) {
            this.paintToolItems(e.gc);
        }
    }

    private void paintToolItems(GC gc) {
        Rectangle itemArea = this.strategy.getToolItemArea();
        if (itemArea != null) {
            PGroupToolItem item;
            int spacing = 3;
            Iterator it = this.toolitems.iterator();
            AbstractToolItemRenderer toolitemRenderer = this.getToolItemRenderer();
            Point[] sizes = new Point[this.toolitems.size()];
            boolean min = false;
            int width = 0;
            int i = 0;
            while (it.hasNext()) {
                item = (PGroupToolItem)((Object)it.next());
                Point p = toolitemRenderer.computeSize(gc, item, 1);
                sizes[i++] = p;
                if (width + spacing + p.x > itemArea.width) {
                    min = true;
                    break;
                }
                width += p.x + spacing;
            }
            if (min) {
                toolitemRenderer.setSizeType(2);
            } else {
                toolitemRenderer.setSizeType(1);
            }
            if (min) {
                it = this.toolitems.iterator();
                i = 0;
                while (it.hasNext()) {
                    item = (PGroupToolItem)((Object)it.next());
                    sizes[i++] = toolitemRenderer.computeSize(gc, item, 2);
                }
            }
            it = this.toolitems.iterator();
            int x = itemArea.x;
            i = 0;
            while (it.hasNext()) {
                PGroupToolItem item2 = (PGroupToolItem)((Object)it.next());
                Point p = sizes[i++];
                Rectangle rect = new Rectangle(x, itemArea.y, p.x, itemArea.height);
                item2.setBounds(rect);
                toolitemRenderer.setBounds(rect);
                x += p.x + spacing;
                if ((item2.getStyle() & 4) != 0) {
                    item2.setDropDownArea(toolitemRenderer.computeDropDownArea(item2.getBounds()));
                }
                toolitemRenderer.setHover(this.activeToolItem == item2);
                toolitemRenderer.paint(gc, (Object)item2);
            }
        }
    }

    private void onKeyDown(Event e) {
        if (e.character == ' ' || e.character == '\r') {
            this.setExpanded(!this.getExpanded());
            if (this.expanded) {
                this.notifyListeners(17, new Event());
            } else {
                this.notifyListeners(18, new Event());
            }
        }
    }

    private void onMouseMove(Event e) {
        boolean newOverToggle = this.strategy.isToggleLocation(e.x, e.y);
        boolean redraw = false;
        if (newOverToggle != this.overToggle) {
            if (newOverToggle) {
                this.setCursor(this.getDisplay().getSystemCursor(21));
            } else {
                this.setCursor(null);
            }
            this.overToggle = newOverToggle;
            redraw = true;
        }
        if (this.toolitems.size() > 0) {
            Iterator it = this.toolitems.iterator();
            PGroupToolItem newItem = null;
            while (it.hasNext()) {
                PGroupToolItem item = (PGroupToolItem)((Object)it.next());
                if (!item.getBounds().contains(e.x, e.y)) continue;
                newItem = item;
                break;
            }
            if (newItem != this.activeToolItem) {
                this.activeToolItem = newItem;
                this.setToolTipText(null);
                if (newItem != null && newItem.getToolTipText() != null) {
                    this.setToolTipText(newItem.getToolTipText());
                }
                redraw = true;
            }
        }
        if (redraw) {
            this.redraw();
        }
    }

    private void onMouseExit(Event e) {
        this.setCursor(null);
        this.overToggle = false;
        this.redraw();
    }

    private void onMouseDown(Event e) {
        if (this.overToggle && e.button == 1) {
            this.setExpanded(!this.expanded);
            this.setFocus();
            if (this.expanded) {
                this.notifyListeners(17, new Event());
            } else {
                this.notifyListeners(18, new Event());
            }
        } else if (this.activeToolItem != null) {
            this.activeToolItem.onMouseDown(e);
        }
    }

    public AbstractGroupStrategy getStrategy() {
        this.checkWidget();
        return this.strategy;
    }

    public void setStrategy(AbstractGroupStrategy strategy) {
        this.checkWidget();
        if (strategy == null) {
            SWT.error((int)4);
        }
        this.strategy = strategy;
        this.setForeground(null);
        strategy.initialize(this);
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error((int)5);
        }
        this.image = image;
        this.strategy.update();
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.strategy.update();
        this.redraw();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        this.text = text;
        this.strategy.update();
        this.redraw();
    }

    public Point computeSize(int arg0, int arg1, boolean arg2) {
        this.checkWidget();
        if (this.getExpanded()) {
            return super.computeSize(arg0, arg1, arg2);
        }
        Rectangle trim = this.strategy.computeTrim(0, 0, 0, 0);
        trim.width = super.computeSize((int)arg0, (int)arg1, (boolean)arg2).x;
        return new Point(trim.width, Math.max(trim.height, arg1));
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        Control[] kids = this.getChildren();
        int i = 0;
        while (i < kids.length) {
            kids[i].setVisible(expanded);
            ++i;
        }
        this.expanded = expanded;
        this.getParent().layout();
        this.redraw();
    }

    private void onDispose() {
        this.strategy.dispose();
        if (this.initialFont != null) {
            this.initialFont.dispose();
        }
    }

    public void addExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(17, (Listener)typedListener);
        this.addListener(18, (Listener)typedListener);
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(17, (SWTEventListener)listener);
        this.removeListener(18, (SWTEventListener)listener);
    }

    public int getImagePosition() {
        this.checkWidget();
        return this.imagePosition;
    }

    public void setImagePosition(int imagePosition) {
        this.checkWidget();
        this.imagePosition = imagePosition;
        this.strategy.update();
        this.redraw();
    }

    public int getTogglePosition() {
        this.checkWidget();
        return this.togglePosition;
    }

    public void setTogglePosition(int togglePosition) {
        this.checkWidget();
        this.togglePosition = togglePosition;
        this.strategy.update();
        this.redraw();
    }

    public int getLinePosition() {
        this.checkWidget();
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.checkWidget();
        this.linePosition = linePosition;
        this.strategy.update();
        this.redraw();
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        return this.strategy.computeTrim(x, y, width, height);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.getExpanded()) {
            return this.strategy.getClientArea();
        }
        return new Rectangle(-10, 0, 0, 0);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    void addToolItem(PGroupToolItem toolitem) {
        this.toolitems.add(toolitem);
    }

    void removeToolItem(PGroupToolItem toolitem) {
        this.toolitems.remove((Object)toolitem);
    }

    public AbstractToolItemRenderer getToolItemRenderer() {
        return this.toolItemRenderer;
    }

    public void setToolItemRenderer(AbstractToolItemRenderer toolItemRenderer) {
        this.checkWidget();
        this.toolItemRenderer = toolItemRenderer;
        this.strategy.update();
        this.redraw();
    }

    public PGroupToolItem[] getToolItems() {
        PGroupToolItem[] rv = new PGroupToolItem[this.toolitems.size()];
        this.toolitems.toArray(rv);
        return rv;
    }
}

