/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerColumnSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.ListDialogSortable;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ColumnMultiEditAction
extends Action {
    private final XViewer xViewer;
    static LabelProvider treeColumnLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof TreeColumn) {
                return ((TreeColumn)element).getText();
            }
            return "Unknown element type";
        }
    };

    public ColumnMultiEditAction(XViewer xViewer) {
        super(XViewerText.get("ColumnMultiEditAction.text"));
        this.xViewer = xViewer;
    }

    public static Set<TreeColumn> getEditableTreeColumns(XViewer xViewer, Collection<TreeItem> selectedTreeItems) {
        HashSet<TreeColumn> editableColumns = new HashSet<TreeColumn>();
        TreeColumn[] treeColumnArray = xViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeCol = treeColumnArray[n2];
            if (xViewer.isColumnMultiEditable(treeCol, selectedTreeItems)) {
                editableColumns.add(treeCol);
            }
            ++n2;
        }
        return editableColumns;
    }

    public void run() {
        List<TreeItem> selectedTreeItems = Arrays.asList(this.xViewer.getTree().getSelection());
        Set<TreeColumn> editableColumns = ColumnMultiEditAction.getEditableTreeColumns(this.xViewer, selectedTreeItems);
        if (editableColumns.isEmpty()) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_columns.multi_editable"));
            return;
        }
        ListDialogSortable ld = new ListDialogSortable(new XViewerColumnSorter(), this.xViewer.getTree().getShell());
        ld.setMessage(XViewerText.get("ColumnMultiEditAction.title"));
        ld.setInput(editableColumns);
        ld.setLabelProvider((ILabelProvider)treeColumnLabelProvider);
        ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        ld.setTitle(XViewerText.get("ColumnMultiEditAction.title"));
        int result = ld.open();
        if (result != 0) {
            return;
        }
        this.xViewer.handleColumnMultiEdit((TreeColumn)ld.getResult()[0], selectedTreeItems);
    }
}

