/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.column;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerComputedColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;

public class XViewerDaysTillTodayColumn
extends XViewerComputedColumn {
    private static final String ID = "ats.computed.daysTillToday";

    public XViewerDaysTillTodayColumn() {
        this(ID);
    }

    private XViewerDaysTillTodayColumn(String id) {
        super(id, XViewerText.get("column.daysTillToday.name"), 30, 16384, false, XViewerColumn.SortDataType.Integer, false, XViewerText.get("column.daysTillToday.description"));
    }

    @Override
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) throws XViewerException {
        Date date1Date;
        block10: {
            String dateStr;
            block9: {
                if (this.sourceXViewerColumn == null) {
                    return String.format(XViewerText.get("error.no_source_column"), this.id);
                }
                try {
                    int sourceColumnNum = this.xViewer.getCustomizeMgr().getColumnNumFromXViewerColumn(this.sourceXViewerColumn);
                    dateStr = ((IXViewerLabelProvider)this.xViewer.getLabelProvider()).getColumnText(element, sourceColumnNum);
                    if (dateStr != null && !dateStr.equals("")) break block9;
                    return "";
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }
            SimpleDateFormat format = dateStr.length() == 10 ? XViewerSorter.format10 : new SimpleDateFormat();
            date1Date = null;
            try {
                date1Date = format.parse(dateStr);
            }
            catch (ParseException parseException) {
                try {
                    date1Date = DateFormat.getInstance().parse(dateStr);
                }
                catch (ParseException ex2) {
                    XViewerLog.log(Activator.class, Level.SEVERE, ex2);
                }
            }
            if (date1Date != null) break block10;
            return "Can't parse date";
        }
        return String.valueOf(XViewerLib.daysTillToday(date1Date));
    }

    @Override
    public boolean isApplicableFor(XViewerColumn xViewerColumn) {
        return xViewerColumn.getSortDataType() == XViewerColumn.SortDataType.Date;
    }

    @Override
    public String getName() {
        if (this.sourceXViewerColumn == null) {
            return XViewerText.get("column.daysTillToday.name");
        }
        return String.valueOf(XViewerText.get("column.daysTillToday.name2")) + " " + this.sourceXViewerColumn.getName();
    }

    @Override
    public XViewerDaysTillTodayColumn copy() {
        XViewerDaysTillTodayColumn col = new XViewerDaysTillTodayColumn();
        col.setXViewer(this.getXViewer());
        col.setSourceXViewerColumn(this.getSourceXViewerColumn());
        return col;
    }

    @Override
    public String getId() {
        if (this.sourceXViewerColumn == null) {
            return ID;
        }
        return "ats.computed.daysTillToday(" + this.sourceXViewerColumn.getId() + ")";
    }

    @Override
    public boolean isApplicableFor(String storedId) {
        return storedId.startsWith(ID);
    }

    @Override
    public XViewerComputedColumn createFromStored(XViewerColumn storedColumn) {
        return new XViewerDaysTillTodayColumn(storedColumn.getId());
    }
}

