/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.xviewer.util.internal.XmlUtil;

public class ColumnFilterData {
    private static final String COLUMN_FILTER_TAG = "xColFilter";
    private static final String COLUMN_ID_TAG = "id";
    private static final String FILTER_TEXT_TAG = "str";
    private final Map<String, String> colIdToFilterText = new HashMap<String, String>();
    private static Pattern p = Pattern.compile("<xColFilter>(.*?)</xColFilter>");

    public String getFilterText(String colId) {
        return this.colIdToFilterText.get(colId);
    }

    public Set<String> getColIds() {
        return this.colIdToFilterText.keySet();
    }

    public void setFilterText(String colId, String filterText) {
        this.colIdToFilterText.put(colId, filterText);
    }

    public void clear() {
        this.colIdToFilterText.clear();
    }

    public void removeFilterText(String colId) {
        this.colIdToFilterText.remove(colId);
    }

    public String getXml() {
        StringBuffer sb = new StringBuffer();
        for (String colId : this.colIdToFilterText.keySet()) {
            sb.append(XmlUtil.addTagData(COLUMN_FILTER_TAG, String.valueOf(XmlUtil.addTagData(COLUMN_ID_TAG, colId)) + XmlUtil.addTagData(FILTER_TEXT_TAG, this.colIdToFilterText.get(colId))));
        }
        return sb.toString();
    }

    public void setFromXml(String xml) {
        this.colIdToFilterText.clear();
        Matcher columnMatch = p.matcher(xml);
        while (columnMatch.find()) {
            this.colIdToFilterText.put(XmlUtil.getTagData(columnMatch.group(1), COLUMN_ID_TAG), XmlUtil.getTagData(columnMatch.group(1), FILTER_TEXT_TAG));
        }
    }

    public String toString() {
        return "colFilter:[" + this.colIdToFilterText.toString() + "]";
    }

    public boolean isFiltered() {
        return this.colIdToFilterText.size() > 0;
    }
}

