/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize;

import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FilterDataUI {
    private Text filterText;
    private final XViewer xViewer;
    private final boolean filterRealTime;
    private Button regularExpression;

    public FilterDataUI(XViewer xViewer, boolean filterRealTime) {
        this.xViewer = xViewer;
        this.filterRealTime = filterRealTime;
    }

    public void createWidgets(Composite comp) {
        Label label = new Label(comp, 0);
        label.setText(XViewerText.get("label.filter"));
        label.setToolTipText(XViewerText.get("FilterDataUI.prompt.tooltip"));
        GridData gd = new GridData(131072, 0, false, false);
        label.setLayoutData((Object)gd);
        this.filterText = new Text(comp, 2052);
        gd = new GridData(131072, 0, false, false);
        gd.widthHint = 100;
        this.filterText.setLayoutData((Object)gd);
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050 || FilterDataUI.this.filterRealTime) {
                    String newText = FilterDataUI.this.filterText.getText();
                    FilterDataUI.this.xViewer.getCustomizeMgr().setFilterText(newText, FilterDataUI.this.isRegularExpression());
                }
            }
        });
        Label filterLabel = new Label(comp, 0);
        filterLabel.setLayoutData((Object)new GridData(131072, 0, false, false));
        filterLabel.setImage(XViewerLib.getImage("clear.gif"));
        filterLabel.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                FilterDataUI.this.filterText.setText("");
                FilterDataUI.this.xViewer.getCustomizeMgr().setFilterText("", FilterDataUI.this.isRegularExpression());
            }
        });
        this.regularExpression = new Button(comp, 32);
        this.regularExpression.setText(XViewerText.get("regex.prompt"));
        this.regularExpression.setToolTipText(XViewerText.get("regex.prompt.tooltip"));
        this.regularExpression.setLayoutData((Object)new GridData(131072, 0, false, false));
        this.regularExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterDataUI.this.xViewer.getCustomizeMgr().setFilterText(FilterDataUI.this.filterText.getText(), FilterDataUI.this.isRegularExpression());
            }
        });
    }

    public boolean isRegularExpression() {
        if (this.regularExpression != null && !this.regularExpression.isDisposed()) {
            return this.regularExpression.getSelection();
        }
        return false;
    }

    public void update() {
        if (!this.xViewer.getCustomizeMgr().getFilterText().equals(this.filterText.getText())) {
            this.filterText.setText(this.xViewer.getCustomizeMgr().getFilterText());
        }
    }

    public void setFocus() {
        if (this.filterText != null && !this.filterText.isDisposed()) {
            this.filterText.setFocus();
        }
    }

    public void addFilterTextListener(KeyListener keyListener) {
        if (this.filterText != null && !this.filterText.isDisposed()) {
            this.filterText.addKeyListener(keyListener);
        }
    }

    public void clear() {
        this.filterText.setText("");
        this.xViewer.getCustomizeMgr().setFilterText("", this.isRegularExpression());
    }

    public void appendToStatusLabel(StringBuffer sb) {
        if (this.filterText != null && !this.filterText.getText().equals("")) {
            sb.append(XViewerText.get("status.text_filter"));
        }
    }
}

