/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize.dialog;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerColumnLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerColumnSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.customize.ColumnFilterData;
import org.eclipse.nebula.widgets.xviewer.customize.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.customize.CustomizeDataLabelProvider;
import org.eclipse.nebula.widgets.xviewer.customize.CustomizeManager;
import org.eclipse.nebula.widgets.xviewer.customize.SortingData;
import org.eclipse.nebula.widgets.xviewer.customize.dialog.CustomizationDataSelectionDialog;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;
import org.eclipse.nebula.widgets.xviewer.util.internal.ArrayTreeContentProvider;
import org.eclipse.nebula.widgets.xviewer.util.internal.CollectionsUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerFilteredTree;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.DialogWithEntry;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerCustomizeDialog
extends MessageDialog {
    private static String[] buttons = new String[]{XViewerText.get("button.ok"), XViewerText.get("button.apply"), XViewerText.get("button.cancel")};
    private final XViewer xViewerToCustomize;
    private XViewerFilteredTree custTable;
    protected XViewerFilteredTree hiddenColTable;
    protected XViewerFilteredTree visibleColTable;
    private Text sorterText;
    private Text filterText;
    private Button filterRegExCheckBox;
    private Text columnFilterText;
    Button setDefaultButton;
    Button deleteButton;
    Button addItemButton;
    Button addAllItemButton;
    Button removeItemButton;
    Button removeAllItemButton;
    Button moveUpButton;
    Button moveDownButton;
    Button saveButton;
    Button renameButton;
    private static final String SET_AS_DEFAULT = XViewerText.get("button.set_default");
    private static final String REMOVE_DEFAULT = XViewerText.get("button.remove_default");
    private String title = XViewerText.get("XViewerCustomizeDialog.title");
    boolean isFeedbackAfter = false;
    boolean isShowSorterBlock = true;
    boolean isShowFilterTextBlock = true;
    boolean isShowColumnFilterTextBlock = true;
    DragSourceAdapter hiddenTableDragListener = new DragSourceAdapter(){

        public void dragStart(DragSourceEvent event) {
            if (XViewerCustomizeDialog.this.hiddenColTable.getViewer().getSelection().isEmpty()) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                List<XViewerColumn> selCols = XViewerCustomizeDialog.this.getHiddenTableSelection();
                ArrayList<String> ids = new ArrayList<String>(selCols.size());
                for (XViewerColumn xCol : selCols) {
                    ids.add(xCol.getId());
                }
                event.data = CollectionsUtil.toString(ids, null, ", ", null);
            }
        }
    };
    DropTargetAdapter hiddenTableDropListener = new DropTargetAdapter(){

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (event.data instanceof String) {
                XViewerCustomizeDialog.this.performHiddenTableTextDrop(event);
            }
        }

        public void dragOver(DropTargetEvent event) {
            XViewerCustomizeDialog.this.performHiddenTableDragOver(event);
        }

        public void dropAccept(DropTargetEvent event) {
        }
    };
    DragSourceAdapter visibleTableDragListener = new DragSourceAdapter(){

        public void dragStart(DragSourceEvent event) {
            if (XViewerCustomizeDialog.this.visibleColTable.getViewer().getSelection().isEmpty()) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                List<XViewerColumn> selCols = XViewerCustomizeDialog.this.getVisibleTableSelection();
                ArrayList<String> ids = new ArrayList<String>(selCols.size());
                for (XViewerColumn xCol : selCols) {
                    ids.add(xCol.getId());
                }
                event.data = CollectionsUtil.toString(ids, null, ", ", null);
            }
        }
    };
    DropTargetAdapter visibleTableDropListener = new DropTargetAdapter(){

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (event.data instanceof String) {
                XViewerCustomizeDialog.this.performVisibleTableTextDrop(event);
            }
        }

        public void dragOver(DropTargetEvent event) {
            XViewerCustomizeDialog.this.performVisibleTableDragOver(event);
        }

        public void dropAccept(DropTargetEvent event) {
        }
    };
    private CustomizeData selectedCustTableCustData = null;

    public XViewerCustomizeDialog(XViewer xViewer) {
        this(xViewer, Display.getCurrent().getActiveShell());
    }

    private XViewerCustomizeDialog(XViewer xViewer, Shell parentShell) {
        super(parentShell, "", null, "", 0, buttons, 0);
        this.xViewerToCustomize = xViewer;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void performHiddenTableDragOver(DropTargetEvent event) {
        if (!TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
            return;
        }
        if (event.widget != this.visibleColTable) {
            return;
        }
        event.detail = 2;
    }

    public void performHiddenTableTextDrop(DropTargetEvent event) {
        String droppedIds = (String)event.data;
        ArrayList<XViewerColumn> droppedVisibleTableXCols = new ArrayList<XViewerColumn>();
        List orderCols = (List)this.visibleColTable.getViewer().getInput();
        for (XViewerColumn xCol : orderCols) {
            if (!droppedIds.contains(xCol.getId())) continue;
            droppedVisibleTableXCols.add(xCol);
        }
        this.moveFromVisibleToHidden(droppedVisibleTableXCols);
    }

    public void performVisibleTableTextDrop(DropTargetEvent event) {
        Tree tree = this.visibleColTable.getViewer().getTree();
        TreeItem dragOverTreeItem = tree.getItem(this.visibleColTable.getViewer().getTree().toControl(event.x, event.y));
        String droppedIds = (String)event.data;
        XViewerColumn dragOverXCol = null;
        if (dragOverTreeItem != null && droppedIds.contains((dragOverXCol = (XViewerColumn)dragOverTreeItem.getData()).getId())) {
            return;
        }
        ArrayList<XViewerColumn> droppedXCols = new ArrayList<XViewerColumn>();
        List orderCols = (List)this.visibleColTable.getViewer().getInput();
        for (XViewerColumn xCol : orderCols) {
            if (!droppedIds.contains(xCol.getId())) continue;
            droppedXCols.add(xCol);
        }
        for (XViewerColumn xCol : (List)this.hiddenColTable.getViewer().getInput()) {
            if (!droppedIds.contains(xCol.getId())) continue;
            droppedXCols.add(xCol);
        }
        orderCols.removeAll(droppedXCols);
        int dropXColOrderColsIndex = 0;
        for (XViewerColumn xCol : (List)this.visibleColTable.getViewer().getInput()) {
            if (dragOverXCol != null && xCol.getId().equals(dragOverXCol.getId())) break;
            ++dropXColOrderColsIndex;
        }
        if (this.isFeedbackAfter) {
            orderCols.addAll(dropXColOrderColsIndex + 1, droppedXCols);
        } else {
            orderCols.addAll(dropXColOrderColsIndex, droppedXCols);
        }
        this.visibleColTable.getViewer().setInput((Object)orderCols);
        List hiddenCols = (List)this.hiddenColTable.getViewer().getInput();
        hiddenCols.removeAll(droppedXCols);
        this.hiddenColTable.getViewer().setInput((Object)hiddenCols);
    }

    public void performVisibleTableDragOver(DropTargetEvent event) {
        if (!TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
            return;
        }
        Tree tree = this.visibleColTable.getViewer().getTree();
        TreeItem dragOverTreeItem = tree.getItem(this.visibleColTable.getViewer().getTree().toControl(event.x, event.y));
        if (dragOverTreeItem == null) {
            return;
        }
        event.feedback = 16;
        event.detail = 0;
        IStructuredSelection selectedItem = (IStructuredSelection)this.visibleColTable.getViewer().getSelection();
        if (selectedItem == null || selectedItem.isEmpty()) {
            selectedItem = (IStructuredSelection)this.hiddenColTable.getViewer().getSelection();
        }
        if (selectedItem == null) {
            return;
        }
        Object obj = selectedItem.getFirstElement();
        if (obj instanceof XViewerColumn) {
            event.feedback = this.isFeedbackAfter ? 4 : 2;
            event.detail = 2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        if (this.getShell() != null) {
            this.getShell().setText(this.title);
        }
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 700;
        comp.setLayoutData((Object)gd);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 2;
        comp.setLayout((Layout)gridLayout_2);
        Label namespaceLabel = new Label(comp, 0);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        namespaceLabel.setLayoutData((Object)gridData);
        namespaceLabel.setText(MessageFormat.format(XViewerText.get("namespace"), this.xViewerToCustomize.getXViewerFactory().getNamespace()));
        this.createSelectCustomizationSection(comp);
        Group configureColumnsGroup = new Group(comp, 0);
        configureColumnsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        configureColumnsGroup.setText(XViewerText.get("XViewerCustomizeDialog.text"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 3;
        gridLayout.numColumns = 3;
        configureColumnsGroup.setLayout((Layout)gridLayout);
        this.createHiddenButtonsComposition((Composite)configureColumnsGroup);
        this.createMoveButtons((Composite)configureColumnsGroup);
        this.createVisibleButtonsComposition((Composite)configureColumnsGroup);
        gridLayout.numColumns = 3;
        gridLayout.numColumns = 3;
        Composite composite_2 = new Composite((Composite)configureColumnsGroup, 0);
        composite_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 3;
        composite_2.setLayout((Layout)gridLayout_3);
        if (this.isShowSorterBlock) {
            this.createSorterTextBlock(composite_2);
        }
        if (this.isShowFilterTextBlock) {
            this.createFilterTextBlock(composite_2);
        }
        if (this.isShowColumnFilterTextBlock) {
            this.createColumnFilterTextBlock(composite_2);
        }
        this.createConfigCustomizationButtonBar(composite_2);
        try {
            this.loadCustomizeTable();
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
        this.updateButtonEnablements();
        return comp;
    }

    private void createSelectCustomizationSection(Composite comp) {
        Composite custComp = new Composite(comp, 0);
        GridData gd_composite_6 = new GridData(4, 4, true, true);
        custComp.setLayoutData((Object)gd_composite_6);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.marginWidth = 0;
        gridLayout_1.marginHeight = 0;
        custComp.setLayout((Layout)gridLayout_1);
        Label selectCustomizationLabel = new Label(custComp, 0);
        selectCustomizationLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        selectCustomizationLabel.setText(XViewerText.get("XViewerCustomizeDialog.prompt"));
        this.custTable = new XViewerFilteredTree(custComp, 2048);
        Tree table_2 = this.custTable.getViewer().getTree();
        GridData gd_table_2 = new GridData(4, 4, true, true);
        gd_table_2.heightHint = 270;
        gd_table_2.widthHint = 200;
        table_2.setLayoutData((Object)gd_table_2);
        this.custTable.getViewer().setLabelProvider((IBaseLabelProvider)new CustomizeDataLabelProvider(this.xViewerToCustomize));
        this.custTable.getViewer().setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.custTable.getViewer().setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (((CustomizeData)e1).getName().startsWith("-")) {
                    return -1;
                }
                if (((CustomizeData)e2).getName().startsWith("-")) {
                    return 1;
                }
                return this.getComparator().compare(((CustomizeData)e1).getName(), ((CustomizeData)e2).getName());
            }
        });
        this.custTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XViewerCustomizeDialog.this.handleCustTableSelectionChanged();
                XViewerCustomizeDialog.this.updateButtonEnablements();
                XViewerCustomizeDialog.this.storeCustTableSelection();
            }
        });
        Composite composite = new Composite(custComp, 0);
        composite.setLayoutData((Object)new GridData());
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 4;
        composite.setLayout((Layout)gridLayout_7);
        this.setDefaultButton = new Button(composite, 0);
        this.setDefaultButton.setLayoutData((Object)new GridData());
        this.setDefaultButton.setText(SET_AS_DEFAULT);
        this.setDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleSetDefaultButton();
                XViewerCustomizeDialog.this.updateButtonEnablements();
            }
        });
        this.deleteButton = new Button(composite, 0);
        this.deleteButton.setLayoutData((Object)new GridData());
        this.deleteButton.setText(XViewerText.get("button.delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleDeleteButton();
                XViewerCustomizeDialog.this.updateButtonEnablements();
            }
        });
    }

    private void createConfigCustomizationButtonBar(Composite composite) {
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 5;
        composite_1.setLayout((Layout)gridLayout_10);
        this.renameButton = new Button(composite_1, 0);
        this.renameButton.setText(XViewerText.get("button.rename"));
        this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleRenameButton();
            }
        });
        this.saveButton = new Button(composite_1, 0);
        this.saveButton.setText(XViewerText.get("button.save"));
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleSaveButton();
            }
        });
    }

    private void createColumnFilterTextBlock(Composite composite) {
        Composite composite_8 = new Composite(composite, 0);
        composite_8.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 3;
        composite_8.setLayout((Layout)gridLayout_14);
        Label columnFilterLabel = new Label(composite_8, 0);
        columnFilterLabel.setText(XViewerText.get("XViewerCustomizeDialog.filter.column"));
        this.columnFilterText = new Text(composite_8, 2048);
        this.columnFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label clearColumnFilterLabel = new Label(composite_8, 8);
        clearColumnFilterLabel.setImage(XViewerLib.getImage("clear.gif"));
        clearColumnFilterLabel.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                XViewerCustomizeDialog.this.columnFilterText.setText("");
            }
        });
    }

    private void createFilterTextBlock(Composite composite) {
        Composite composite_7 = new Composite(composite, 0);
        composite_7.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 5;
        composite_7.setLayout((Layout)gridLayout_13);
        Label filterLabel = new Label(composite_7, 0);
        filterLabel.setText(XViewerText.get("XViewerCustomizeDialog.filter.text"));
        this.filterText = new Text(composite_7, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label filterLabel2 = new Label(composite_7, 0);
        filterLabel2.setText(XViewerText.get("XViewerCustomizeDialog.filter.expression"));
        this.filterRegExCheckBox = new Button(composite_7, 32);
        this.filterRegExCheckBox.setLayoutData((Object)new GridData(131072, 0, false, false));
        Label clearFilterLabel = new Label(composite_7, 8);
        clearFilterLabel.setImage(XViewerLib.getImage("clear.gif"));
        clearFilterLabel.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                XViewerCustomizeDialog.this.filterText.setText("");
            }
        });
    }

    private void createSorterTextBlock(Composite composite) {
        Label sorterLabel = new Label(composite, 0);
        sorterLabel.setText(XViewerText.get("XViewerCustomizeDialog.sorter"));
        this.sorterText = new Text(composite, 2048);
        this.sorterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label clearSorterLabel = new Label(composite, 8);
        clearSorterLabel.setImage(XViewerLib.getImage("clear.gif"));
        clearSorterLabel.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                XViewerCustomizeDialog.this.sorterText.setText("");
            }
        });
    }

    private void createVisibleButtonsComposition(Composite parent) {
        Composite visibleTableComp = new Composite(parent, 0);
        visibleTableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.marginWidth = 0;
        gridLayout_6.marginHeight = 0;
        visibleTableComp.setLayout((Layout)gridLayout_6);
        Label visibleColumnsLabel = new Label(visibleTableComp, 0);
        visibleColumnsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        visibleColumnsLabel.setText(XViewerText.get("heading.visible"));
        this.visibleColTable = new XViewerFilteredTree(visibleTableComp);
        Tree table = this.visibleColTable.getViewer().getTree();
        GridData gd_table = new GridData(4, 4, true, true);
        gd_table.widthHint = 300;
        table.setLayoutData((Object)gd_table);
        this.visibleColTable.getViewer().setLabelProvider((IBaseLabelProvider)new XViewerColumnLabelProvider());
        this.visibleColTable.getViewer().setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.visibleColTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XViewerCustomizeDialog.this.updateButtonEnablements();
            }
        });
        this.visibleColTable.getViewer().addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)this.visibleTableDragListener);
        this.visibleColTable.getViewer().addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)this.visibleTableDropListener);
        this.hiddenColTable.getViewer().addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)this.hiddenTableDragListener);
        this.hiddenColTable.getViewer().addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)this.hiddenTableDropListener);
    }

    private void createHiddenButtonsComposition(Composite parent) {
        Composite hiddenTableComp = new Composite(parent, 0);
        hiddenTableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.marginWidth = 0;
        gridLayout_4.marginHeight = 0;
        hiddenTableComp.setLayout((Layout)gridLayout_4);
        Label hiddenColumnsLabel = new Label(hiddenTableComp, 0);
        hiddenColumnsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        hiddenColumnsLabel.setText(XViewerText.get("heading.hidden"));
        this.hiddenColTable = new XViewerFilteredTree(hiddenTableComp);
        Tree table_1 = this.hiddenColTable.getViewer().getTree();
        GridData gd_table_1 = new GridData(4, 4, true, true, 1, 2);
        gd_table_1.widthHint = 300;
        table_1.setLayoutData((Object)gd_table_1);
        this.hiddenColTable.getViewer().setLabelProvider((IBaseLabelProvider)new XViewerColumnLabelProvider());
        this.hiddenColTable.getViewer().setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.hiddenColTable.getViewer().setSorter((ViewerSorter)new XViewerColumnSorter());
        this.hiddenColTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XViewerCustomizeDialog.this.updateButtonEnablements();
            }
        });
    }

    private void createMoveButtons(Composite parent) {
        Composite moveButtonComp = new Composite(parent, 0);
        moveButtonComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.marginWidth = 0;
        gridLayout_5.marginHeight = 0;
        moveButtonComp.setLayout((Layout)gridLayout_5);
        this.addItemButton = new Button(moveButtonComp, 0);
        this.addItemButton.setText(">");
        this.addItemButton.setToolTipText(XViewerText.get("button.add.tip"));
        this.addItemButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.addItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleAddItemButton();
            }
        });
        this.addAllItemButton = new Button(moveButtonComp, 0);
        this.addAllItemButton.setText(">>");
        this.addAllItemButton.setToolTipText(XViewerText.get("button.add_all.tip"));
        this.addAllItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleAddAllItemButton();
            }
        });
        this.removeItemButton = new Button(moveButtonComp, 0);
        this.removeItemButton.setText("<");
        this.removeItemButton.setToolTipText(XViewerText.get("button.remove.tip"));
        this.removeItemButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.removeItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleRemoveItemButton();
            }
        });
        this.removeAllItemButton = new Button(moveButtonComp, 0);
        this.removeAllItemButton.setText("<<");
        this.removeAllItemButton.setToolTipText(XViewerText.get("button.remove_all.tip"));
        this.removeAllItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleRemoveAllItemButton();
            }
        });
        this.moveUpButton = new Button(moveButtonComp, 0);
        this.moveUpButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.moveUpButton.setText("^");
        this.moveUpButton.setToolTipText(XViewerText.get("button.move_up.tip"));
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleMoveUpButton();
            }
        });
        this.moveDownButton = new Button(moveButtonComp, 0);
        this.moveDownButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.moveDownButton.setText("v");
        this.moveDownButton.setToolTipText(XViewerText.get("button.move_down.tip"));
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                XViewerCustomizeDialog.this.handleMoveDownButton();
            }
        });
    }

    private void handleAddItemButton() {
        List<XViewerColumn> hiddenSelCols = this.getHiddenTableSelection();
        if (hiddenSelCols == null) {
            return;
        }
        List hiddenCols = (List)this.hiddenColTable.getViewer().getInput();
        hiddenCols.removeAll(hiddenSelCols);
        this.hiddenColTable.getViewer().setInput((Object)hiddenCols);
        List visibleCols = (List)this.visibleColTable.getViewer().getInput();
        visibleCols.addAll(hiddenSelCols);
        this.visibleColTable.getViewer().setInput((Object)visibleCols);
    }

    private void handleRemoveItemButton() {
        List<XViewerColumn> visibleSelCols = this.getVisibleTableSelection();
        if (visibleSelCols != null && visibleSelCols.size() != 0) {
            this.moveFromVisibleToHidden(visibleSelCols);
        }
    }

    protected void moveFromVisibleToHidden(List<XViewerColumn> visibleSelCols) {
        if (visibleSelCols == null || visibleSelCols.isEmpty()) {
            return;
        }
        List visibleCols = (List)this.visibleColTable.getViewer().getInput();
        visibleCols.removeAll(visibleSelCols);
        this.visibleColTable.getViewer().setInput((Object)visibleCols);
        List hiddenCols = (List)this.hiddenColTable.getViewer().getInput();
        hiddenCols.addAll(visibleSelCols);
        this.hiddenColTable.getViewer().setInput((Object)hiddenCols);
        this.updateSortTextField();
        this.updateColumnFilterField();
    }

    private void updateSortTextField() {
        if (this.sorterText == null) {
            return;
        }
        ArrayList<String> visibleColumnIds = new ArrayList<String>();
        for (XViewerColumn xCol : (List)this.visibleColTable.getViewer().getInput()) {
            visibleColumnIds.add(xCol.getId());
        }
        SortingData sortingData = new SortingData(this.sorterText.getText());
        List<String> currentSortIds = sortingData.getSortingIds();
        for (String invalidId : CollectionsUtil.setComplement(currentSortIds, visibleColumnIds)) {
            sortingData.removeSortingName(invalidId);
        }
        if (this.sorterText != null && !this.sorterText.isDisposed()) {
            this.sorterText.setText(sortingData.getXml());
        }
    }

    private void updateColumnFilterField() {
        if (this.columnFilterText == null) {
            return;
        }
        ArrayList<String> visibleColumnIds = new ArrayList<String>();
        for (XViewerColumn xCol : (List)this.visibleColTable.getViewer().getInput()) {
            visibleColumnIds.add(xCol.getId());
        }
        ColumnFilterData columnFilterData = new ColumnFilterData();
        columnFilterData.setFromXml(this.columnFilterText.getText());
        Set<String> currentSortIds = columnFilterData.getColIds();
        for (String invalidId : CollectionsUtil.setComplement(currentSortIds, visibleColumnIds)) {
            columnFilterData.removeFilterText(invalidId);
        }
        if (this.columnFilterText != null && !this.columnFilterText.isDisposed()) {
            this.columnFilterText.setText(columnFilterData.getXml());
        }
    }

    private void handleAddAllItemButton() {
        List hiddenCols = (List)this.hiddenColTable.getViewer().getInput();
        List visibleCols = (List)this.visibleColTable.getViewer().getInput();
        visibleCols.addAll(hiddenCols);
        this.visibleColTable.getViewer().setInput((Object)visibleCols);
        hiddenCols.clear();
        this.hiddenColTable.getViewer().setInput((Object)hiddenCols);
        this.updateSortTextField();
        this.updateColumnFilterField();
    }

    protected void handleAddAllItem() {
        this.handleAddAllItemButton();
    }

    private void handleRemoveAllItemButton() {
        List visibleCols = (List)this.visibleColTable.getViewer().getInput();
        List hiddenCols = (List)this.hiddenColTable.getViewer().getInput();
        hiddenCols.addAll(visibleCols);
        this.hiddenColTable.getViewer().setInput((Object)hiddenCols);
        visibleCols.clear();
        this.visibleColTable.getViewer().setInput((Object)visibleCols);
        this.updateSortTextField();
        this.updateColumnFilterField();
    }

    private void handleMoveUpButton() {
        List<XViewerColumn> selCols = this.getVisibleTableSelection();
        if (selCols == null) {
            return;
        }
        List orderCols = (List)this.visibleColTable.getViewer().getInput();
        int index = orderCols.indexOf(selCols.iterator().next());
        if (index <= 0) {
            return;
        }
        orderCols.removeAll(selCols);
        orderCols.addAll(index - 1, selCols);
        this.visibleColTable.getViewer().setInput((Object)orderCols);
        ArrayList<XViewerColumn> selected = new ArrayList<XViewerColumn>();
        selected.addAll(selCols);
        this.visibleColTable.getViewer().setSelection((ISelection)new StructuredSelection(selected.toArray(new Object[selected.size()])));
        this.visibleColTable.getViewer().getTree().setFocus();
        this.updateButtonEnablements();
    }

    private void handleMoveDownButton() {
        List<XViewerColumn> selCols = this.getVisibleTableSelection();
        if (selCols == null) {
            return;
        }
        List orderCols = (List)this.visibleColTable.getViewer().getInput();
        int index = orderCols.indexOf(selCols.iterator().next());
        if (index >= orderCols.size() - selCols.size()) {
            return;
        }
        orderCols.removeAll(selCols);
        orderCols.addAll(index + 1, selCols);
        this.visibleColTable.getViewer().setInput((Object)orderCols);
        ArrayList<XViewerColumn> selected = new ArrayList<XViewerColumn>();
        selected.addAll(selCols);
        this.visibleColTable.getViewer().setSelection((ISelection)new StructuredSelection(selected.toArray(new Object[selected.size()])));
        this.visibleColTable.getViewer().getTree().setFocus();
        this.updateButtonEnablements();
    }

    private List<XViewerColumn> getConfigCustXViewerColumns() {
        ArrayList<XViewerColumn> xCols = new ArrayList<XViewerColumn>();
        for (XViewerColumn xCol : this.getTableXViewerColumns(this.visibleColTable.getViewer())) {
            xCol.setShow(true);
            xCol.setXViewer(this.xViewerToCustomize);
            xCols.add(xCol);
        }
        for (XViewerColumn xCol : this.getTableXViewerColumns(this.hiddenColTable.getViewer())) {
            xCol.setShow(false);
            xCol.setXViewer(this.xViewerToCustomize);
            xCols.add(xCol);
        }
        return xCols;
    }

    private void handleSaveButton() {
        try {
            ArrayList<CustomizeData> custDatas = new ArrayList<CustomizeData>();
            for (CustomizeData custData : this.xViewerToCustomize.getCustomizeMgr().getSavedCustDatas()) {
                if (custData.isPersonal()) {
                    custDatas.add(custData);
                    continue;
                }
                if (!this.xViewerToCustomize.getXViewerFactory().isAdmin()) continue;
                custDatas.add(custData);
            }
            CustomizationDataSelectionDialog diag = new CustomizationDataSelectionDialog(this.xViewerToCustomize, custDatas);
            if (diag.open() == 0) {
                String name = diag.getEnteredName();
                try {
                    CustomizeData diagSelectedCustomizeData = diag.getSelectedCustData();
                    String diagEnteredNewName = diag.getEnteredName();
                    CustomizeData custData = this.getConfigCustomizeCustData();
                    if (diagEnteredNewName != null) {
                        custData.setName(name);
                        this.selectedCustTableCustData = custData;
                    } else {
                        custData.setName(diagSelectedCustomizeData.getName());
                        custData.setGuid(diagSelectedCustomizeData.getGuid());
                    }
                    custData.setPersonal(!diag.isSaveShared());
                    this.xViewerToCustomize.getCustomizeMgr().saveCustomization(custData);
                }
                catch (Exception ex) {
                    XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
                }
            }
            this.loadCustomizeTable();
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
    }

    private void handleRenameButton() {
        XViewerColumn xCol = this.getVisibleTableSelection().iterator().next();
        DialogWithEntry ed = new DialogWithEntry(Display.getCurrent().getActiveShell(), XViewerText.get("button.rename"), null, XViewerText.get("XViewerCustomizeDialog.rename.new"), 3, new String[]{XViewerText.get("button.ok"), XViewerText.get("XViewerCustomizeDialog.rename.default"), XViewerText.get("button.cancel")}, 0);
        int result = ed.open();
        if (result == 2) {
            return;
        }
        if (result == 0) {
            this.xViewerToCustomize.getCustomizeMgr().customizeColumnName(xCol, ed.getEntry());
        } else if (result == 1) {
            this.xViewerToCustomize.getCustomizeMgr().customizeColumnName(xCol, "");
        }
        this.visibleColTable.getViewer().update((Object)xCol, null);
    }

    private CustomizeData getConfigCustomizeCustData() {
        CustomizeData custData = new CustomizeData();
        custData.resetGuid();
        custData.setNameSpace(this.xViewerToCustomize.getXViewerFactory().getNamespace());
        custData.getColumnData().setColumns(this.getConfigCustXViewerColumns());
        if (this.sorterText != null) {
            custData.getSortingData().setFromXml(this.sorterText.getText());
        }
        if (this.filterText != null && this.filterRegExCheckBox != null) {
            custData.getFilterData().setFilterText(this.filterText.getText(), this.filterRegExCheckBox.getSelection());
        }
        if (this.columnFilterText != null) {
            custData.getColumnFilterData().setFromXml(this.columnFilterText.getText());
        }
        return custData;
    }

    private void handleLoadConfigCustButton() {
        this.xViewerToCustomize.getCustomizeMgr().loadCustomization(this.getConfigCustomizeCustData());
        this.xViewerToCustomize.refresh();
    }

    protected void handleLoadConfigCust() {
        this.handleLoadConfigCustButton();
    }

    private void handleSetDefaultButton() {
        try {
            CustomizeData custData = this.getCustTableSelection();
            if (custData.getName().equals(CustomizeManager.TABLE_DEFAULT_LABEL) || custData.getName().equals(CustomizeManager.CURRENT_LABEL)) {
                XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.set_default"));
                return;
            }
            if (this.xViewerToCustomize.getCustomizeMgr().isCustomizationUserDefault(custData)) {
                if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)XViewerText.get("button.remove_default"), (String)MessageFormat.format(XViewerText.get("XViewerCustomizeDialog.prompt.remove_default"), custData.getName()))) {
                    this.xViewerToCustomize.getCustomizeMgr().setUserDefaultCustData(custData, false);
                }
            } else if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)XViewerText.get("button.set_default"), (String)MessageFormat.format(XViewerText.get("XViewerCustomizeDialog.prompt.set_default"), custData.getName()))) {
                this.xViewerToCustomize.getCustomizeMgr().setUserDefaultCustData(custData, true);
            }
            this.loadCustomizeTable();
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
    }

    private void handleDeleteButton() {
        try {
            CustomizeData custSel = this.getCustTableSelection();
            if (custSel.getName().equals(CustomizeManager.TABLE_DEFAULT_LABEL) || custSel.getName().equals(CustomizeManager.CURRENT_LABEL)) {
                XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.delete_default"));
                return;
            }
            if (!custSel.isPersonal() && !this.xViewerToCustomize.getXViewerFactory().isAdmin()) {
                XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.delete_global"));
                return;
            }
            String dialogTitle = XViewerText.get("XViewerCustomizeDialog.prompt.delete.title");
            String dialogMessage = XViewerText.get("XViewerCustomizeDialog.prompt.delete");
            if (!custSel.isPersonal()) {
                dialogTitle = XViewerText.get("XViewerCustomizeDialog.prompt.delete.shared.title");
                dialogMessage = XViewerText.get("XViewerCustomizeDialog.prompt.delete.shared");
            }
            if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)dialogTitle, (String)MessageFormat.format(dialogMessage, custSel.getName()))) {
                this.xViewerToCustomize.getCustomizeMgr().deleteCustomization(custSel);
                this.loadCustomizeTable();
                this.updateButtonEnablements();
            }
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
    }

    private void updateButtonEnablements() {
        CustomizeData custData = this.getCustTableSelection();
        this.setDefaultButton.setEnabled(this.xViewerToCustomize.getXViewerFactory().getXViewerCustomizations().isCustomizationPersistAvailable() && this.custTable.getViewer().getTree().isFocusControl() && custData != null && !custData.getName().equals(CustomizeManager.TABLE_DEFAULT_LABEL) && !custData.getName().equals(CustomizeManager.CURRENT_LABEL));
        if (this.custTable.getViewer().getTree().isFocusControl() && custData != null) {
            try {
                this.setDefaultButton.setText(this.xViewerToCustomize.getCustomizeMgr().isCustomizationUserDefault(custData) ? REMOVE_DEFAULT : SET_AS_DEFAULT);
            }
            catch (XViewerException ex) {
                XViewerLog.log(Activator.class, Level.SEVERE, ex);
            }
            this.setDefaultButton.getParent().layout();
        }
        this.deleteButton.setEnabled(this.xViewerToCustomize.getXViewerFactory().getXViewerCustomizations().isCustomizationPersistAvailable() && this.custTable.getViewer().getTree().isFocusControl() && custData != null);
        this.addItemButton.setEnabled(this.hiddenColTable.getViewer().getTree().isFocusControl() && this.getHiddenTableSelection() != null);
        this.removeItemButton.setEnabled(this.visibleColTable.getViewer().getTree().isFocusControl() && this.getVisibleTableSelection() != null);
        this.renameButton.setEnabled(this.visibleColTable.getViewer().getTree().isFocusControl() && this.getVisibleTableSelection() != null && this.getVisibleTableSelection().size() == 1);
        this.moveDownButton.setEnabled(this.visibleColTable.getViewer().getTree().isFocusControl() && this.getVisibleTableSelection() != null);
        this.moveUpButton.setEnabled(this.visibleColTable.getViewer().getTree().isFocusControl() && this.getVisibleTableSelection() != null);
        this.saveButton.setEnabled(this.xViewerToCustomize.getXViewerFactory().getXViewerCustomizations() != null && this.xViewerToCustomize.getXViewerFactory().getXViewerCustomizations().isCustomizationPersistAvailable());
    }

    private void loadCustomizeTable() throws Exception {
        List<CustomizeData> custDatas = this.xViewerToCustomize.getCustomizeMgr().getSavedCustDatas();
        CustomizeData defaultTableCustData = this.xViewerToCustomize.getCustomizeMgr().getTableDefaultCustData();
        defaultTableCustData.setName(CustomizeManager.TABLE_DEFAULT_LABEL);
        custDatas.add(defaultTableCustData);
        CustomizeData currentCustData = this.xViewerToCustomize.getCustomizeMgr().generateCustDataFromTable();
        currentCustData.setName(CustomizeManager.CURRENT_LABEL);
        custDatas.add(currentCustData);
        this.custTable.getViewer().setInput(custDatas);
        this.restoreCustTableSelection();
        if (this.getCustTableSelection() == null) {
            ArrayList<CustomizeData> sel = new ArrayList<CustomizeData>();
            sel.add(currentCustData);
            this.custTable.getViewer().setSelection((ISelection)new StructuredSelection(sel.toArray(new Object[sel.size()])));
            this.custTable.getViewer().getTree().setFocus();
        }
        this.updateSortTextField();
        this.updateColumnFilterField();
        this.updateButtonEnablements();
    }

    private CustomizeData getCustTableSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.custTable.getViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Iterator i = selection.iterator();
        return (CustomizeData)i.next();
    }

    protected List<XViewerColumn> getVisibleTableSelection() {
        return this.getTableSelection(this.visibleColTable.getViewer());
    }

    protected List<XViewerColumn> getHiddenTableSelection() {
        return this.getTableSelection(this.hiddenColTable.getViewer());
    }

    private List<XViewerColumn> getTableSelection(TreeViewer xColTableViewer) {
        ArrayList<XViewerColumn> xCols = new ArrayList<XViewerColumn>();
        IStructuredSelection selection = (IStructuredSelection)xColTableViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            xCols.add((XViewerColumn)i.next());
        }
        return xCols;
    }

    private List<XViewerColumn> getTableXViewerColumns(TreeViewer xColTableViewer) {
        return (List)xColTableViewer.getInput();
    }

    private void handleCustTableSelectionChanged() {
        if (this.getCustTableSelection() == null) {
            return;
        }
        CustomizeData custData = this.getCustTableSelection();
        if (custData == null) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, new IllegalStateException("Can't obtain selection Xml"));
            return;
        }
        ArrayList<XViewerColumn> hideXCols = new ArrayList<XViewerColumn>();
        ArrayList<XViewerColumn> showXCols = new ArrayList<XViewerColumn>();
        for (XViewerColumn xCol : custData.getColumnData().getColumns()) {
            if (xCol.isShow()) {
                showXCols.add(xCol);
                continue;
            }
            hideXCols.add(xCol);
        }
        this.hiddenColTable.getViewer().setInput(hideXCols);
        this.visibleColTable.getViewer().setInput(showXCols);
        if (this.sorterText != null) {
            this.sorterText.setText(custData.getSortingData().getXml());
            this.sorterText.setData((Object)custData);
        }
        if (this.filterText != null && this.filterRegExCheckBox != null) {
            this.filterText.setText(custData.getFilterData().getFilterText());
            this.filterText.setData((Object)custData);
            this.filterRegExCheckBox.setSelection(custData.getFilterData().isRegularExpression());
        }
        if (this.columnFilterText != null) {
            this.columnFilterText.setText(custData.getColumnFilterData().getXml());
            this.columnFilterText.setData((Object)custData);
        }
        this.updateSortTextField();
        this.updateColumnFilterField();
    }

    public void storeCustTableSelection() {
        if (this.getCustTableSelection() != null) {
            this.selectedCustTableCustData = this.getCustTableSelection();
        }
    }

    public void restoreCustTableSelection() {
        if (this.selectedCustTableCustData != null) {
            ArrayList<CustomizeData> selected = new ArrayList<CustomizeData>();
            selected.add(this.selectedCustTableCustData);
            this.custTable.getViewer().setSelection((ISelection)new StructuredSelection(selected.toArray(new Object[selected.size()])));
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.handleLoadConfigCustButton();
            this.close();
        } else if (buttonId == 1) {
            this.handleLoadConfigCustButton();
        } else {
            this.close();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setShowSorterBlock(boolean isShowSorterBlock) {
        this.isShowSorterBlock = isShowSorterBlock;
    }

    public void setShowFilterTextBlock(boolean isShowFilterTextBlock) {
        this.isShowFilterTextBlock = isShowFilterTextBlock;
    }

    public void setShowColumnFilterTextBlock(boolean isShowColumnFilterTextBlock) {
        this.isShowColumnFilterTextBlock = isShowColumnFilterTextBlock;
    }
}

