/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.edit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerControlFactory;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerConverter;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerEditAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class XViewerMultiEditAdapter
extends XViewerEditAdapter {
    private IStructuredSelection currentSelection;
    private IStructuredSelection oldSelection;

    public XViewerMultiEditAdapter(XViewerControlFactory factory, XViewerConverter converter) {
        super(factory, converter);
    }

    @Override
    boolean handleEditEvent(Event event) {
        IStructuredSelection temp = (IStructuredSelection)this.xv.getSelection();
        this.oldSelection = this.currentSelection;
        this.currentSelection = temp;
        if (this.oldSelection == null || this.oldSelection.toList().size() == 1 || !this.oldSelection.toList().contains(this.currentSelection.getFirstElement())) {
            this.oldSelection = null;
        }
        if ((event.stateMask & 0x40000) == 262144 || (event.stateMask & 0x20000) == 131072) {
            return false;
        }
        boolean handled = super.handleEditEvent(event);
        if (handled && this.oldSelection != null) {
            this.xv.setSelection((ISelection)this.oldSelection);
            this.currentSelection = this.oldSelection;
        }
        return handled;
    }

    @Override
    void getInput(Control c) {
        super.getInput(c);
        if (this.oldSelection != null) {
            this.xv.setSelection((ISelection)this.oldSelection);
        }
        this.oldSelection = null;
    }

    @Override
    Object getInputToModify() {
        ArrayList<Object> selection;
        if (this.oldSelection != null) {
            selection = this.oldSelection.toList();
            Collections.sort(selection, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (XViewerMultiEditAdapter.this.klickedCell.getElement().equals(o1)) {
                        return -1;
                    }
                    if (XViewerMultiEditAdapter.this.klickedCell.getElement().equals(o2)) {
                        return 1;
                    }
                    return 0;
                }
            });
        } else {
            selection = new ArrayList<Object>();
            selection.add(super.getInputToModify());
        }
        return selection;
    }

    @Override
    void refreshElement(Object toRefresh) {
        if (toRefresh instanceof List) {
            for (Object o : (List)toRefresh) {
                super.refreshElement(o);
            }
        } else {
            super.refreshElement(toRefresh);
        }
    }
}

