/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal;

import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerMouseListener
implements MouseListener {
    private final XViewer xViewer;
    private MouseEvent leftClickEvent;

    public XViewerMouseListener(XViewer xViewer) {
        this.xViewer = xViewer;
    }

    public void mouseDoubleClick(MouseEvent event) {
        Point point = new Point(event.x, event.y);
        TreeColumn column = this.xViewer.getColumnUnderMouseClick(point);
        TreeItem itemToReturn = this.xViewer.getItemUnderMouseClick(point);
        this.xViewer.handleDoubleClick(column, itemToReturn);
    }

    public void mouseDown(MouseEvent event) {
        if (this.isLeftClick(event)) {
            this.leftClickEvent = event;
        }
        if (this.isRightClick(event)) {
            this.xViewer.processRightClickMouseEvent(new Point(event.x, event.y));
        }
    }

    private boolean isRightClick(MouseEvent event) {
        return event.button == 3;
    }

    public void mouseUp(MouseEvent event) {
        TreeItem item = this.xViewer.getItemUnderMouseClick(new Point(event.x, event.y));
        if (item == null) {
            return;
        }
        try {
            TreeColumn column = this.xViewer.getColumnUnderMouseClick(new Point(event.x, event.y));
            if (column == null) {
                return;
            }
            if (this.isLeftClick(event) && this.controlNotBeingHeld(event)) {
                if (this.altIsBeingHeld(event)) {
                    this.xViewer.handleAltLeftClick(column, item);
                } else if (this.clickOccurredInIconArea(event, item)) {
                    this.xViewer.handleLeftClickInIconArea(column, item);
                } else {
                    this.xViewer.handleLeftClick(column, item);
                }
            }
            this.xViewer.updateStatusLabel();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    private boolean shiftBeingHeld(MouseEvent event) {
        return (event.stateMask & SWT.MODIFIER_MASK) == 131072;
    }

    private boolean clickOccurredInIconArea(MouseEvent event, TreeItem item) {
        Integer columnNumber = this.xViewer.getColumnNumberUnderMouseClick(new Point(event.x, event.y));
        if (columnNumber == null) {
            return false;
        }
        Rectangle rect = item.getBounds(columnNumber.intValue());
        return event.x <= rect.x + 18;
    }

    private boolean isLeftClick(MouseEvent event) {
        return event.button == 1;
    }

    private boolean altIsBeingHeld(MouseEvent event) {
        return (event.stateMask & SWT.MODIFIER_MASK) == 65536;
    }

    private boolean controlNotBeingHeld(MouseEvent event) {
        return !this.controlBeingHeld(event);
    }

    private boolean controlBeingHeld(MouseEvent event) {
        return (event.stateMask & SWT.MODIFIER_MASK) == 262144;
    }

    public MouseEvent getLeftClickEvent() {
        return this.leftClickEvent;
    }
}

