/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw;

import org.eclipse.nebula.effects.stw.TransitionManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public abstract class Transition {
    public static final long DEFAULT_FPS = 60L;
    public static final long DEFAULT_T = 1000L;
    public static final double DIR_RIGHT = 0.0;
    public static final double DIR_UP = 90.0;
    public static final double DIR_LEFT = 180.0;
    public static final double DIR_DOWN = 270.0;
    protected TransitionManager _transitionManager;
    protected long _fps;
    protected long _T;
    private long _dt;
    private long _t;

    public Transition(TransitionManager transitionManager, long fps, long T) {
        this._transitionManager = transitionManager;
        this._fps = fps;
        this._T = T;
        this._t = 0L;
        this._dt = (long)(1000.0 / (double)this._fps);
    }

    public Transition(TransitionManager transitionManager) {
        this(transitionManager, 60L, 1000L);
    }

    public final void setFPS(long fps) {
        this._fps = fps;
        this._dt = (long)(1000.0 / (double)fps);
    }

    public final long getFPS() {
        return this._fps;
    }

    public final void setTotalTransitionTime(long T) {
        this._T = T;
    }

    public final double getTotalTransitionTime() {
        return this._T;
    }

    public final void start(Image from, Image to, GC gc, double direction) {
        boolean flag = true;
        long t0 = System.currentTimeMillis();
        long dt = 0L;
        long ttemp = 0L;
        this._t = 0L;
        ImageData fromData = from.getImageData();
        Image xitionBg = new Image((Device)Display.getCurrent(), fromData.width, fromData.height);
        GC xitionBgGC = new GC((Drawable)xitionBg);
        xitionBgGC.setBackground(this._transitionManager.backgroundColor);
        xitionBgGC.fillRectangle(0, 0, fromData.width, fromData.height);
        if (this._transitionManager.backgroundImage != null) {
            ImageData imgData = this._transitionManager.backgroundImage.getImageData();
            xitionBgGC.drawImage(this._transitionManager.backgroundImage, 0, 0, imgData.width, imgData.height, 0, 0, fromData.width, fromData.height);
        }
        xitionBgGC.dispose();
        Image xitionImg = new Image((Device)Display.getCurrent(), fromData.width, fromData.height);
        GC xitionImgGC = new GC((Drawable)xitionImg);
        xitionImgGC.drawImage(xitionBg, 0, 0);
        xitionImgGC.drawImage(from, 0, 0);
        this.initTransition(from, to, xitionImgGC, direction);
        gc.drawImage(xitionImg, 0, 0);
        while (this._t <= this._T) {
            ttemp = System.currentTimeMillis() - t0;
            dt = ttemp - this._t;
            if (flag) {
                this._t = ttemp;
            }
            if (dt >= this._dt) {
                if (this._t <= this._T) {
                    xitionImgGC.drawImage(xitionBg, 0, 0);
                    this.stepTransition(this._t, from, to, xitionImgGC, direction);
                    gc.drawImage(xitionImg, 0, 0);
                } else {
                    xitionImgGC.drawImage(xitionBg, 0, 0);
                    xitionImgGC.drawImage(to, 0, 0);
                    this.endTransition(from, to, xitionImgGC, direction);
                    gc.drawImage(xitionImg, 0, 0);
                }
                flag = true;
                this.doEvents();
                continue;
            }
            try {
                flag = false;
                Thread.sleep(this._dt - dt);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        xitionBg.dispose();
        xitionImg.dispose();
        xitionImgGC.dispose();
    }

    protected void doEvents() {
        Display.getCurrent().readAndDispatch();
    }

    protected abstract void initTransition(Image var1, Image var2, GC var3, double var4);

    protected abstract void stepTransition(long var1, Image var3, Image var4, GC var5, double var6);

    protected abstract void endTransition(Image var1, Image var2, GC var3, double var4);
}

